/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.rest.resource.api.apitokens.latest.admin;

import com.atlassian.sal.api.user.UserManager;
import com.kantegasso.ws.rs.core.KssoHttpResponse;
import io.vavr.CheckedFunction0;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.apitokens.ApiTokenService;
import org.kantega.atlaskerb.apitokens.ApiTokenV570;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteTokenAdmin {
    private static final Logger log = LoggerFactory.getLogger(DeleteTokenAdmin.class);

    public static KssoHttpResponse run(String id, ApiTokenService apiTokenService, UserManager userManager) {
        Option maybeApiTokenObject = Option.of((Object)apiTokenService.findTokenById(id));
        if (maybeApiTokenObject.isDefined()) {
            ApiTokenV570 apiTokenObject = (ApiTokenV570)maybeApiTokenObject.get();
            String description = apiTokenObject.getTokenName();
            String tokenUserName = (String)Option.of((Object)apiTokenObject.getUsername()).filter(StringUtils::isNotBlank).getOrElse((Object)"<unknown>");
            boolean deleted = (Boolean)maybeApiTokenObject.map(apiTokenService::delete).getOrElse((Object)false);
            if (deleted) {
                return KssoHttpResponse.ok((Object)("Successfully deleted API token " + description + " with ID " + apiTokenObject.getID() + " of user " + tokenUserName)).buildKssoHttpResponse();
            }
            String failedDeleteErrorMessage = "Failed to delete API token " + description + " with ID " + apiTokenObject.getID() + " of user " + tokenUserName;
            log.warn(failedDeleteErrorMessage);
            return KssoHttpResponse.status((KssoHttpResponse.KssoHttpStatus)KssoHttpResponse.KssoHttpStatus.BAD_REQUEST).entityKsso((Object)failedDeleteErrorMessage).buildKssoHttpResponse();
        }
        Try.of((CheckedFunction0 & Serializable)() -> Integer.parseInt(id)).onSuccess(idInt -> log.debug("Could not find token with id " + idInt + " to delete. ")).onFailure(_t -> log.debug("Could not find token."));
        return KssoHttpResponse.status((KssoHttpResponse.KssoHttpStatus)KssoHttpResponse.KssoHttpStatus.NOT_FOUND).buildKssoHttpResponse();
    }
}

