/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml.servlet;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.user.UserManager;
import com.kantegasso.servlet.http.HttpServletRequestFacade;
import com.kantegasso.servlet.http.HttpServletResponseFacade;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.identityproviders.IdpConfigurationBuilder;
import org.kantega.atlaskerb.identityproviders.ManagedGroup;
import org.kantega.atlaskerb.identityproviders.model.AssignGroupRule;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.utils.GroupSearchUtil;

public class IdpGroupsServlet
extends RequireAdminServlet {
    private final UserManager userManager;
    private final IdpConfManager idpConfManager;
    private final HostApp hostApp;
    private final ApplicationProperties applicationProperties;

    @Inject
    public IdpGroupsServlet(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
        this.userManager = bucket.getUserManager();
        this.idpConfManager = bucket.getIdpConfManager();
        this.applicationProperties = bucket.getApplicationProperties();
        this.hostApp = bucket.getHostApp();
    }

    protected void doGetKsso(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
        this.renderPage(req, resp, this.newModel(req));
    }

    private void renderPage(HttpServletRequestFacade req, HttpServletResponseFacade resp, Map<String, Object> model) throws IOException {
        String query = req.getParameter("query");
        if (query != null) {
            GroupSearchUtil.printGroupsAsJson(resp, query, this.userManager);
        } else {
            resp.setContentType("text/html");
            String id = IdpConfManager.IdpServletUtil.getId(req);
            IdpConfiguration configuration = this.idpConfManager.getIdentityProviderById(id);
            if (configuration == null) {
                resp.sendError(404);
                return;
            }
            model.put("topMenu", "SAML");
            model.put("menuItem", "managedGroups");
            model.put("idp", configuration);
            model.put("displayName", this.applicationProperties.getDisplayName());
            model.put("test", req.getParameter("test"));
            model.put("changed", req.getParameter("changed") != null);
            model.put("userTestURL", this.idpConfManager.getServiceProviderNonAdminTestUrl(req, id));
            model.put("groupTool", new GroupTool(this.hostApp));
            this.getTemplateRenderer().render("templates/saml/idp-groups/idp-groups.vm", model, (Writer)resp.getWriter());
        }
    }

    @Override
    protected void doPostKsso(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
        ManagedGroup managedGroup;
        Set<String> existing;
        boolean changingRemoveNonIdpGroupsFromUser;
        String idpId = IdpConfManager.IdpServletUtil.getId(req);
        String addManagedGroup = req.getParameter("addManagedGroup");
        String removeManagedGroup = req.getParameter("removeManagedGroup");
        String addGroupParameter = req.getParameter("addGroupParameter");
        String removeGroupParameter = req.getParameter("removeGroupParameter");
        IdpConfiguration previousConf = this.idpConfManager.getIdentityProviderById(idpId);
        IdpConfigurationBuilder<?, ?> builder = IdpConfigurationBuilder.ofGeneric(previousConf);
        String createAllIncomingGroups = req.getParameter("createAllIncomingGroups");
        if (createAllIncomingGroups != null) {
            builder.setCreateAllIncomingGroups("true".equalsIgnoreCase(createAllIncomingGroups));
        }
        if (changingRemoveNonIdpGroupsFromUser = "true".equalsIgnoreCase(req.getParameter("changingRemoveNonIdpGroupsFromUser"))) {
            builder.setremoveNonIdpGroupsFromUser("on".equalsIgnoreCase(req.getParameter("removeNonIdpGroupsFromUser")));
        } else if ("false".equalsIgnoreCase(createAllIncomingGroups)) {
            builder.setremoveNonIdpGroupsFromUser(false);
        }
        if (addGroupParameter != null) {
            existing = builder.getIdpGroupsAttributes();
            existing.add(addGroupParameter);
        }
        if (removeGroupParameter != null) {
            existing = builder.getIdpGroupsAttributes();
            existing.remove(removeGroupParameter);
        }
        if (addManagedGroup != null) {
            managedGroup = new ManagedGroup(addManagedGroup);
            builder.getManagedGroups().add(managedGroup);
        } else if (removeManagedGroup != null) {
            managedGroup = new ManagedGroup(removeManagedGroup);
            builder.getManagedGroups().remove(managedGroup);
        }
        IdpGroupsServlet.handleAssignGroupRules(req, builder);
        this.idpConfManager.updateIdpConfiguration((IdpConfiguration)builder.build());
        resp.sendRedirect("groups");
    }

    private static void handleAssignGroupRules(HttpServletRequestFacade req, IdpConfigurationBuilder<?, ?> builder) {
        String assignGroup = req.getParameter("assignGroup");
        String removeAssignedGroup = req.getParameter("removeAssignedGroup");
        if (StringUtils.isNotBlank((CharSequence)assignGroup)) {
            builder.getAssignGroupRules().add(new AssignGroupRule((String)StringUtils.defaultIfEmpty((CharSequence)StringUtils.trim((String)req.getParameter("requiredGroup")), null), (String)StringUtils.defaultIfEmpty((CharSequence)StringUtils.trim((String)req.getParameter("assignGroupUsernameRegex")), null), assignGroup));
        } else if (StringUtils.isNotBlank((CharSequence)removeAssignedGroup)) {
            builder.getAssignGroupRules().remove(new AssignGroupRule((String)StringUtils.defaultIfEmpty((CharSequence)req.getParameter("removeRequiredGroup"), null), (String)StringUtils.defaultIfEmpty((CharSequence)req.getParameter("removeAssignGroupUsernameRegex"), null), removeAssignedGroup));
        }
    }

    public static class GroupTool {
        private final HostApp hostApp;

        public GroupTool(HostApp hostApp) {
            this.hostApp = hostApp;
        }

        public boolean isExistingGroup(String name) {
            return name == null ? false : this.hostApp.isExistingGroup(name);
        }
    }
}

