/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml.servlet;

import com.atlassian.sal.api.ApplicationProperties;
import com.kantegasso.runtimetrust.FingerprintSSLSocketFactory;
import com.kantegasso.servlet.http.HttpServletRequestFacade;
import com.kantegasso.servlet.http.HttpServletResponseFacade;
import com.kantegasso.servlet.http.MultipartHttpRequest;
import io.vavr.CheckedFunction0;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.inject.Inject;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSocketFactory;
import kantega.shaded.org.opensaml.saml.saml2.metadata.EntityDescriptor;
import kantega.shaded.org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.identityproviders.IdpConfigurationBuilder;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.saml.SamlIdpConfiguration;
import org.kantega.samllib.xml.MetadataParser;

public class IdpMetadataServlet
extends RequireAdminServlet {
    private final IdpConfManager idpConfManager;
    private final ApplicationProperties applicationProperties;
    private final MetadataParser metadataParser = new MetadataParser();

    @Inject
    public IdpMetadataServlet(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
        this.idpConfManager = bucket.getIdpConfManager();
        this.applicationProperties = bucket.getApplicationProperties();
    }

    public static String cleanString(String origString) {
        StringBuilder sb = new StringBuilder();
        for (char c : origString.toCharArray()) {
            if (!Character.isDigit(c) && !Character.isLetter(c)) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    protected void doGetKsso(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
        this.renderPage(req, resp, this.newModel(req));
    }

    private void renderPage(HttpServletRequestFacade req, HttpServletResponseFacade resp, Map<String, Object> model) throws IOException {
        resp.setContentType("text/html");
        String id = IdpConfManager.IdpServletUtil.getId(req);
        IdpConfiguration configuration = this.idpConfManager.getIdentityProviderById(id);
        if (configuration == null) {
            resp.sendError(404);
            return;
        }
        boolean autoRefreshMetadataEnabled = (Boolean)Try.of((CheckedFunction0 & Serializable)() -> configuration).mapTry(SamlIdpConfiguration.class::cast).mapTry(SamlIdpConfiguration::isAutoRefreshMetadataEnabled).getOrElse((Object)false);
        String metadataUrl = (String)Try.of((CheckedFunction0 & Serializable)() -> configuration).mapTry(SamlIdpConfiguration.class::cast).mapTry(SamlIdpConfiguration::getMetadataUrl).getOrElse((Object)"");
        model.put("topMenu", "SAML");
        model.put("menuItem", "metadata");
        model.put("idp", configuration);
        model.put("metadataURL", metadataUrl);
        model.put("isAutoRefreshEnabled", autoRefreshMetadataEnabled);
        model.put("displayName", this.applicationProperties.getDisplayName());
        this.getTemplateRenderer().render("templates/saml/saml-idp-metadata.vm", model, (Writer)resp.getWriter());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void doPostKsso(HttpServletRequestFacade request, HttpServletResponseFacade resp) throws IOException {
        IdpConfigurationBuilder.Saml builder;
        Map<String, Object> model;
        InputStream metadataStream;
        MultipartHttpRequest req;
        block20: {
            req = this.getMultipartRequest(request, 1000000L);
            String id = IdpConfManager.IdpServletUtil.getId((HttpServletRequestFacade)req);
            String action = req.getParameter("action");
            String newFingerprint = req.getParameter("metadataTlsFingerprint");
            String metadataURL = req.getParameter("metadataURL");
            boolean refreshAuto = req.getParameter("refreshAuto") != null;
            boolean refreshNow = (Boolean)Option.of((Object)req.getParameter("saveMetadataUrl")).map(parameter -> parameter.equals("Save and refresh metadata")).getOrElse((Object)false);
            metadataStream = null;
            model = this.newModel((HttpServletRequestFacade)req);
            model.put("action", action);
            SamlIdpConfiguration samlConfig = this.idpConfManager.getIdentityProviderById(id).fold(saml -> {
                throw new RuntimeException("Did not expect OIDC config: " + id);
            }, Function.identity());
            builder = IdpConfigurationBuilder.of(samlConfig);
            if ("updateMetadata".equals(action)) {
                builder.setAutoRefreshMetadataEnabled(refreshAuto);
                builder.setMetadataURL(metadataURL);
                if (refreshNow && (metadataStream = this.refreshFromMetadata(id, model, metadataURL, newFingerprint, builder)) == null) {
                    this.renderPage((HttpServletRequestFacade)req, resp, model);
                    return;
                }
            }
            if ("uploadMetadata".equals(action)) {
                byte[] file = req.getFile("file");
                if (file != null && file.length > 0) {
                    metadataStream = new ByteArrayInputStream(file);
                    break block20;
                } else {
                    model.put("missingFile", true);
                    this.renderPage((HttpServletRequestFacade)req, resp, model);
                    return;
                }
            }
            if ("pasteMetadata".equals(action)) {
                String xml = req.getParameter("paste");
                if (xml != null && !xml.isEmpty()) {
                    metadataStream = new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8));
                } else {
                    model.put("missingPaste", true);
                    this.renderPage((HttpServletRequestFacade)req, resp, model);
                    return;
                }
            }
        }
        if (metadataStream != null) {
            EntityDescriptor metadata = null;
            try {
                metadata = this.metadataParser.parse(metadataStream);
            }
            catch (Exception e) {
                model.put("parseException", e);
                this.renderPage((HttpServletRequestFacade)req, resp, model);
                return;
            }
            finally {
                try {
                    metadataStream.close();
                }
                catch (Exception exception) {}
            }
            IDPSSODescriptor idpDesc = this.metadataParser.getIDPDescriptorForSaml(metadata);
            List signingCerts = this.metadataParser.getSigningCerts(idpDesc);
            MetadataParser.IdpSsoLocation idpLocation = this.metadataParser.getIdpSsoLocation(idpDesc);
            String idpSingleLogoutServiceURL = this.metadataParser.getIdpSingleLogoutServiceURL(idpDesc);
            builder.setIdpUrl(idpLocation.getLocation());
            builder.setUsePostBinding(idpLocation.usePostBinding());
            builder.setIdpSingleLogoutServiceURL(idpSingleLogoutServiceURL);
            builder.setSigningCerts(signingCerts);
            model.put("successUpdatedMetadata", true);
        }
        this.idpConfManager.updateIdpConfiguration((IdpConfiguration)builder.build());
        this.renderPage((HttpServletRequestFacade)req, resp, model);
    }

    private InputStream refreshFromMetadata(String id, Map<String, Object> model, String metadataURL, String newFingerprint, IdpConfigurationBuilder.Saml builder) {
        if (this.idpConfManager.getIdentityProviderById(id) instanceof SamlIdpConfiguration) {
            String fingerprint;
            SamlIdpConfiguration idp = (SamlIdpConfiguration)this.idpConfManager.getIdentityProviderById(id);
            if (StringUtils.isNotBlank((CharSequence)newFingerprint)) {
                fingerprint = IdpMetadataServlet.cleanString(newFingerprint.toUpperCase());
                builder.setTlsFingerprint(fingerprint);
            } else {
                fingerprint = idp.getTlsFingerprint();
            }
            model.put("metadataURL", metadataURL);
            if (metadataURL != null && !metadataURL.isEmpty()) {
                metadataURL = metadataURL.trim();
                try {
                    URL url = new URI(metadataURL).toURL();
                    try {
                        HttpURLConnection con = (HttpURLConnection)url.openConnection();
                        if (con instanceof HttpsURLConnection) {
                            HttpsURLConnection cons = (HttpsURLConnection)con;
                            cons.setSSLSocketFactory((SSLSocketFactory)new FingerprintSSLSocketFactory(fingerprint));
                        }
                        return con.getInputStream();
                    }
                    catch (SSLHandshakeException e) {
                        model.put("metadataSSLHandshakeException", e.getClass().getSimpleName() + ": " + e.getMessage());
                        model.put("untrustedServer", url.getProtocol() + "://" + url.getHost());
                        if (e.getCause() instanceof FingerprintSSLSocketFactory.FingerPrintException) {
                            X509Certificate[] certs = ((FingerprintSSLSocketFactory.FingerPrintException)e.getCause()).getX509Certificates();
                            List validationCerts = io.vavr.collection.List.ofAll(Arrays.asList(certs)).map(cert -> {
                                JSONObject certJson = new JSONObject();
                                certJson.put("subjectDn", (Object)cert.getSubjectDN().getName());
                                return certJson;
                            }).asJava();
                            model.put("untrustedCerts", validationCerts);
                        }
                        if (StringUtils.isNotBlank((CharSequence)newFingerprint)) {
                            model.put("wrongFingerPrint", newFingerprint);
                        }
                    }
                }
                catch (IOException e) {
                    model.put("metadataIOException", e.getClass().getSimpleName() + ": " + e.getMessage());
                }
                catch (Exception e) {
                    model.put("exceptionBadInput", "Something went wrong validating URI format: " + e);
                }
            } else {
                builder.setMetadataURL(null);
                this.idpConfManager.updateIdpConfiguration((IdpConfiguration)builder.build());
            }
        }
        return null;
    }

    @Override
    protected boolean expectsMultipart() {
        return true;
    }
}

