/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml.servlet;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.kantegasso.servlet.http.HttpServletFacade;
import com.kantegasso.servlet.http.HttpServletRequestFacade;
import com.kantegasso.servlet.http.HttpServletResponseFacade;
import jakarta.inject.Inject;
import java.io.IOException;
import java.io.OutputStream;
import java.security.cert.CertificateEncodingException;
import java.util.ArrayList;
import kantega.shaded.org.opensaml.core.xml.XMLObject;
import kantega.shaded.org.opensaml.core.xml.io.MarshallingException;
import kantega.shaded.org.opensaml.core.xml.util.XMLObjectSupport;
import kantega.shaded.org.opensaml.saml.saml2.metadata.AssertionConsumerService;
import kantega.shaded.org.opensaml.saml.saml2.metadata.EntityDescriptor;
import kantega.shaded.org.opensaml.saml.saml2.metadata.KeyDescriptor;
import kantega.shaded.org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import kantega.shaded.org.opensaml.saml.saml2.metadata.SingleLogoutService;
import kantega.shaded.org.opensaml.saml.saml2.metadata.impl.AssertionConsumerServiceBuilder;
import kantega.shaded.org.opensaml.saml.saml2.metadata.impl.EntityDescriptorBuilder;
import kantega.shaded.org.opensaml.saml.saml2.metadata.impl.KeyDescriptorBuilder;
import kantega.shaded.org.opensaml.saml.saml2.metadata.impl.SPSSODescriptorBuilder;
import kantega.shaded.org.opensaml.saml.saml2.metadata.impl.SingleLogoutServiceBuilder;
import kantega.shaded.org.opensaml.security.credential.UsageType;
import kantega.shaded.org.opensaml.xmlsec.signature.KeyInfo;
import kantega.shaded.org.opensaml.xmlsec.signature.X509Certificate;
import kantega.shaded.org.opensaml.xmlsec.signature.X509Data;
import kantega.shaded.org.opensaml.xmlsec.signature.impl.KeyInfoBuilder;
import kantega.shaded.org.opensaml.xmlsec.signature.impl.X509CertificateBuilder;
import kantega.shaded.org.opensaml.xmlsec.signature.impl.X509DataBuilder;
import org.apache.commons.codec.binary.Base64;
import org.kantega.atlaskerb.saml.CertDetails;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.samllib.xml.XmlUtils;
import org.w3c.dom.Node;

@UnrestrictedAccess
public class AtlSpMetadataServlet
extends HttpServletFacade {
    private final IdpConfManager idpConfManager;

    @Inject
    public AtlSpMetadataServlet(IdpConfManager idpConfManager) {
        this.idpConfManager = idpConfManager;
    }

    protected void doGetKsso(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
        String requestURI = req.getRequestURI();
        String id = requestURI.substring(requestURI.lastIndexOf("/sp/") + "/sp/".length(), requestURI.lastIndexOf("/"));
        if (!IdpConfManager.isValidIdpId(id)) {
            resp.sendError(404);
            return;
        }
        EntityDescriptor descriptor = new EntityDescriptorBuilder().buildObject();
        descriptor.setEntityID(this.idpConfManager.getServiceProviderLoginUrl(req, id));
        SPSSODescriptor ssoDesc = new SPSSODescriptorBuilder().buildObject();
        ssoDesc.setWantAssertionsSigned(Boolean.valueOf(true));
        ssoDesc.addSupportedProtocol("urn:oasis:names:tc:SAML:2.0:protocol");
        ArrayList<byte[]> signingCerts = new ArrayList<byte[]>();
        this.idpConfManager.ensureKeysExist(req.getServerName());
        signingCerts.add(this.idpConfManager.getSigningCert());
        for (CertDetails certDetails : this.idpConfManager.getStandbyCertificates()) {
            try {
                signingCerts.add(certDetails.getCert().getEncoded());
            }
            catch (CertificateEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        for (byte[] bytes : signingCerts) {
            KeyDescriptor signingKeyDescriptor = new KeyDescriptorBuilder().buildObject();
            signingKeyDescriptor.setUse(UsageType.SIGNING);
            KeyInfo keyInfo = new KeyInfoBuilder().buildObject();
            X509Data x509 = new X509DataBuilder().buildObject();
            X509Certificate cert = new X509CertificateBuilder().buildObject();
            cert.setValue(Base64.encodeBase64String((byte[])bytes));
            x509.getX509Certificates().add(cert);
            keyInfo.getX509Datas().add(x509);
            signingKeyDescriptor.setKeyInfo(keyInfo);
            ssoDesc.getKeyDescriptors().add(signingKeyDescriptor);
            if (!this.idpConfManager.isEncryptedAssertionsRequiredForIdpOrDraft(id)) continue;
            KeyDescriptor encryptionKeyDescriptor = new KeyDescriptorBuilder().buildObject();
            encryptionKeyDescriptor.setUse(UsageType.ENCRYPTION);
            KeyInfo keyInfoEnc = new KeyInfoBuilder().buildObject();
            X509Data x509Enc = new X509DataBuilder().buildObject();
            X509Certificate certEnc = new X509CertificateBuilder().buildObject();
            certEnc.setValue(Base64.encodeBase64String((byte[])bytes));
            x509Enc.getX509Certificates().add(certEnc);
            keyInfoEnc.getX509Datas().add(x509Enc);
            encryptionKeyDescriptor.setKeyInfo(keyInfoEnc);
            ssoDesc.getKeyDescriptors().add(encryptionKeyDescriptor);
        }
        if (this.idpConfManager.isSingleLogoutEnabledForIdpOrDraft(id)) {
            SingleLogoutService logoutServiceRedir = new SingleLogoutServiceBuilder().buildObject();
            logoutServiceRedir.setLocation(this.idpConfManager.getServiceProviderLogoutServiceUrl(req, id));
            logoutServiceRedir.setBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
            ssoDesc.getSingleLogoutServices().add(logoutServiceRedir);
            SingleLogoutService logoutServicePost = new SingleLogoutServiceBuilder().buildObject();
            logoutServicePost.setLocation(this.idpConfManager.getServiceProviderLogoutServiceUrl(req, id));
            logoutServicePost.setBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
            ssoDesc.getSingleLogoutServices().add(logoutServicePost);
        }
        AssertionConsumerService assetionConsumerService = new AssertionConsumerServiceBuilder().buildObject();
        assetionConsumerService.setIsDefault(Boolean.valueOf(true));
        assetionConsumerService.setIndex(Integer.valueOf(0));
        assetionConsumerService.setLocation(this.idpConfManager.getServiceProviderLoginUrl(req, id));
        assetionConsumerService.setBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        ssoDesc.getAssertionConsumerServices().add(assetionConsumerService);
        descriptor.getRoleDescriptors().add(ssoDesc);
        try {
            resp.setContentType("application/samlmetadata+xml");
            XmlUtils.writeNode((Node)XMLObjectSupport.marshall((XMLObject)descriptor), (OutputStream)resp.getOutputStream());
        }
        catch (MarshallingException e) {
            throw new RuntimeException(e);
        }
    }
}

