/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.intercept.filter;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.kantegasso.servlet.FilterChainFacade;
import com.kantegasso.servlet.FilterConfigFacade;
import com.kantegasso.servlet.FilterFacade;
import com.kantegasso.servlet.http.HttpServletRequestFacade;
import com.kantegasso.servlet.http.HttpServletResponseFacade;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.kantega.atlaskerb.AvoidNameEmailChange;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.connector.ConnectorConfManager;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.scim.ScimConfManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UnrestrictedAccess
public class JiraAvoidEditProfileAdminFilter
extends FilterFacade {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    HostApp hostApp;
    ScimConfManager scimConfManager;
    ConnectorConfManager connectorConfManager;
    UserManager userManager;

    public JiraAvoidEditProfileAdminFilter(RequireAdminServletDependencyBucket bucket) {
        this.hostApp = bucket.getHostApp();
        this.scimConfManager = bucket.getScimConfManager();
        this.connectorConfManager = bucket.getConnectorConfManager();
        this.userManager = bucket.getUserManager();
    }

    public void doFilterKsso(HttpServletRequestFacade request, HttpServletResponseFacade response, FilterChainFacade chain) throws IOException {
        HttpServletResponseFacade wrapper = new HttpServletResponseFacade((HttpServletResponse)response){

            public PrintWriter getWriter() throws IOException {
                return new PrintWriter(new Writer(){

                    @Override
                    public void write(@NotNull char[] cbuf, int off, int len) throws IOException {
                        String formContent = new String(cbuf, off, len);
                        try {
                            String username;
                            if (formContent.contains(">Edit user profile") && (username = JiraAvoidEditProfileAdminFilter.this.getUsernameFromForm(formContent)) != null && JiraAvoidEditProfileAdminFilter.this.userManager.getUserProfile(username) != null) {
                                JiraAvoidEditProfileAdminFilter.this.log.debug("Edit profile page is set to read-only");
                                UserProfile userEdited = JiraAvoidEditProfileAdminFilter.this.userManager.getUserProfile(username);
                                if (userEdited != null && AvoidNameEmailChange.isUserInCloudDirectory(userEdited, JiraAvoidEditProfileAdminFilter.this.hostApp, JiraAvoidEditProfileAdminFilter.this.scimConfManager, JiraAvoidEditProfileAdminFilter.this.connectorConfManager)) {
                                    formContent = formContent.replace("<form ", "<div style=\"margin-left:20px;margin-right:20px\" class=\"aui-message aui-message-info\">You cannot edit properties as they are stored in a read-only user directory.</div><form ");
                                    formContent = formContent.replace("name=\"username\"", "name=\"username\" readonly style=\"background-color: var(--aui-form-disabled-field-bg-color, lightgray)\"");
                                    formContent = formContent.replace("name=\"fullname\"", "name=\"fullname\" readonly style=\"background-color: var(--aui-form-disabled-field-bg-color, lightgray)\"");
                                    formContent = formContent.replace("name=\"email\"", "name=\"email\" readonly style=\"background-color: var(--aui-form-disabled-field-bg-color, lightgray)\"");
                                }
                            }
                        }
                        catch (Exception e) {
                            JiraAvoidEditProfileAdminFilter.this.log.error("Error in JiraAvoidEditProfileAdminFilter", (Throwable)e);
                        }
                        this.getResponse().getOutputStream().write(formContent.getBytes(StandardCharsets.UTF_8));
                    }

                    @Override
                    public void flush() throws IOException {
                        JiraAvoidEditProfileAdminFilter.this.log.debug("Flushing requested");
                    }

                    @Override
                    public void close() throws IOException {
                        JiraAvoidEditProfileAdminFilter.this.log.debug("Closing requested");
                    }
                });
            }
        };
        chain.doFilterKsso(request, wrapper);
    }

    private String getUsernameFromForm(String content) {
        String username = null;
        Pattern pattern = Pattern.compile("<input[^>]*name=\"username\"[^>]*value=\"([^\"]*)\"[^>]*>");
        Matcher matcher = pattern.matcher(content);
        if (matcher.find()) {
            username = matcher.group(1);
            this.log.debug("Found username: " + username);
        } else {
            this.log.debug("Username not found");
        }
        return username;
    }

    public void destroy() {
    }

    public void initKssoFilter(FilterConfigFacade filterConfig) {
    }
}

