/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.connector.crowdserver;

import com.google.common.collect.Sets;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.connector.model.crowdapi.GroupItem;
import org.kantega.atlaskerb.connector.model.crowdapi.MembershipItem;
import org.kantega.atlaskerb.connector.model.crowdapi.UserCollection;
import org.kantega.atlaskerb.connector.model.crowdapi.UserItem;
import org.kantega.atlaskerb.connector.model.crowdapi.UserMember;
import org.kantega.atlaskerb.connector.model.filters.ConnectorFilter;
import org.kantega.atlaskerb.connector.model.filters.GroupFilter;
import org.kantega.atlaskerb.connector.model.filters.UserMembershipFilter;
import org.kantega.atlaskerb.connector.model.filters.UserTypeSelectionFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterUtils {
    private static final Logger log = LoggerFactory.getLogger(FilterUtils.class);

    public static boolean containsIgnoreCase(Collection<String> regex, String s) {
        return regex.stream().anyMatch(x -> Pattern.compile(x).matcher(s).matches() || StringUtils.equalsIgnoreCase((CharSequence)x, (CharSequence)s));
    }

    public static boolean isUserTypeAccepted(UserItem u, UserTypeSelectionFilter filter) {
        switch (filter.getMode()) {
            case MEMBERS_ONLY: {
                return u.getUserType() == UserItem.UserType.MEMBER;
            }
            case MEMBERS_AND_GUESTS_ONLY: {
                List<UserItem.UserType> acceptedTypes = Arrays.asList(UserItem.UserType.MEMBER, UserItem.UserType.GUEST);
                return acceptedTypes.contains((Object)u.getUserType());
            }
            case GUESTS_ONLY: {
                List<UserItem.UserType> acceptedTypes = Collections.singletonList(UserItem.UserType.GUEST);
                return acceptedTypes.contains((Object)u.getUserType());
            }
        }
        return true;
    }

    public static Set<UserItem> filterUsersByUserType(Set<UserItem> users, UserTypeSelectionFilter userTypeFilter) {
        return users.stream().filter(user -> FilterUtils.isUserTypeAccepted(user, userTypeFilter)).collect(Collectors.toSet());
    }

    public static Tuple2<Set<UserItem>, Set<MembershipItem>> filterUsersByMemberships(Set<UserItem> users, Set<MembershipItem> memberships, GroupFilter groupFilter, UserMembershipFilter userMembershipFilter) {
        HashSet<UserMember> filteredUserMembers = new HashSet<UserMember>();
        log.debug("Filtering with userFilterMode: {}, userIncludedGroups: {}, userExcludedGroups {}, groupsIncludedGroups: {}, groupsExcludedGroups {}, userCount {}, membershipCount {}", new Object[]{userMembershipFilter.getMode(), userMembershipFilter.getIncludedGroups(), userMembershipFilter.getExcludedGroups(), groupFilter.getIncludedGroups(), groupFilter.getExcludedGroups(), users != null ? Integer.valueOf(users.size()) : "null", memberships != null ? Integer.valueOf(memberships.size()) : "null"});
        if (userMembershipFilter.getMode() == ConnectorFilter.SelectionMode.EXCLUDE_SUBSET) {
            users.forEach(item -> {
                UserMember member = new UserMember();
                member.setName(item.getName());
                filteredUserMembers.add(member);
            });
        }
        if (userMembershipFilter.getMode() != ConnectorFilter.SelectionMode.ALL && memberships != null) {
            for (MembershipItem membership : memberships) {
                if (userMembershipFilter.getMode() == ConnectorFilter.SelectionMode.INCLUDE_SUBSET && FilterUtils.containsIgnoreCase(userMembershipFilter.getIncludedGroups(), membership.getName())) {
                    filteredUserMembers.addAll(membership.getUserCollection().getUsers());
                    continue;
                }
                if (userMembershipFilter.getMode() != ConnectorFilter.SelectionMode.EXCLUDE_SUBSET || !FilterUtils.containsIgnoreCase(userMembershipFilter.getExcludedGroups(), membership.getName())) continue;
                membership.getUserCollection().getUsers().forEach(filteredUserMembers::remove);
            }
        } else {
            for (UserItem user2 : users) {
                UserMember userMember = new UserMember();
                userMember.setName(user2.getName());
                filteredUserMembers.add(userMember);
            }
        }
        Set<String> filteredUserNamesLc = filteredUserMembers.stream().map(user -> user.getName().toLowerCase()).collect(Collectors.toSet());
        Set filteredUsers = users.stream().filter(user -> filteredUserNamesLc.contains(user.getName().toLowerCase())).collect(Collectors.toSet());
        return Tuple.of(filteredUsers, FilterUtils.filterAndPruneMemberships(filteredUserNamesLc, memberships, groupFilter, userMembershipFilter));
    }

    private static Set<MembershipItem> filterAndPruneMemberships(Set<String> includedUsernames, Set<MembershipItem> memberships, GroupFilter groupFilter, UserMembershipFilter userMembershipFilter) {
        ConnectorFilter.SelectionMode mode = userMembershipFilter.getMode();
        if (mode == ConnectorFilter.SelectionMode.ALL) {
            return memberships;
        }
        HashSet result = Sets.newHashSetWithExpectedSize((int)memberships.size());
        for (MembershipItem membership : memberships) {
            if (!FilterUtils.isGroupNameIncluded(membership.getName(), groupFilter)) continue;
            List<UserMember> members = membership.getUserCollection().getUsers().stream().filter(member -> includedUsernames.contains(member.getName().toLowerCase())).collect(Collectors.toList());
            result.add(new MembershipItem(membership.getName(), new UserCollection(members)));
        }
        return result;
    }

    public static Predicate<MembershipItem> membershipByGroupPredicate(GroupFilter filter) {
        switch (filter.getMode()) {
            case INCLUDE_SUBSET: {
                return m -> FilterUtils.containsIgnoreCase(filter.getIncludedGroups(), m.getName());
            }
            case EXCLUDE_SUBSET: {
                return m -> !FilterUtils.containsIgnoreCase(filter.getExcludedGroups(), m.getName());
            }
        }
        return m -> true;
    }

    public static Set<MembershipItem> filterMembershipsByGroup(Set<MembershipItem> memberships, GroupFilter filter) {
        Predicate<MembershipItem> pred = FilterUtils.membershipByGroupPredicate(filter);
        return memberships.stream().filter(pred).collect(Collectors.toSet());
    }

    public static Predicate<GroupItem> groupPredicate(GroupFilter filter) {
        return g -> FilterUtils.isGroupNameIncluded(g.getName(), filter);
    }

    public static boolean isGroupNameIncluded(String groupName, GroupFilter filter) {
        switch (filter.getMode()) {
            case INCLUDE_SUBSET: {
                return FilterUtils.containsIgnoreCase(filter.getIncludedGroups(), groupName);
            }
            case EXCLUDE_SUBSET: {
                return !FilterUtils.containsIgnoreCase(filter.getExcludedGroups(), groupName);
            }
        }
        return true;
    }

    public static boolean isMembershipRetrievalRequired(GroupItem groupItem, GroupFilter groupFilter, UserMembershipFilter userFilter) {
        HashSet<String> aggregate = new HashSet<String>(groupFilter.getIncludedGroups());
        if (userFilter.getMode() != ConnectorFilter.SelectionMode.ALL) {
            aggregate.addAll(userFilter.getExcludedGroups());
            aggregate.addAll(userFilter.getIncludedGroups());
        }
        String groupName = groupItem.getName();
        boolean groupIncluded = FilterUtils.isGroupNameIncluded(groupName, groupFilter);
        boolean requiredForUserFiltering = FilterUtils.containsIgnoreCase(aggregate, groupName);
        return groupIncluded || requiredForUserFiltering;
    }

    public static Set<GroupItem> filterGroupsByGroup(Set<GroupItem> groups, GroupFilter filter) {
        Predicate<GroupItem> pred = FilterUtils.groupPredicate(filter);
        return groups.stream().filter(pred).collect(Collectors.toSet());
    }
}

