/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.security;

import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.kantegasso.servlet.http.HttpServletRequestFacade;
import com.kantegasso.servlet.http.HttpServletResponseFacade;
import jakarta.inject.Inject;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.security.DarkFeaturesServlet;
import org.kantega.atlaskerb.utils.HttpUrlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CorsAllowAjaxFromExternal
extends RequireAdminServlet {
    private final KerbConfManager kerbConfManager;
    private final TemplateRenderer renderer;
    private final ApplicationProperties applicationProperties;
    private final Logger log = LoggerFactory.getLogger(DarkFeaturesServlet.class);

    @Inject
    public CorsAllowAjaxFromExternal(RequireAdminServletDependencyBucket bucket, @ComponentImport PluginAccessor pluginAccessor) {
        super(bucket);
        this.kerbConfManager = bucket.getKerbConfManager();
        this.renderer = bucket.getTemplateRenderer();
        this.applicationProperties = bucket.getApplicationProperties();
    }

    protected void doGetKsso(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
        Map<String, Object> model = this.newModel(req);
        model.put("topMenu", "dashboard");
        model.put("menuItem", "allow-ajax-from-external");
        model.put("contextPath", req.getContextPath());
        model.put("homeDirectory", this.kerbConfManager.getKerberosHomeDirectoryPath());
        model.put("displayName", this.applicationProperties.getDisplayName());
        model.put("securityHeaderAllowedHostNames", this.kerbConfManager.getSecurityHeaderAllowedHostNames());
        StringBuilder sb = new StringBuilder();
        for (String path : this.kerbConfManager.getRequireLoginExcludedPaths()) {
            sb.append(path).append("\n");
        }
        resp.setContentType("text/html");
        this.renderer.render("templates/atlaskerb/cors-allow-ajax-from-external.vm", model, (Writer)resp.getWriter());
    }

    @Override
    protected void doPostKsso(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
        super.doPostKsso(req, resp);
        try {
            String addHostName;
            String removeHostName = req.getParameter("removeHostName");
            if (StringUtils.isNotBlank((CharSequence)removeHostName)) {
                this.kerbConfManager.removeSecurityHeaderAllowedHostNames(removeHostName);
            }
            if (StringUtils.isNotBlank((CharSequence)(addHostName = req.getParameter("addHostName")))) {
                this.kerbConfManager.addSecurityHeaderAllowedHostNames(addHostName.trim());
            }
            resp.sendRedirect("allow-ajax-from-external");
        }
        catch (Exception e) {
            HttpUrlUtils.sendSaveError((HttpServletResponseFacade)resp, (Exception)e);
            this.log.error("Problem saving settings", (Throwable)e);
        }
    }
}

