/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml.servlet;

import com.atlassian.templaterenderer.TemplateRenderer;
import com.kantegasso.servlet.http.HttpServletRequestFacade;
import com.kantegasso.servlet.http.HttpServletResponseFacade;
import jakarta.inject.Inject;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.saml.IdpConfManager;

public class SSOLoginScreenServlet
extends RequireAdminServlet {
    private final TemplateRenderer templateRenderer;
    private final IdpConfManager idpConfManager;

    @Inject
    public SSOLoginScreenServlet(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
        this.templateRenderer = bucket.getTemplateRenderer();
        this.idpConfManager = bucket.getIdpConfManager();
    }

    protected void doGetKsso(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
        resp.setContentType("text/html");
        Map<String, Object> model = this.newModel(req);
        model.put("topMenu", "SAML");
        model.put("menuItem", "loginScreen");
        try {
            this.templateRenderer.render("templates/saml/saml-login-screen.vm", model, (Writer)resp.getWriter());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void doPostKsso(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
        if (req.getParameter("disable") != null) {
            this.idpConfManager.setFederatedSsoEnabled(false);
        }
        if (req.getParameter("enable") != null) {
            this.idpConfManager.setFederatedSsoEnabled(true);
        }
        resp.sendRedirect("providers");
    }
}

