/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml.servlet;

import com.kantegasso.servlet.http.HttpServletRequestFacade;
import com.kantegasso.servlet.http.HttpServletResponseFacade;
import jakarta.inject.Inject;
import java.io.IOException;
import java.security.cert.CertificateEncodingException;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.saml.CertDetails;
import org.kantega.atlaskerb.saml.CertTool;
import org.kantega.atlaskerb.saml.IdpConfManager;

public class DownloadStandbyCertificateServlet
extends RequireAdminServlet {
    private final IdpConfManager idpConfManager;

    @Inject
    public DownloadStandbyCertificateServlet(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
        this.idpConfManager = bucket.getIdpConfManager();
    }

    protected void doGetKsso(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
        String hash = req.getParameter("hash");
        for (CertDetails certDetails : this.idpConfManager.getStandbyCertificates()) {
            byte[] encoded;
            try {
                encoded = certDetails.getCert().getEncoded();
            }
            catch (CertificateEncodingException e) {
                throw new RuntimeException(e);
            }
            if (!hash.equals(CertTool.sha256FingerPrint(encoded))) continue;
            resp.setHeader("Content-Disposition", "attachment; filename=" + req.getServerName() + "-standby-" + hash.substring(0, 10) + ".cer");
            resp.setContentType("application/pkix-cert");
            resp.setContentLength(encoded.length);
            resp.getOutputStream().write(encoded);
            return;
        }
        resp.sendError(404);
    }
}

