/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.rest.resource.internal.gitcontrol;

import com.atlassian.annotations.PublicApi;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import kantega.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.utils.JsonWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="get-bitbucket-kerberos-scm-types")
@PublicApi
public class GetBitbucketKerberosScmTypes {
    private final Logger log = LoggerFactory.getLogger(GetBitbucketKerberosScmTypes.class);
    private final KerbConfManager kerbConfManager;
    private final JsonWrapper jsonWrapper;

    @Inject
    public GetBitbucketKerberosScmTypes(KerbConfManager kerbConfManager, JsonWrapper jsonWrapper) {
        this.kerbConfManager = kerbConfManager;
        this.jsonWrapper = jsonWrapper;
    }

    @GET
    @Produces(value={"text/plain"})
    public Response doGet(@Context HttpServletRequest request) {
        try {
            return Response.ok((Object)this.jsonWrapper.buildJsonString(this.kerbConfManager.getBitbucketKerberosScmUrlTypes())).build();
        }
        catch (JsonProcessingException e) {
            this.log.error("KSSO: something went wrong processing json object ", (Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
    }
}

