/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.msteams;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.kantegasso.servlet.FilterChainFacade;
import com.kantegasso.servlet.FilterConfigFacade;
import com.kantegasso.servlet.FilterFacade;
import com.kantegasso.servlet.http.HttpServletRequestFacade;
import com.kantegasso.servlet.http.HttpServletResponseFacade;
import jakarta.inject.Inject;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UnrestrictedAccess
public final class MsTeamsSecurityHeadersFilter
extends FilterFacade {
    private static final Logger log = LoggerFactory.getLogger(MsTeamsSecurityHeadersFilter.class);
    private final HostApp hostApp;

    @Inject
    public MsTeamsSecurityHeadersFilter(RequireAdminServletDependencyBucket bucket) {
        this.hostApp = bucket.getHostApp();
    }

    public void initKssoFilter(FilterConfigFacade filterConfig) {
    }

    public void doFilterKsso(HttpServletRequestFacade request, HttpServletResponseFacade response, FilterChainFacade chain) throws IOException {
        if (response != null && this.hostApp.isMsTeamsSecurityHeadersEnabled()) {
            if (response.getHeader("Content-Security-Policy") != null) {
                response.setHeader("Content-Security-Policy", response.getHeader("Content-Security-Policy") + " https://teams.microsoft.com");
            }
            if (StringUtils.equals((CharSequence)"DENY", (CharSequence)response.getHeader("X-Frame-Options"))) {
                response.setHeader("X-Frame-Options", "SAMEORIGIN");
            }
        }
        chain.doFilterKsso(request, response);
    }

    public void destroy() {
    }
}

