/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.kerberos.servlet;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.kantegasso.servlet.http.HttpServletRequestFacade;
import com.kantegasso.servlet.http.HttpServletResponseFacade;
import jakarta.inject.Inject;
import java.io.IOException;
import java.io.Writer;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;

public class ConfigureRestAction
extends RequireAdminServlet {
    private final KerbConfManager kerbConfManager;
    private final TemplateRenderer renderer;
    private final ApplicationProperties applicationProperties;

    @Inject
    public ConfigureRestAction(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
        this.kerbConfManager = bucket.getKerbConfManager();
        this.renderer = bucket.getTemplateRenderer();
        this.applicationProperties = bucket.getApplicationProperties();
    }

    protected void doGetKsso(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
        Map<String, Object> model = this.newModel(req);
        model.put("kerberosRestAuthEnabled", this.kerbConfManager.isKerberosRestAuthEnabled());
        model.put("browserKerberosRestAuthEnabled", this.kerbConfManager.isKerberosRestFromBrowserEnabled());
        String actualUrl = this.applicationProperties.getBaseUrl(UrlMode.ABSOLUTE);
        model.put("actualBaseUrl", actualUrl);
        model.put("displayName", this.applicationProperties.getDisplayName());
        model.put("excludedPaths", StringUtils.join(this.kerbConfManager.getRestExcludedPaths(), (String)"\n"));
        resp.setContentType("text/html");
        this.renderer.render("templates/atlaskerb/restapi.vm", model, (Writer)resp.getWriter());
    }

    @Override
    protected void doPostKsso(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
        boolean kerberosRestAuthEnabled = StringUtils.equalsIgnoreCase((CharSequence)"on", (CharSequence)req.getParameter("kerberosRestAuthEnabled"));
        boolean browserKerberosRestAuthEnabled = StringUtils.equalsIgnoreCase((CharSequence)"on", (CharSequence)req.getParameter("browserKerberosRestAuthEnabled"));
        String excludedPathsStr = req.getParameter("excludedPaths");
        LinkedHashSet<String> paths = new LinkedHashSet<String>();
        if (excludedPathsStr != null && !excludedPathsStr.isEmpty()) {
            String[] lines = excludedPathsStr.split("\\r?\\n");
            for (int i = 0; i < lines.length; ++i) {
                String line = lines[i].trim().replace(",", "");
                if (StringUtils.isBlank((CharSequence)line)) continue;
                paths.add(line);
            }
        }
        this.kerbConfManager.setRestExcludedPaths(paths);
        this.kerbConfManager.setKerberosRestAuthEnabled(kerberosRestAuthEnabled);
        this.kerbConfManager.setKerberosRestFromBrowserEnabled(browserKerberosRestAuthEnabled);
        resp.sendRedirect("restapi");
    }
}

