/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.kerberos.servlet;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.kantegasso.servlet.http.HttpServletRequestFacade;
import com.kantegasso.servlet.http.HttpServletResponseFacade;
import jakarta.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import java.util.Set;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.Keytab;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.userlookup.UserLookupService;
import org.kantega.atlaskerb.wrapper.upm.PluginLicenseWrapper;

public class ConfigureKerberosAction
extends RequireAdminServlet {
    private final KerbConfManager kerbConfManager;
    private final TemplateRenderer renderer;
    private final ApplicationProperties applicationProperties;
    private final UserLookupService userLookupService;

    @Inject
    public ConfigureKerberosAction(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
        this.kerbConfManager = bucket.getKerbConfManager();
        this.renderer = bucket.getTemplateRenderer();
        this.applicationProperties = bucket.getApplicationProperties();
        this.userLookupService = bucket.getUserLookupService();
    }

    protected void doGetKsso(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
        File file = this.kerbConfManager.getKeytabFile();
        String keytabFile = file == null ? null : file.getAbsolutePath();
        Map<String, Object> model = this.newModel(req);
        model.put("menuItem", "config");
        model.put("topMenu", "Kerberos");
        model.put("displayName", this.applicationProperties.getDisplayName());
        model.put("keytabFile", keytabFile);
        if (file != null && file.exists() && file.isFile()) {
            model.put("keytabFileExists", true);
            Keytab keytab = new Keytab(this.kerbConfManager.getKeytabInfos());
            model.put("keytab", keytab);
            Set<String> realms = keytab.realms();
            if (!realms.isEmpty()) {
                model.put("realms", realms);
            }
        } else {
            resp.sendRedirect("setup");
        }
        float specificationVersion = Float.parseFloat(System.getProperty("java.specification.version"));
        if (specificationVersion < 1.7f) {
            model.put("outdatedJava", System.getProperty("java.specification.version"));
        }
        if (this.kerbConfManager.getLicenseManager().getLicense().isDefined()) {
            PluginLicenseWrapper license = new PluginLicenseWrapper((PluginLicense)this.kerbConfManager.getLicenseManager().getLicense().get());
            model.put("license", license);
        }
        model.put("kerberosEnabled", this.kerbConfManager.isKerberosEnabled());
        model.put("kerberosDisabledForAll", this.userLookupService.getDirectoriesAllowingKerberosLogin().size() == 0 && this.kerbConfManager.getAllowKerberosLoginGroups().size() == 0 && this.kerbConfManager.getDisallowKerberosLoginGroups().size() == 0);
        resp.setContentType("text/html");
        this.renderer.render("templates/atlaskerb/configure.vm", model, (Writer)resp.getWriter());
    }

    @Override
    protected void doPostKsso(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
        if (req.getParameter("resetconfig") != null) {
            this.kerbConfManager.resetConfiguration();
        }
        resp.sendRedirect("config");
    }
}

