/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.identityproviders.setup;

import com.kantegasso.oidc.OidcData;
import io.vavr.CheckedFunction0;
import io.vavr.collection.CharSeq;
import io.vavr.collection.HashMap;
import io.vavr.collection.HashSet;
import io.vavr.collection.List;
import io.vavr.collection.Seq;
import io.vavr.collection.Set;
import io.vavr.control.Either;
import io.vavr.control.Option;
import io.vavr.control.Try;
import io.vavr.control.Validation;
import jakarta.inject.Inject;
import java.io.Serializable;
import org.json.JSONArray;
import org.json.JSONObject;
import org.kantega.atlaskerb.Bucket;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.identityproviders.IdpConfigurationBuilder;
import org.kantega.atlaskerb.identityproviders.oidc.OidcIdpConfiguration;
import org.kantega.atlaskerb.identityproviders.oidc.OidcLibWrapper;
import org.kantega.atlaskerb.identityproviders.setup.IdpValidationError;
import org.kantega.atlaskerb.identityproviders.setup.IdpValidator;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.saml.login.RedirectProperties;
import org.springframework.stereotype.Component;

@Component
public class OidcValidator
extends IdpValidator {
    private final OidcLibWrapper oidcLibWrapper;
    private final HostApp hostApp;
    private final IdpConfManager idpConfManager;

    @Inject
    public OidcValidator(Bucket bucket) {
        this.hostApp = bucket.getHostApp();
        this.idpConfManager = bucket.getIdpConfManager();
        this.oidcLibWrapper = bucket.getOidcLibWrapper();
    }

    public Validation<Seq<IdpValidationError>, Try<IdpConfigurationBuilder.Oidc>> validateAndCreateOidcConfig(JSONObject actionObject) {
        JSONObject oidcConfigDraft = (JSONObject)Option.of((Object)actionObject.optJSONObject("idp")).getOrElse(JSONObject::new);
        List buildStrategies = List.of((Object)Validation.combine(this.validateIdpId(oidcConfigDraft.optString("idp_id", null)), this.validateClientId(oidcConfigDraft.optString("client_id", null)), this.validateClientSecret(oidcConfigDraft.optString("client_secret", null)), this.validateDiscoveryUrl(actionObject), this.validateName(oidcConfigDraft.optString("display_name", null)), this.validateKind(oidcConfigDraft.optString("kind", null)), this.validateScope(oidcConfigDraft.optJSONArray("scope"), IdpConfiguration.Kind.valueOf(oidcConfigDraft.optString("kind", null)))).ap(this::oidcCreate)).map(v -> {
            Validation<IdpValidationError, RedirectProperties> validatedRedirectProperties = this.validateRedirectPolicy(oidcConfigDraft.optString("redirect_policy", IdpConfiguration.RedirectPolicy.NONE.name()));
            if (validatedRedirectProperties.isValid()) {
                return v.map(oidcTry -> oidcTry.map(oidc -> (IdpConfigurationBuilder.Oidc)oidc.setRedirectProperties((RedirectProperties)validatedRedirectProperties.get())).map(oidc -> (IdpConfigurationBuilder.Oidc)oidc.setJsmRedirectProperties((RedirectProperties)validatedRedirectProperties.get())));
            }
            return v.mapError(error -> error.append((Object)((IdpValidationError)((Object)((Object)((Object)validatedRedirectProperties.getError()))))));
        }).map(v -> v.map(oidcTry -> oidcTry.map(oidc -> (IdpConfigurationBuilder.Oidc)oidc.setEnabled(oidcConfigDraft.optBoolean("is_enabled", false)))));
        return (Validation)buildStrategies.filter(Validation::isValid).getOrElse((Object)Validation.invalid((Object)((Seq)buildStrategies.filter(Validation::isInvalid).map(Validation::getError).fold((Object)List.empty(), Seq::appendAll)).append((Object)IdpValidationError.MISSING_VALUES)));
    }

    private Validation<IdpValidationError, String> validateClientId(String clientId) {
        return (Validation)Option.of((Object)clientId).map(CharSeq::of).map(CharSeq::trim).filter(cs -> cs.length() > 0).map(CharSeq::toString).transform(maybeClientId -> maybeClientId.isDefined() ? Validation.valid((Object)((String)maybeClientId.get())) : Validation.invalid((Object)((Object)IdpValidationError.OIDC_CLIENT_ID)));
    }

    private Validation<IdpValidationError, String> validateClientSecret(String clientSecret) {
        return (Validation)Option.of((Object)clientSecret).map(CharSeq::of).map(CharSeq::trim).filter(cs -> cs.length() < 6000).transform(maybeCs -> maybeCs.isDefined() ? Validation.valid((Object)((CharSeq)maybeCs.getOrElse((Object)CharSeq.of((CharSequence)""))).toString()) : Validation.invalid((Object)((Object)IdpValidationError.OIDC_CLIENT_SECRET)));
    }

    private Validation<IdpValidationError, String> validateDiscoveryUrl(JSONObject actionObject) {
        JSONObject idp = (JSONObject)Option.of((Object)actionObject.optJSONObject("idp")).getOrElse(JSONObject::new);
        String discoveryUrl = idp.optString("discovery_url");
        Try<IdpConfiguration.Kind> maybeKind = OidcIdpConfiguration.extractKind(idp.optString("kind", null));
        Either<String, OidcData> oidcDataContext = this.oidcLibWrapper.createOidcData((HashMap<String, Object>)HashMap.of((Object)"discovery_url", (Object)discoveryUrl, (Object)"workaround", (Object)OidcIdpConfiguration.extractOidcWorkaround(idp.getString("kind")), (Object)"trusted_tls_fingerprint", (Object)idp.optString("tls_fingerprint")));
        Either discovered = oidcDataContext.flatMap(this.oidcLibWrapper::discover);
        Either authorizationEndpoint = discovered.map(data -> data.get("authorization_endpoint").isDefined());
        boolean discoveryUrlIsValid = (Boolean)authorizationEndpoint.getOrElse((Object)false) != false || (Boolean)maybeKind.map(kind -> kind == IdpConfiguration.Kind.GITHUB).getOrElse((Object)false) != false;
        return discoveryUrlIsValid ? Validation.valid((Object)discoveryUrl) : Validation.invalid((Object)((Object)IdpValidationError.OIDC_DISCOVERY_URL));
    }

    private Validation<IdpValidationError, java.util.Set<String>> validateScope(JSONArray scope, IdpConfiguration.Kind kind) {
        return (Validation)Option.of((Object)scope).map(JSONArray::toList).map(HashSet::ofAll).map(scopeSet -> scopeSet.map(Object::toString)).filter(scopeSet -> scopeSet.contains((Object)"openid") || kind == IdpConfiguration.Kind.GITHUB).map(Set::toJavaSet).transform(scope1 -> scope1.isDefined() ? Validation.valid((Object)((java.util.Set)scope1.get())) : Validation.invalid((Object)((Object)IdpValidationError.OIDC_SCOPE)));
    }

    private Try<IdpConfigurationBuilder.Oidc> oidcCreate(String id, String clientId, String clientSecret, String discoveryUrl, String name, IdpConfiguration.Kind kind, java.util.Set<String> scope) {
        return Try.of((CheckedFunction0 & Serializable)() -> (IdpConfigurationBuilder.Oidc)((IdpConfigurationBuilder.Oidc)IdpConfigurationBuilder.oidc(id, kind).setName(name)).setOidcDiscoveryUrl(discoveryUrl).setOidcClientId(clientId).setOidcClientSecret(clientSecret).setScopes(scope).setJitDirectoryIfPresent(this.hostApp.getDefaultJitDirectory()));
    }
}

