/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.dircopy;

import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.entity.UserQuery;
import com.atlassian.crowd.search.query.entity.restriction.MatchMode;
import com.atlassian.crowd.search.query.entity.restriction.TermRestriction;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.kantegasso.servlet.http.HttpServletRequestFacade;
import com.kantegasso.servlet.http.HttpServletResponseFacade;
import jakarta.inject.Inject;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.utils.GroupSearchUtil;
import org.kantega.atlaskerb.velocity.model.CrowdModelUserDto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManageUsersInGroupsServlet
extends RequireAdminServlet {
    private static final Logger log = LoggerFactory.getLogger(ManageUsersInGroupsServlet.class);
    private final TemplateRenderer renderer;
    private final ApplicationProperties applicationProperties;
    private final HostApp hostApp;
    private final DirectoryManager directoryManager;

    @Inject
    public ManageUsersInGroupsServlet(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
        this.renderer = bucket.getTemplateRenderer();
        this.applicationProperties = bucket.getApplicationProperties();
        this.hostApp = bucket.getHostApp();
        this.directoryManager = this.hostApp.getDirectoryManager();
    }

    protected void doGetKsso(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
        this.modelAndRender(req, resp, null, null, 0, 0);
    }

    private void modelAndRender(HttpServletRequestFacade req, HttpServletResponseFacade resp, ArrayList<String> errorMessageList, String addToGroupId, int usersBeingAdded, int usersWasAdded) throws IOException {
        Map<String, Object> model = this.newModel(req);
        model.put("topMenu", "dark-features");
        model.put("menuItem", "manageUsersInGroups");
        model.put("contextPath", req.getContextPath());
        model.put("displayName", this.applicationProperties.getDisplayName());
        model.put("errorMessageList", errorMessageList);
        List<Map<String, String>> groups = GroupSearchUtil.getGroupsAsListMap("", this.userManager);
        model.put("groups", groups);
        String userNamePart = req.getParameter("userNamePart");
        if (userNamePart != null && StringUtils.isBlank((CharSequence)userNamePart)) {
            userNamePart = "%";
        }
        if (StringUtils.isNotBlank((CharSequence)addToGroupId)) {
            model.put("addToGroupId", addToGroupId);
            model.put("usersBeingAdded", usersBeingAdded);
            model.put("usersWasAdded", usersWasAdded);
        }
        if (StringUtils.isNotBlank((CharSequence)userNamePart)) {
            userNamePart = userNamePart.trim();
            String searchFromGroup = req.getParameter("searchFromGroup");
            if (StringUtils.isNotBlank((CharSequence)searchFromGroup)) {
                model.put("searchFromGroup", searchFromGroup);
            }
            Collection<com.atlassian.crowd.model.user.User> usersInGroup = this.getAllUsersInGroup(userNamePart, searchFromGroup);
            ArrayList<CrowdModelUserDto> crowdModelUserDtoWrappers = new ArrayList<CrowdModelUserDto>();
            for (com.atlassian.crowd.model.user.User user : usersInGroup) {
                crowdModelUserDtoWrappers.add(CrowdModelUserDto.from(user));
            }
            if (crowdModelUserDtoWrappers.size() < 10000) {
                this.addGroupsToUsers(crowdModelUserDtoWrappers);
            }
            model.put("usersInGroup", crowdModelUserDtoWrappers);
        }
        resp.setContentType("text/html");
        this.renderer.render("templates/atlaskerb/manageUsersInGroups.vm", model, (Writer)resp.getWriter());
    }

    private void addGroupsToUsers(List<CrowdModelUserDto> crowdModelUserDtoWrappers) {
        for (CrowdModelUserDto crowdModelUserDtoWrapper : crowdModelUserDtoWrappers) {
            List userCurrentGroups = null;
            try {
                userCurrentGroups = this.hostApp.getDirectoryManager().searchNestedGroupRelationships(this.hostApp.getCrowdService().getUser(crowdModelUserDtoWrapper.getUsername()).getDirectoryId(), this.getMembershipQuery(crowdModelUserDtoWrapper.getUsername()));
            }
            catch (DirectoryNotFoundException | OperationFailedException e) {
                log.error("Failed to get user groups from directory.", e);
            }
            if (userCurrentGroups == null) continue;
            for (String group : userCurrentGroups) {
                crowdModelUserDtoWrapper.addGroup(group);
            }
        }
    }

    public Collection<com.atlassian.crowd.model.user.User> getAllUsersInGroup(String userName, String groupName) {
        TermRestriction restriction = new TermRestriction(UserTermKeys.USERNAME, MatchMode.CONTAINS, (Object)userName);
        UserQuery query = new UserQuery(User.class, (SearchRestriction)restriction, 0, -1);
        Iterable source = this.hostApp.getCrowdService().search((Query)query);
        ArrayList<com.atlassian.crowd.model.user.User> foundUsers = new ArrayList<com.atlassian.crowd.model.user.User>();
        source.forEach(foundUsers::add);
        if (StringUtils.equals((CharSequence)"allGroups", (CharSequence)groupName)) {
            return foundUsers;
        }
        String finalGroupName = groupName;
        Collection filteredUsers = foundUsers.stream().filter(user -> StringUtils.isNotBlank((CharSequence)finalGroupName) && this.hostApp.getCrowdService().isUserMemberOfGroup(((com.atlassian.crowd.model.user.User)user).getName(), finalGroupName)).collect(Collectors.toList());
        return filteredUsers;
    }

    private MembershipQuery<String> getMembershipQuery(String username) {
        return QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName(username).startingAt(0).returningAtMost(-1);
    }

    @Override
    protected void doPostKsso(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
        super.doPostKsso(req, resp);
        Object errorMessage = null;
        ArrayList<String> errorMessageList = new ArrayList<String>();
        String addToGroupId = req.getParameter("addToGroupId");
        int usersBeingAdded = 0;
        int usersWasAdded = 0;
        if (StringUtils.isNotBlank((CharSequence)addToGroupId)) {
            Enumeration parameters = req.getParameterNames();
            ArrayList<String> parameterList = Collections.list(parameters);
            for (String parameter : parameterList) {
                if (!parameter.startsWith("selectUser_")) continue;
                String userToAdd = parameter.replace("selectUser_", "");
                log.info("Adding user # {} of {}: {} to group {}", new Object[]{++usersBeingAdded, parameterList.size() - 5, userToAdd, addToGroupId});
                boolean success = this.hostApp.addUserToGroup(this.userLookupService.resolveUserInDirectories(userToAdd, false).getPrincipal().get(), addToGroupId);
                usersWasAdded += success ? 1 : 0;
            }
        }
        this.modelAndRender(req, resp, errorMessageList, addToGroupId, usersBeingAdded, usersWasAdded);
    }
}

