/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.connector.admin;

import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.kantegasso.servlet.http.HttpServletRequestFacade;
import com.kantegasso.servlet.http.HttpServletResponseFacade;
import jakarta.inject.Inject;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.connector.ConnectorConfManager;
import org.kantega.atlaskerb.connector.admin.CrowdDirectoryFinder;
import org.kantega.atlaskerb.connector.model.Directory;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.wrapper.crowd.CrowdGroupWrapper;
import org.kantega.atlaskerb.wrapper.crowd.CrowdUserWrapper;

public class DirectoryGroupAction
extends RequireAdminServlet {
    private final ApplicationProperties applicationProperties;
    private final ConnectorConfManager connectorConfManager;
    private final TemplateRenderer renderer;
    private final HostApp hostApp;

    @Inject
    public DirectoryGroupAction(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
        this.applicationProperties = bucket.getApplicationProperties();
        this.connectorConfManager = bucket.getConnectorConfManager();
        this.renderer = bucket.getTemplateRenderer();
        this.hostApp = bucket.getHostApp();
    }

    protected void doGetKsso(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
        Map<String, Object> model = this.newModel(req);
        String id = req.getParameter("id");
        Directory dir = this.connectorConfManager.getDirectory(id);
        if (dir == null) {
            resp.sendError(404);
            return;
        }
        model.put("platformSupportsAvatars", this.hostApp.supportsAvatars(this.applicationProperties));
        model.put("currentConnector", dir);
        model.put("topMenu", "connectors");
        model.put("menuItem", "directoryGroups");
        model.put("displayName", this.applicationProperties.getDisplayName());
        model.put("connectorType", this.connectorConfManager.getConnectorTypes().get(dir.getKind()));
        String groupName = req.getParameter("group-name");
        model.put("groupName", groupName);
        this.render(dir, groupName, resp, model);
    }

    private void render(Directory dir, String groupName, HttpServletResponseFacade resp, Map<String, Object> model) throws IOException {
        try {
            com.atlassian.crowd.embedded.api.Directory cd = new CrowdDirectoryFinder(this.hostApp).findDirectory(dir.getId());
            DirectoryManager directoryManager = this.hostApp.getDirectoryManager();
            MembershipQuery membershipQuery = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withName(groupName).startingAt(0).returningAtMost(-1);
            Group group = directoryManager.findGroupByName(cd.getId().longValue(), groupName);
            CrowdGroupWrapper groupWrapper = new CrowdGroupWrapper(group);
            model.put("group", groupWrapper);
            List groupMembers = directoryManager.searchNestedGroupRelationships(cd.getId().longValue(), membershipQuery).stream().map(CrowdUserWrapper::new).collect(Collectors.toList());
            model.put("groupMembers", groupMembers);
            resp.setContentType("text/html");
            resp.setCharacterEncoding(StandardCharsets.UTF_8.name());
            this.renderer.render("templates/atlaskerb/connector/group-members.vm", model, (Writer)resp.getWriter());
        }
        catch (DirectoryNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (OperationFailedException e) {
            throw new RuntimeException(e);
        }
        catch (GroupNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

