/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.bitbucket;

import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.http.RepositoryUrlFragment;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.ContextProvider;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.sal.api.user.UserManager;
import jakarta.inject.Inject;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Map;
import org.kantega.atlaskerb.KerbConfManager;

public class KerberosCloneUrlContextProvider
implements ContextProvider {
    private final ApplicationProperties applicationProperties;
    private final KerbConfManager kerbConfManager;
    private final UserManager userManager;

    @Inject
    public KerberosCloneUrlContextProvider(@ComponentImport ApplicationProperties applicationProperties, KerbConfManager kerbConfManager, UserManager userManager) {
        this.applicationProperties = applicationProperties;
        this.kerbConfManager = kerbConfManager;
        this.userManager = userManager;
    }

    public void init(Map<String, String> map) throws PluginParseException {
    }

    public Map<String, Object> getContextMap(Map<String, Object> map) {
        String userInfo = null;
        if (this.kerbConfManager.getBitbucketKerberosScmUrlTypes() == null || "bothWithColonAtDefault".equals(this.kerbConfManager.getBitbucketKerberosScmUrlTypes()) || "onlyShowColonAt".equals(this.kerbConfManager.getBitbucketKerberosScmUrlTypes())) {
            userInfo = ":";
        } else if (this.kerbConfManager.getBitbucketKerberosScmUrlTypes() == null || "bothWithUsernameAtDefault".equals(this.kerbConfManager.getBitbucketKerberosScmUrlTypes()) || "onlyShowUsernameAt".equals(this.kerbConfManager.getBitbucketKerberosScmUrlTypes())) {
            String username = "username";
            if (this.userManager != null && this.userManager.getRemoteUser() != null) {
                username = this.userManager.getRemoteUser().getUsername();
            }
            userInfo = username;
        }
        try {
            URI baseUri = new URI(this.applicationProperties.getBaseUrl(UrlMode.CANONICAL).toLowerCase());
            Repository repository = (Repository)map.get("repository");
            String path = RepositoryUrlFragment.fromRepository((Repository)repository).toPath(baseUri.getPath() + "/kerberos-scm");
            URI cloneUrl = new URI(baseUri.getScheme(), userInfo, baseUri.getHost(), baseUri.getPort(), path + ".git", baseUri.getQuery(), baseUri.getFragment());
            return Collections.singletonMap("cloneUrl", cloneUrl.toString());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

