/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.bitbucket;

import jakarta.inject.Inject;
import java.util.Map;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.wrapper.web.ConditionWrapper;

public class KerberosCloneUrlCondition
extends ConditionWrapper {
    private final KerbConfManager kerbConfManager;
    private String priority;

    @Inject
    public KerberosCloneUrlCondition(KerbConfManager kerbConfManager) {
        this.kerbConfManager = kerbConfManager;
    }

    public void init(Map<String, String> params) {
        this.priority = params.get("priority");
    }

    public boolean shouldDisplayInternal(Map<String, Object> parameters) {
        if (!this.kerbConfManager.isBitbucketKerberosScmUrlsEnabled()) {
            return false;
        }
        if (this.priority == null) {
            return true;
        }
        boolean isDefault = this.kerbConfManager.isBitbucketKerberosScmUrlsDefault();
        if (isDefault) {
            return "high".equals(this.priority);
        }
        return "low".equals(this.priority);
    }
}

