/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.backup;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.kantegasso.servlet.http.HttpServletRequestFacade;
import com.kantegasso.servlet.http.HttpServletResponseFacade;
import io.vavr.control.Option;
import jakarta.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.kantega.atlaskerb.DateTool;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.backup.BackupService;

public class BackupOverviewAction
extends RequireAdminServlet {
    private final BackupService backupService;
    private final TemplateRenderer renderer;
    private final ApplicationProperties applicationProperties;

    @Inject
    public BackupOverviewAction(RequireAdminServletDependencyBucket bucket, BackupService backupService) {
        super(bucket);
        this.renderer = bucket.getTemplateRenderer();
        this.applicationProperties = bucket.getApplicationProperties();
        this.backupService = backupService;
    }

    protected void doGetKsso(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
        Map<String, Object> model = this.newModel(req);
        model.put("restored", req.getParameter("restored"));
        this.renderPage(resp, model);
    }

    private void renderPage(HttpServletResponseFacade resp, Map<String, Object> model) throws IOException {
        resp.setContentType("text/html");
        model.put("topMenu", "dashboard");
        model.put("menuItem", "backup");
        model.put("displayName", this.applicationProperties.getDisplayName());
        model.put("backups", this.backupService.getBackups());
        model.put("dateTool", new DateTool());
        File backupsDirectory = this.backupService.getBackupsDirectory();
        backupsDirectory.mkdirs();
        model.put("backupDirectory", backupsDirectory.getAbsolutePath());
        model.put("backupDirectoryExists", backupsDirectory.exists());
        model.put("backupDirectoryReadable", backupsDirectory.canRead());
        model.put("backupDirectoryWritable", backupsDirectory.canWrite());
        model.put("backupDirectoryExecutable", backupsDirectory.canExecute());
        model.put("backupDirectoryParent", backupsDirectory.getParent());
        this.renderer.render("templates/atlaskerb/backup/backup-overview.vm", model, (Writer)resp.getWriter());
    }

    @Override
    protected void doPostKsso(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
        HashMap errors = new HashMap();
        if (req.getParameter("delete") != null) {
            String[] deleteFiles;
            for (String deleteFile : deleteFiles = req.getParameterValues("deleteFiles")) {
                String filenameInput = FilenameUtils.getName((String)deleteFile);
                Option<File> maybeFile = this.backupService.getBackupFile(filenameInput);
                if (!maybeFile.isDefined()) continue;
                ((File)maybeFile.get()).delete();
            }
        }
        if (!errors.isEmpty()) {
            Map<String, Object> model = this.newModel(req);
            model.putAll(errors);
            this.renderPage(resp, model);
        } else {
            resp.sendRedirect("backup");
        }
    }
}

