/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb;

import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.api.util.Option;
import com.kantegasso.servlet.http.HttpServletRequestFacade;
import com.kantegasso.servlet.http.HttpServletResponseFacade;
import jakarta.inject.Inject;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnusedJSMCleanupAction
extends RequireAdminServlet {
    private final KerbConfManager kerbConfManager;
    private final TemplateRenderer renderer;
    private final ApplicationProperties applicationProperties;
    private final Logger log = LoggerFactory.getLogger(UnusedJSMCleanupAction.class);

    @Inject
    public UnusedJSMCleanupAction(RequireAdminServletDependencyBucket bucket, @ComponentImport PluginAccessor pluginAccessor) {
        super(bucket);
        this.kerbConfManager = bucket.getKerbConfManager();
        this.renderer = bucket.getTemplateRenderer();
        this.applicationProperties = bucket.getApplicationProperties();
    }

    protected void doGetKsso(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
        resp.setContentType("text/html");
        resp.setCharacterEncoding(StandardCharsets.UTF_8.name());
        Option license = this.kerbConfManager.getLicenseManager().getLicense();
        Map<String, Object> model = this.newModel(req);
        model.put("topMenu", "user-cleanup");
        model.put("menuItem", "unusedJSMCleanup");
        if (license.isDefined()) {
            model.put("licenseValid", ((PluginLicense)license.get()).isValid());
        } else {
            model.put("licenseValid", false);
        }
        String contextPath = req.getContextPath();
        model.put("contextPath", contextPath);
        model.put("displayName", this.applicationProperties.getDisplayName());
        this.getTemplateRenderer().render("templates/common/disable-inactive-users.vm", model, (Writer)resp.getWriter());
    }

    @Override
    protected void doPostKsso(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
        super.doPostKsso(req, resp);
        resp.sendRedirect("userCleanup/unusedJSMCleanup");
    }
}

