/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb;

import com.atlassian.seraph.auth.DefaultAuthenticator;
import com.atlassian.seraph.config.SecurityConfigFactory;
import com.atlassian.seraph.service.rememberme.RememberMeService;
import com.kantegasso.servlet.http.HttpServletRequestFacade;
import com.kantegasso.servlet.http.HttpServletResponseFacade;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemembermeUtils {
    private static final Logger log = LoggerFactory.getLogger(RemembermeUtils.class);

    public static void setRememberMeCookie(HttpServletRequestFacade request, HttpServletResponseFacade response, String username) {
        try {
            DefaultAuthenticator authenticator = (DefaultAuthenticator)SecurityConfigFactory.getInstance().getAuthenticator();
            Class<DefaultAuthenticator> authClass = DefaultAuthenticator.class;
            Method getRememberMeMethod = authClass.getDeclaredMethod("getRememberMeService", new Class[0]);
            getRememberMeMethod.setAccessible(true);
            RememberMeService rememberMeService = (RememberMeService)getRememberMeMethod.invoke((Object)authenticator, new Object[0]);
            rememberMeService.addRememberMeCookie((HttpServletRequest)request, (HttpServletResponse)response, username);
            log.debug("Remember My Login cookie was set for " + username);
        }
        catch (ClassCastException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            log.error("Problem calling authenticator to set Remember My Login cookie" + String.valueOf(e));
        }
    }
}

