/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.kantegasso.servlet.http.HttpServletRequestFacade;
import com.kantegasso.servlet.http.HttpServletResponseFacade;
import jakarta.inject.Inject;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;

public class MaxHeaderSizeAction
extends RequireAdminServlet {
    private final TemplateRenderer renderer;
    private final ApplicationProperties applicationProperties;

    @Inject
    public MaxHeaderSizeAction(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
        this.renderer = bucket.getTemplateRenderer();
        this.applicationProperties = bucket.getApplicationProperties();
    }

    protected void doGetKsso(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
        Map<String, Object> model = this.newModel(req);
        resp.setContentType("text/html");
        model.put("displayName", this.applicationProperties.getDisplayName());
        model.put("applicationVersion", this.applicationProperties.getVersion());
        model.put("localPort", req.getLocalPort());
        model.put("isTomcat", this.isServerInfo(req, "tomcat"));
        model.put("isJetty", this.isServerInfo(req, "jetty"));
        this.determineAJP(req, model);
        this.renderer.render("templates/atlaskerb/maxheadersize.vm", model, (Writer)resp.getWriter());
    }

    private boolean determineAJP(HttpServletRequestFacade req, Map<String, Object> model) {
        HttpServletRequestFacade unwrapped = req;
        if (unwrapped.getRequest().getClass().getSimpleName().equals("RequestFacade")) {
            try {
                Field requestField = unwrapped.getClass().getDeclaredField("request");
                requestField.setAccessible(true);
                Object request = requestField.get(unwrapped);
                Field connectorField = request.getClass().getDeclaredField("connector");
                connectorField.setAccessible(true);
                Object connector = connectorField.get(request);
                Method protocolMethod = connector.getClass().getDeclaredMethod("getProtocol", new Class[0]);
                protocolMethod.setAccessible(true);
                String protocol = (String)protocolMethod.invoke(connector, new Object[0]);
                model.put("protocol", protocol);
                if (protocol != null && protocol.toLowerCase().contains("ajp")) {
                    model.put("isAJP", true);
                }
                Method portMethod = connector.getClass().getMethod("getPort", new Class[0]);
                Integer port = (Integer)portMethod.invoke(connector, new Object[0]);
                model.put("connectorPort", port);
            }
            catch (NoSuchFieldException e) {
                return false;
            }
            catch (IllegalAccessException e) {
                return false;
            }
            catch (NoSuchMethodException e) {
                return false;
            }
            catch (InvocationTargetException e) {
                return false;
            }
        }
        return false;
    }

    private boolean isServerInfo(HttpServletRequestFacade req, String tomcat) {
        return req.getServletContext().getServerInfo().toLowerCase().contains(tomcat);
    }
}

