/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml.servlet;

import com.kantegasso.servlet.http.HttpServletRequestFacade;
import com.kantegasso.servlet.http.HttpServletResponseFacade;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.inject.Inject;
import org.apache.commons.codec.binary.Base64;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.saml.CertTool;
import org.kantega.atlaskerb.saml.IdpConfManager;

public class DownloadCertificateServlet
extends RequireAdminServlet {
    private final IdpConfManager idpConfManager;

    @Inject
    public DownloadCertificateServlet(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
        this.idpConfManager = bucket.getIdpConfManager();
    }

    protected void doGetKsso(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
        resp.setHeader("Content-Disposition", "attachment; filename=" + req.getServerName() + "-saml-request-cert.cer");
        resp.setContentType("application/pkix-cert");
        byte[] signingCert = this.idpConfManager.getSigningCert();
        if (req.getParameter("pem") != null) {
            byte[] pem = CertTool.formatCertificate(Base64.encodeBase64String((byte[])signingCert)).getBytes(StandardCharsets.UTF_8);
            resp.setContentLength(pem.length);
            resp.getOutputStream().write(pem);
        } else {
            resp.setContentLength(signingCert.length);
            resp.getOutputStream().write(signingCert);
        }
    }
}

