/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.hostapp;

import com.atlassian.bamboo.user.LoginInformationDao;
import com.atlassian.bamboo.user.LoginInformationManager;
import com.atlassian.config.ConfigurationException;
import com.atlassian.crowd.directory.DelegatedAuthenticationDirectory;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.UserWithAttributes;
import com.atlassian.crowd.exception.CrowdException;
import com.atlassian.crowd.exception.InactiveAccountException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserAlreadyExistsException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.model.user.User;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.util.ContextClassLoaderSwitchingUtil;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.auth.AuthenticationController;
import com.atlassian.sal.api.auth.AuthenticationListener;
import com.atlassian.sal.api.auth.Authenticator;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.user.UserManager;
import com.kantegasso.servlet.FilterChainFacade;
import com.kantegasso.servlet.http.HttpServletRequestFacade;
import com.kantegasso.servlet.http.HttpServletResponseFacade;
import com.kantegasso.servlet.http.HttpSessionFacade;
import com.kantegasso.servlet.http.MultipartHttpRequest;
import com.kantegasso.servlet.http.MultipartRequestWrapperFacade;
import com.kantegasso.servlet.http.StatusPreservableHeaderAwareResponse;
import io.vavr.CheckedFunction0;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.dispatcher.multipart.MultiPartRequestWrapper;
import org.apache.struts2.dispatcher.multipart.UploadedFile;
import org.joda.time.DateTime;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.SafeRedirect;
import org.kantega.atlaskerb.hostapp.DefaultHostApp;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.jsoncreatorclasses.DryRunAttributes;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.jsoncreatorclasses.UserCleanupResult;
import org.kantega.atlaskerb.utils.CookieUtil;
import org.kantega.atlaskerb.utils.HttpUrlUtils;
import org.kantega.atlaskerb.utils.JsonWrapper;
import org.kantega.atlaskerb.utils.UserManagerUtils;
import org.kantega.atlaskerb.utils.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BambooHostApp
extends DefaultHostApp {
    private static final String HTTP_REQUEST_IS_MUTATIVE_KEY = "bamboo.http.request.isMutative";
    private final UserManager userManager;
    private final BambooFileExtractor fileExtractor;
    private final Method getRequestCache;
    private static final Logger log = LoggerFactory.getLogger(BambooHostApp.class);
    private final LoginInformationManager loginInformationManager;
    private final LoginInformationDao loginInformationDao;

    public BambooHostApp(TransactionTemplate transactionTemplate, ApplicationProperties applicationProperties, AuthenticationListener authenticationListener, EventPublisher eventPublisher, AuthenticationController authenticationController, PluginAccessor pluginAccessor, CrowdDirectoryService crowdDirectoryService, CrowdService crowdService, SafeRedirect safeRedirect, KerbConfManager kerbConfManager, JsonWrapper jsonWrapper) {
        super(transactionTemplate, applicationProperties, authenticationListener, eventPublisher, authenticationController, pluginAccessor, crowdDirectoryService, crowdService, safeRedirect, kerbConfManager, jsonWrapper);
        this.preemptivePathMappings.add("/");
        this.preemptivePathMappings.add("/browse/*");
        this.preemptivePathMappings.add("/allPlans.action");
        this.preemptivePathMappings.add("/currentActivity.action");
        this.preemptivePathMappings.add("/myBamboo.action");
        this.preemptivePathMappings.add("/reports/*");
        this.preemptivePathMappings.add("/authors/*");
        this.preemptivePathMappings.add("/deploy/viewAllDeploymentProjects.action");
        this.hasRestApi = true;
        this.userManager = (UserManager)ComponentLocator.getComponent(UserManager.class);
        this.fileExtractor = applicationProperties.getVersion().startsWith("5.") ? new Bamboo5FileExtractor() : new Bamboo6FileExtractor();
        try {
            ClassLoader classLoader = this.getClass().getClassLoader().getParent();
            Class<?> clz = classLoader.loadClass("com.atlassian.bamboo.util.RequestCacheThreadLocal");
            this.loginInformationManager = (LoginInformationManager)ComponentLocator.getComponent(LoginInformationManager.class);
            this.loginInformationDao = (LoginInformationDao)ComponentLocator.getComponent(LoginInformationDao.class);
            this.getRequestCache = clz.getMethod("getRequestCache", new Class[0]);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            throw new RuntimeException("Cannot RequestCacheThreadLocal", e);
        }
    }

    @Override
    public Try<Integer> getFailedLoginAttempts(Principal principal) {
        return Try.of((CheckedFunction0 & Serializable)() -> this.loginInformationManager.getFailedLoginAttemptsCount(principal.getName())).onFailure(e -> log.warn("An exception occurred while obtaining currentFailedCount after for user " + UserManagerUtils.nullsafeUsernameOrAnonymous((Principal)principal), e));
    }

    @Override
    public Try<Void> setFailedLoginAttempts(Principal principal, int count) {
        String usernameForLog = UserManagerUtils.nullsafeUsernameOrAnonymous((Principal)principal);
        return Try.run(() -> Option.of((Object)this.loginInformationDao.getLoginInformationByUserName(principal.getName())).map(loginInformation -> {
            for (int i = 0; i < count; ++i) {
                loginInformation.incrementAuthAttemptCount();
            }
            return loginInformation;
        }).peek(arg_0 -> ((LoginInformationDao)this.loginInformationDao).save(arg_0)).onEmpty(() -> log.warn("Could not save captcha count for user " + usernameForLog))).onFailure(e -> log.warn("An exception occurred while setting currentFailedCount after for user " + usernameForLog, e));
    }

    @Override
    public boolean isProductMatch(String product) {
        return StringUtils.equalsIgnoreCase((CharSequence)"bamboo", (CharSequence)product);
    }

    @Override
    public boolean isModificationOnGetSupported() {
        return false;
    }

    @Override
    public boolean isRequestMapped(HttpServletRequestFacade req, String r) {
        return r.startsWith(this.getLoginPage()) || r.startsWith(this.getOldLoginPage());
    }

    @Override
    public boolean isForceLoginRequestMapped(HttpServletRequestFacade req) {
        String r = req.getRequestURI().substring(req.getContextPath().length());
        int jsessionIdx = r.indexOf(";jsessionid");
        if (jsessionIdx != -1) {
            r = r.substring(0, jsessionIdx);
        }
        if (super.isForceLoginRequestMapped(req) || r.equals("/") || r.equals("/allPlans.action") || r.equals("/currentActivity.action") || r.equals("/myBamboo.action") || r.startsWith("/reports/") || r.startsWith("/authors/") || r.startsWith("/deploy/viewAllDeploymentProjects.action")) {
            return true;
        }
        String forwardededRequestUri = (String)req.getAttribute("javax.servlet.forward.request_uri");
        if (forwardededRequestUri != null) {
            forwardededRequestUri = forwardededRequestUri.substring(req.getContextPath().length());
            return forwardededRequestUri.startsWith("/browse/");
        }
        return false;
    }

    @Override
    public boolean isPageWithLoginForm(HttpServletRequestFacade req) {
        return this.isMainLoginPage(req);
    }

    @Override
    public boolean isMainLoginPage(HttpServletRequestFacade request) {
        String internalPath = HttpUrlUtils.getInternalPath((HttpServletRequestFacade)request);
        return internalPath.startsWith(this.getLoginPage()) || internalPath.startsWith(this.getOldLoginPage());
    }

    @Override
    public void dispatchToLogin(HttpServletRequestFacade req, HttpServletResponseFacade resp, FilterChainFacade chain) throws IOException {
        String requestPath = req.getRequestURI().substring(req.getContextPath().length());
        String queryString = req.getQueryString();
        if (this.isForceLoginRequestMapped(req) && BambooHostApp.shouldDispatchToLoginPage(this.kerbConfManager)) {
            resp.sendRedirect(req.getContextPath() + this.getLoginPage() + "?trykerberos&os_destination=" + HttpUrlUtils.urlEncode((String)requestPath) + "%3F" + HttpUrlUtils.urlEncode((String)req.getQueryString()));
        } else if (!this.isPageWithLoginForm(req) && !BambooHostApp.shouldDispatchToLoginPage(this.kerbConfManager)) {
            chain.doFilterKsso(req, (HttpServletResponseFacade)new StatusPreservableHeaderAwareResponse((HttpServletResponse)resp));
        } else if (requestPath.startsWith(this.getLoginPage()) && (StringUtils.contains((CharSequence)queryString, (CharSequence)"nokerberos") || StringUtils.contains((CharSequence)queryString, (CharSequence)"trykerberos"))) {
            chain.doFilterKsso(req, (HttpServletResponseFacade)new StatusPreservableHeaderAwareResponse((HttpServletResponse)resp));
        } else {
            Object targetUrl;
            String nokerberos = "nokerberos&";
            if (req.getQueryString() != null && req.getQueryString().contains("trykerberos")) {
                nokerberos = "";
            }
            if (((String)(targetUrl = HttpUrlUtils.urlEncode((String)requestPath) + "%3F" + HttpUrlUtils.urlEncode((String)req.getQueryString()))).contains("logout%3FSAMLResponse")) {
                targetUrl = "";
            }
            this.metaRefresh(resp, req.getContextPath() + this.getLoginPage() + "?" + nokerberos + "os_destination=" + (String)targetUrl);
        }
    }

    @Override
    public Principal authenticateWithProduct(HttpServletRequestFacade req, HttpServletResponseFacade res, Principal user) {
        this.invalidateSession(req);
        this.authenticationListener.authenticationSuccess((Authenticator.Result)new Authenticator.Result.Success(user), (HttpServletRequest)req, (HttpServletResponse)res);
        req.getSessionKsso().setAttribute("seraph_defaultauthenticator_user", (Object)user);
        this.resetCaptchaOnSsoLogin(user);
        return user;
    }

    private void resetCaptchaOnSsoLogin(Principal user) {
        try {
            log.debug("Resetting captcha for user {} during SSO login.", (Object)user.getName());
            Object loginInformationManager = ComponentLocator.getComponent(this.userManager.getClass().getClassLoader().loadClass("com.atlassian.bamboo.user.LoginInformationManager"));
            Method resetFailedLoginAttemptsCount = loginInformationManager.getClass().getMethod("resetFailedLoginAttemptsCount", String.class);
            resetFailedLoginAttemptsCount.invoke(loginInformationManager, user.getName());
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            log.warn("Problem resetting capthca on SSO login", (Throwable)e);
        }
    }

    @Override
    public void publishUserAuthenticatedEvent(Principal user, HttpServletRequestFacade req, HttpServletResponseFacade res) {
        this.runTxUnchecked(() -> super.publishUserAuthenticatedEvent(user, req, res));
    }

    @Override
    public void optionallyUpdateUserFromRemoteDirectory(String username, Directory directory, boolean isNewlyCreatedUser) throws OperationFailedException, UserNotFoundException, InactiveAccountException {
        this.runTx2(() -> super.optionallyUpdateUserFromRemoteDirectory(username, directory, isNewlyCreatedUser));
    }

    @Override
    public boolean createDelegatedUser(Directory directory, String username) {
        return (Boolean)this.runTxUnchecked(() -> super.createDelegatedUser(directory, username));
    }

    @Override
    public void addOrUpdateLdapUser(String username, DelegatedAuthenticationDirectory remote) throws UserNotFoundException, OperationFailedException {
        this.runTx(() -> super.addOrUpdateLdapUser(username, remote));
    }

    @Override
    public void optionallyUpdateDelegatedUser(Directory directory, User user) {
        this.runTxUnchecked(() -> super.optionallyUpdateDelegatedUser(directory, user));
    }

    @Override
    public void optionallyAddCrowdGroups(User user) {
        this.runTxUnchecked(() -> super.optionallyAddCrowdGroups(user));
    }

    @Override
    public boolean setDefaultGroups(Principal principal, Directory directory) {
        return (Boolean)this.runTxUnchecked(() -> super.setDefaultGroups(principal, directory));
    }

    @Override
    public boolean addUserToGroup(Principal principal, String groupName) {
        return (Boolean)this.runTxUnchecked(() -> super.addUserToGroup(principal, groupName));
    }

    @Override
    public boolean removeUserFromGroup(Principal principal, String groupName) {
        return (Boolean)this.runTxUnchecked(() -> super.removeUserFromGroup(principal, groupName));
    }

    @Override
    public void addUser(Directory directory, String username, String fullName, String email, Set<String> groups, boolean isActive) throws UserAlreadyExistsException {
        AtomicBoolean failed = new AtomicBoolean(false);
        this.runTxUnchecked(() -> {
            try {
                super.addUser(directory, username, fullName, email, groups, isActive);
            }
            catch (UserAlreadyExistsException e) {
                failed.set(true);
            }
        });
        if (failed.get()) {
            throw new UserAlreadyExistsException(directory.getId().longValue(), username);
        }
    }

    @Override
    public void updateUser(Directory directory, String username, String fullName, String email, boolean isActive) {
        this.runTxUnchecked(() -> super.updateUser(directory, username, fullName, email, isActive));
    }

    @Override
    public UserCleanupResult cleanupInactiveUsers(String currentUserName, DryRunAttributes dryRunAttributes, DateTime runTimestamp, String runId) throws ConfigurationException {
        AtomicReference maybe = new AtomicReference();
        UserCleanupResult userCleanupResult = (UserCleanupResult)this.runTxUnchecked(() -> {
            try {
                return super.cleanupInactiveUsers(currentUserName, dryRunAttributes, runTimestamp, runId);
            }
            catch (ConfigurationException e) {
                log.error("Encountered an error while trying to execute user cleanup.", (Throwable)e);
                maybe.set(e);
                return null;
            }
        });
        if (userCleanupResult == null && maybe.get() != null) {
            throw (ConfigurationException)((Object)maybe.get());
        }
        return userCleanupResult;
    }

    @Override
    public String getLastLoginMillisFromUserWithAttributes(UserWithAttributes user) {
        return user.getValue("lastAuthenticated");
    }

    @Override
    public String getLastLoginParameter() {
        return "lastAuthenticated";
    }

    @Override
    public String getDefaultAdminGroupName() {
        if (this.getAllGroups().stream().anyMatch(group -> group.getName().equals("bamboo-admin"))) {
            return "bamboo-admin";
        }
        return null;
    }

    private Map<String, Object> getRequestCache() {
        try {
            return (Map)ContextClassLoaderSwitchingUtil.runInContext((ClassLoader)ComponentLocator.class.getClassLoader(), () -> (Map)this.getRequestCache.invoke(null, new Object[0]));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void invalidateSession(HttpServletRequestFacade req) {
        HttpSessionFacade session = req.getSessionKsso(false);
        if (session != null) {
            session.invalidate();
            req.getSession(true);
        }
    }

    @Override
    public boolean isLoginRequest(HttpServletRequestFacade req) {
        return "POST".equals(req.getMethod()) && (req.getRequestURI().startsWith(req.getContextPath() + "/userlogin.action") || this.isDefaultRestEndpointForAuthentication(req));
    }

    @Override
    protected boolean isAppLoggedIn(HttpSessionFacade session) {
        return session.getAttribute("seraph_defaultauthenticator_user") != null;
    }

    @Override
    public boolean shouldLoginManually(HttpServletRequestFacade req, HttpServletResponseFacade res) {
        if (req == null) {
            return super.shouldLoginManually(null, res);
        }
        return false;
    }

    @Override
    public void postSuccessfulLoginWithKerberosAction(Principal user, HttpServletRequestFacade req, HttpServletResponseFacade res, FilterChainFacade chain) throws IOException {
        String url;
        this.preventCaching(res);
        if (this.isForceLoginRequestMapped(req) && (url = this.getPossiblyForwardedRedirectURL(req)) != null) {
            res.sendRedirect(url);
            return;
        }
        String origUrl = req.getParameter("os_destination");
        if (origUrl != null) {
            this.safeRedirect.sendRedirect(req.getContextPath() + origUrl, req, res, this);
        } else {
            res.sendRedirect(req.getContextPath() + "/");
        }
    }

    private String getPossiblyForwardedRedirectURL(HttpServletRequestFacade req) {
        Object url = (String)req.getAttribute("javax.servlet.forward.request_uri");
        String queryString = null;
        if (url == null) {
            url = req.getRequestURI();
            queryString = req.getQueryString();
        }
        if (url != null) {
            if (queryString != null) {
                url = (String)url + "?" + queryString;
            }
            return url;
        }
        return null;
    }

    @Override
    public MultipartHttpRequest getMultipartRequest(final HttpServletRequestFacade req, long maxSize) {
        final MultipartRequestWrapperFacade wrapper = MultipartRequestWrapperFacade.unpackStrutsMultiPartRequest((HttpServletRequestFacade)req);
        return new MultipartHttpRequest(wrapper){

            public String getParameter(String name) {
                if (wrapper != null) {
                    return wrapper.getParameter(name);
                }
                return req.getParameter(name);
            }

            public byte[] getFile(String name) {
                if (wrapper != null) {
                    return BambooHostApp.this.fileExtractor.extractBytes(wrapper.getStrutsMultipartRequestWrapper(), name);
                }
                return null;
            }

            public String getFilename(String name) {
                String[] fileNames = wrapper.getFileNames(name);
                return fileNames == null || fileNames.length == 0 ? null : fileNames[0];
            }
        };
    }

    @Override
    public String getStandardAuthenticatorClassName() {
        return "com.atlassian.bamboo.user.authentication.BambooAuthenticator";
    }

    @Override
    public String getUserManagerLink() {
        return "/admin/user/viewUsers.action";
    }

    @Override
    public boolean canAddUser() {
        return this.userManager.isCreative();
    }

    @Override
    public String normalizeUsername(String username) {
        return username.toLowerCase();
    }

    @Override
    public String getLoginPage() {
        return "/userlogin.action";
    }

    private String getOldLoginPage() {
        return "/userlogin!doDefault.action";
    }

    @Override
    public String getMainLogoutPage() {
        return "/start.action";
    }

    @Override
    public int getDefaultApiServerPort() {
        return 5504;
    }

    private void runTxUnchecked(Runnable runnable) {
        TransactionCallback cb = () -> {
            runnable.run();
            return null;
        };
        this.runTxUnchecked(cb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T runTxUnchecked(TransactionCallback<T> callback) {
        Map<String, Object> cache = this.getRequestCache();
        Object prev = cache.put(HTTP_REQUEST_IS_MUTATIVE_KEY, true);
        try {
            Object object = this.transactionTemplate.execute(callback);
            return (T)object;
        }
        finally {
            if (prev != null) {
                cache.put(HTTP_REQUEST_IS_MUTATIVE_KEY, prev);
            }
        }
    }

    private void runTx(UserDirectoryRunnable runnable) throws UserNotFoundException, OperationFailedException {
        UserDirectoryCallable<Void> callable = runnable.asCallable();
        try {
            this.runTx(callable);
        }
        catch (InactiveAccountException e) {
            throw new RuntimeException("Unexpected checked exception", e);
        }
    }

    private void runTx2(UserDirectoryRunnable runnable) throws UserNotFoundException, OperationFailedException, InactiveAccountException {
        UserDirectoryCallable<Void> callable = runnable.asCallable();
        this.runTx(callable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T runTx(UserDirectoryCallable<T> callable) throws UserNotFoundException, OperationFailedException, InactiveAccountException {
        Map<String, Object> cache = this.getRequestCache();
        Object prev = cache.put(HTTP_REQUEST_IS_MUTATIVE_KEY, true);
        try {
            TransactionCallback<T> cb = this.wrap(callable);
            Object object = this.transactionTemplate.execute(cb);
            return (T)object;
        }
        catch (WrappedCrowdException e) {
            T t = this.unwrapException(e);
            return t;
        }
        finally {
            if (prev != null) {
                cache.put(HTTP_REQUEST_IS_MUTATIVE_KEY, prev);
            }
        }
    }

    private <T> T unwrapException(WrappedCrowdException e) throws UserNotFoundException, OperationFailedException, InactiveAccountException {
        Throwable cause = e.getCause();
        if (cause instanceof UserNotFoundException) {
            throw (UserNotFoundException)cause;
        }
        if (cause instanceof OperationFailedException) {
            throw (OperationFailedException)cause;
        }
        if (cause instanceof InactiveAccountException) {
            throw (InactiveAccountException)cause;
        }
        throw e;
    }

    private <T> TransactionCallback<T> wrap(UserDirectoryCallable<T> callback) {
        return () -> {
            try {
                return callback.call();
            }
            catch (InactiveAccountException | OperationFailedException | UserNotFoundException e) {
                throw new WrappedCrowdException((CrowdException)e);
            }
        };
    }

    @Override
    public String optionallyDecryptLdapPassword(String ldapPasswordParameter) {
        return (String)this.decryptLdapPassword(ldapPasswordParameter).getOrElse((Object)ldapPasswordParameter);
    }

    protected Option<String> decryptLdapPassword(String encryptedLdapPassword) {
        try {
            Object secretEncryptionServiceInternal = ComponentLocator.getComponent(this.userManager.getClass().getClassLoader().loadClass("com.atlassian.bamboo.crypto.instance.SecretEncryptionServiceInternal"));
            Method isEncrypted = secretEncryptionServiceInternal.getClass().getMethod("isEncrypted", String.class);
            String ldapPassword = encryptedLdapPassword;
            boolean isEncryptedResult = (Boolean)isEncrypted.invoke(secretEncryptionServiceInternal, encryptedLdapPassword);
            if (isEncryptedResult) {
                Method decrypt = secretEncryptionServiceInternal.getClass().getMethod("decrypt", String.class);
                ldapPassword = (String)decrypt.invoke(secretEncryptionServiceInternal, encryptedLdapPassword);
            }
            return Option.of((Object)ldapPassword);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            log.warn("Could not load method in LDAP password fetch: ", (Throwable)e);
        }
        catch (Exception e) {
            log.warn("Failed to fetch LDAP password: ", (Throwable)e);
        }
        return Option.none();
    }

    @Override
    public void hasUsedTraditionalLogin(HttpServletRequestFacade request, HttpServletResponseFacade response) {
        log.debug("Setting traditional login cookie");
        CookieUtil.setTraditionalLoginCookie(request, response);
    }

    @Override
    public void notLoginRequest(HttpServletRequestFacade request, HttpServletResponseFacade response) {
        log.debug("Removing traditional login cookie");
        CookieUtil.removeCookie(request, response, "hasUsedTraditionalLogin");
    }

    @Override
    public boolean isSyncDirCompatible() {
        return false;
    }

    @Override
    public boolean isLegacyLoginPageDefaultOnCurrentApplicationVersion() {
        Version applicationVersion = Version.of((String)this.applicationProperties.getVersion());
        return applicationVersion.isLowerThan(Version.of((String)"10.1"));
    }

    @Override
    public String getForgotPasswordUrl() {
        return "/forgotPassword.action";
    }

    @Override
    public String getDefaultLicenseGroup() {
        return "bamboo-users";
    }

    @Override
    public boolean shouldIncludeContextPathInWebResource() {
        return false;
    }

    static class Bamboo5FileExtractor
    extends BambooFileExtractor {
        private final Method getFile;

        Bamboo5FileExtractor() {
            try {
                this.getFile = MultiPartRequestWrapper.class.getMethod("getFiles", String.class);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("Bamboo5FileExtractor cannot be instanciated on Bamboo >=6", e);
            }
        }

        @Override
        public byte[] extractBytes(MultiPartRequestWrapper wrapper, String name) {
            File[] fileArray;
            int n;
            int n2;
            File[] files;
            try {
                files = (File[])this.getFile.invoke((Object)wrapper, name);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            if (files != null && (n2 = 0) < (n = (fileArray = files).length)) {
                File file = fileArray[n2];
                try {
                    return FileUtils.readFileToByteArray((File)file);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return null;
        }
    }

    static class Bamboo6FileExtractor
    extends BambooFileExtractor {
        Bamboo6FileExtractor() {
        }

        @Override
        public byte[] extractBytes(MultiPartRequestWrapper wrapper, String name) {
            UploadedFile[] files = wrapper.getFiles(name);
            if (files != null) {
                for (UploadedFile file : files) {
                    if (!file.isFile()) continue;
                    try {
                        return FileUtils.readFileToByteArray((File)((File)file.getContent()));
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            return null;
        }
    }

    static abstract class BambooFileExtractor {
        BambooFileExtractor() {
        }

        public abstract byte[] extractBytes(MultiPartRequestWrapper var1, String var2);
    }

    @FunctionalInterface
    static interface UserDirectoryRunnable {
        public void run() throws UserNotFoundException, OperationFailedException, InactiveAccountException;

        default public UserDirectoryCallable<Void> asCallable() {
            return () -> {
                this.run();
                return null;
            };
        }
    }

    @FunctionalInterface
    static interface UserDirectoryCallable<T> {
        public T call() throws UserNotFoundException, OperationFailedException, InactiveAccountException;
    }

    private static class WrappedCrowdException
    extends RuntimeException {
        public WrappedCrowdException(CrowdException e) {
            super((Throwable)e);
        }
    }
}

