/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb;

import com.kantegasso.servlet.http.HttpServletRequestFacade;
import com.kantegasso.servlet.http.HttpServletResponseFacade;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.security.SanitizedLogStatement;
import org.kantega.atlaskerb.utils.HttpUrlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SafeRedirect {
    private static final Logger log = LoggerFactory.getLogger(SafeRedirect.class);
    private final KerbConfManager kerbConfManager;
    private static final String SEND_REDIRECT_ONGOING = "com.atlassian.web.servlet.plugin.request.RedirectInterceptingResponse.sendRedirect";

    @Inject
    public SafeRedirect(KerbConfManager kerbConfManager) {
        this.kerbConfManager = kerbConfManager;
    }

    public static void sendCompleteUrlRedirect(HttpServletRequestFacade req, HttpServletResponseFacade res, String targetUri) throws IOException {
        try {
            String redirectUrl = HttpUrlUtils.appendUriToRequestBaseUrl((HttpServletRequestFacade)req, (String)targetUri);
            String validated = new URI(redirectUrl).toURL().toString();
            log.debug("Redirecting to complete url" + validated);
            res.sendRedirect(validated);
            return;
        }
        catch (MalformedURLException | URISyntaxException e) {
            SanitizedLogStatement.of(targetUri).andThenLog(s -> log.debug("Url validation failed for '{}'; will send to rootpage. Msg: {}", s, (Object)e.getMessage()));
            String requestBaseUrl = HttpUrlUtils.extractRequestBaseUrl((HttpServletRequestFacade)req);
            res.sendRedirect(requestBaseUrl + "/");
            return;
        }
    }

    public void sendRedirect(String targetUrl, HttpServletRequestFacade req, HttpServletResponseFacade res, HostApp hostApp) throws IOException {
        String rootpageRedirectFallback = "/";
        req.setAttribute(SEND_REDIRECT_ONGOING, (Object)Boolean.TRUE);
        if (this.isLocal(targetUrl)) {
            SanitizedLogStatement.of(targetUrl).andThenLog(t -> log.debug("Local redirect to '{}'", t));
            try {
                new URI(targetUrl);
                if (hostApp.isMainLoginPage(req)) {
                    if (hostApp.getRedirectTarget(req) != null) {
                        targetUrl = hostApp.getRedirectTarget(req);
                    } else if (hostApp.sendToDashboardAfterLogin()) {
                        targetUrl = "/";
                    }
                }
                if (this.kerbConfManager.isAllowLegacyRelativeSafeRedirect()) {
                    log.debug("Legacy redirect enabled. Running relative redirect...");
                    res.sendRedirect(targetUrl);
                    return;
                }
                SafeRedirect.sendCompleteUrlRedirect(req, res, targetUrl);
            }
            catch (URISyntaxException e) {
                SanitizedLogStatement.of(targetUrl).andThenLog(t -> log.debug("URISyntaxException for '{}'; will send to rootpage. Msg: {}", t, (Object)e.getMessage()));
                SafeRedirect.sendCompleteUrlRedirect(req, res, "/");
            }
        } else {
            String requestBaseUrl = HttpUrlUtils.extractRequestBaseUrl((HttpServletRequestFacade)req);
            boolean targetServernameEqualsRequestServername = HttpUrlUtils.servernameEquals((String)targetUrl, (String)requestBaseUrl);
            if (targetServernameEqualsRequestServername) {
                log.debug("Non local redirect to '{}' (is sent to root page: {})", (Object)targetUrl, (Object)false);
                res.sendRedirect(targetUrl);
            } else {
                log.warn("AbsoluteUrl {} is not the base URL {} for this instance, using fallback redirect to /", (Object)targetUrl, (Object)requestBaseUrl);
                if (this.kerbConfManager.isAllowLegacyRelativeSafeRedirect()) {
                    log.debug("Legacy redirect enabled. Running relative...");
                    res.sendRedirect("/");
                    return;
                }
                SafeRedirect.sendCompleteUrlRedirect(req, res, "/");
            }
        }
    }

    public boolean isLocal(String uri) {
        if (StringUtils.isBlank((CharSequence)uri)) {
            return false;
        }
        String lower = uri.toLowerCase();
        return lower.startsWith("/") && !lower.startsWith("//") && !lower.startsWith("/%2f") && !lower.startsWith("/\\") && !lower.matches("^[a-z][a-z0-9+.-]*:.*");
    }
}

