/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.identityproviders.oidc;

import com.kantegasso.oidc.OidcData;
import com.kantegasso.oidc.OidcLibrary;
import io.vavr.collection.HashMap;
import io.vavr.collection.List;
import io.vavr.control.Either;
import io.vavr.control.Option;
import org.kantega.atlaskerb.utils.JsonWrapper;

public class OidcLibWrapper {
    public static final String IS_TEST = "ksso:is_test";
    final OidcLibrary oidcLibrary;

    public static OidcLibWrapper initiate(JsonWrapper jsonWrapper) {
        return new OidcLibWrapper(jsonWrapper);
    }

    private OidcLibWrapper(JsonWrapper jsonWrapper) {
        this.oidcLibrary = new OidcLibrary(jsonWrapper.objectWriter(), jsonWrapper.objectReader());
    }

    public Either<String, OidcData> createOidcData(HashMap<String, Object> data) {
        return (Either)Option.of(data).map(arg_0 -> ((OidcLibrary)this.oidcLibrary).authFlow(arg_0)).getOrElse(() -> ((OidcLibrary)this.oidcLibrary).authFlow());
    }

    public Either<String, OidcData> createOidcData() {
        return this.oidcLibrary.authFlow();
    }

    public Either<String, OidcData> discover(OidcData oidcData) {
        return this.oidcLibrary.discover(oidcData);
    }

    public Either<String, OidcData> authentication(OidcData oidcData, List<String> scope) {
        return this.oidcLibrary.authentication(oidcData, scope);
    }

    public Either<String, OidcData> resume(OidcData oidcData, String state, String code) {
        return this.oidcLibrary.resume(oidcData, state, code);
    }

    public Either<String, OidcData> initiateSingleLogout(OidcData oidcData) {
        return this.oidcLibrary.initiateSingleLogout(oidcData);
    }
}

