/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.identityproviders;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.sal.api.user.UserProfile;
import org.kantega.atlaskerb.kerberos.PrincipalEntry;

public class UsernameSearchResult {
    private final Directory directory;
    private final PrincipalEntry resolvedUserPrincipalEntry;
    private final UserProfile userProfile;

    private UsernameSearchResult(Directory directory, PrincipalEntry resolvedUserPrincipalEntry, UserProfile userProfile) {
        this.directory = directory;
        this.resolvedUserPrincipalEntry = resolvedUserPrincipalEntry;
        this.userProfile = userProfile;
    }

    public static UsernameSearchResult inactive(Directory directory, PrincipalEntry principalEntry) {
        return new UsernameSearchResult(directory, principalEntry, null);
    }

    public static UsernameSearchResult notFound(Directory directory) {
        return new UsernameSearchResult(directory, null, null);
    }

    public static UsernameSearchResult resolved(Directory directory, PrincipalEntry principalEntry, UserProfile userProfile) {
        return new UsernameSearchResult(directory, principalEntry, userProfile);
    }

    public Directory getDirectory() {
        return this.directory;
    }

    public PrincipalEntry getResolvedUserPrincipalEntry() {
        return this.resolvedUserPrincipalEntry;
    }

    public UserProfile getUserProfile() {
        return this.userProfile;
    }

    public boolean isInactive() {
        return this.directory != null && this.resolvedUserPrincipalEntry != null && this.userProfile == null;
    }

    public boolean isNotFound() {
        return this.directory != null && this.resolvedUserPrincipalEntry == null && this.userProfile == null;
    }

    public boolean isNotFoundWithoutDirectoryCheck() {
        return this.resolvedUserPrincipalEntry == null && this.userProfile == null;
    }

    public boolean isResolved() {
        return this.directory != null && this.resolvedUserPrincipalEntry != null && this.userProfile != null;
    }
}

