/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.dircopy;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupWithAttributes;
import com.atlassian.crowd.model.group.InternalDirectoryGroup;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.MatchMode;
import com.atlassian.crowd.search.query.entity.restriction.TermRestriction;
import com.atlassian.crowd.search.query.entity.restriction.constants.GroupTermKeys;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.kantegasso.servlet.http.HttpServletRequestFacade;
import com.kantegasso.servlet.http.HttpServletResponseFacade;
import io.vavr.control.Option;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.velocity.model.DirectoryDto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManageGroupsInDirectoriesServlet
extends RequireAdminServlet {
    private static final Logger log = LoggerFactory.getLogger(ManageGroupsInDirectoriesServlet.class);
    private final TemplateRenderer renderer;
    private final ApplicationProperties applicationProperties;
    private final HostApp hostApp;
    private final DirectoryManager directoryManager;

    @Inject
    public ManageGroupsInDirectoriesServlet(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
        this.renderer = bucket.getTemplateRenderer();
        this.applicationProperties = bucket.getApplicationProperties();
        this.hostApp = bucket.getHostApp();
        this.directoryManager = this.hostApp.getDirectoryManager();
    }

    protected void doGetKsso(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
        this.modelAndRender(req, resp, null, null);
    }

    private void modelAndRender(HttpServletRequestFacade req, HttpServletResponseFacade resp, String errorMessage, String errorGroup) throws IOException {
        Map<String, Object> model = this.newModel(req);
        model.put("topMenu", "dark-features");
        model.put("menuItem", "manageGroupsInDirectories");
        model.put("contextPath", req.getContextPath());
        model.put("displayName", this.applicationProperties.getDisplayName());
        model.put("errorMessage", errorMessage);
        model.put("errorGroup", errorGroup);
        String groupName = req.getParameter("groupName");
        ArrayList allGroupsInDirectories = new ArrayList();
        List directories = this.hostApp.getCrowdDirectoryService().findAllDirectories();
        EntityQuery groupQuery = QueryBuilder.queryFor(InternalDirectoryGroup.class, (EntityDescriptor)EntityDescriptor.group()).returningAtMost(-1);
        if (groupName != null) {
            model.put("groupName", groupName);
            groupQuery = QueryBuilder.queryFor(InternalDirectoryGroup.class, (EntityDescriptor)EntityDescriptor.group()).with((SearchRestriction)new TermRestriction(GroupTermKeys.NAME, MatchMode.EXACTLY_MATCHES, (Object)groupName)).returningAtMost(-1);
        }
        for (Directory directory : directories) {
            try {
                List groups = this.directoryManager.searchGroups(directory.getId().longValue(), groupQuery);
                allGroupsInDirectories.addAll(groups);
            }
            catch (DirectoryNotFoundException | OperationFailedException e) {
                log.error("Failed to get groups from directory: " + directory.getName(), e);
            }
        }
        Comparator caseInsensitiveComparator = String::compareToIgnoreCase;
        TreeMap<String, GroupInDirectory> groupsInDirectories = new TreeMap<String, GroupInDirectory>(caseInsensitiveComparator);
        for (Group group : allGroupsInDirectories) {
            try {
                Directory directory = this.directoryManager.findDirectoryById(group.getDirectoryId());
                io.vavr.collection.Map attributeMap = null;
                if (allGroupsInDirectories.size() < 100) {
                    try {
                        GroupWithAttributes groupWithAttributes = this.directoryManager.findGroupWithAttributesByName(directory.getId().longValue(), group.getName());
                        attributeMap = io.vavr.collection.List.ofAll((Iterable)groupWithAttributes.getKeys()).toMap(key -> key, key -> groupWithAttributes.getValue(key));
                    }
                    catch (GroupNotFoundException | OperationFailedException e) {
                        log.error("Failed to get group attributes from group: " + group.getName(), e);
                    }
                }
                if (groupsInDirectories.containsKey(group.getName())) {
                    ((GroupInDirectory)groupsInDirectories.get(group.getName())).addDirectory(DirectoryDto.from(directory), this.hostApp.isWritableDirectory(directory), (io.vavr.collection.Map<String, String>)attributeMap);
                    continue;
                }
                GroupInDirectory groupInDirectory = null;
                groupInDirectory = new GroupInDirectory(group.getName(), directory, this.hostApp.isWritableDirectory(directory), (io.vavr.collection.Map<String, String>)attributeMap);
                groupsInDirectories.put(group.getName(), groupInDirectory);
            }
            catch (DirectoryNotFoundException e) {
                log.error("Failed to get directory from group: " + group.getName(), (Throwable)e);
            }
        }
        model.put("groupsInDirectories", groupsInDirectories);
        resp.setContentType("text/html");
        this.renderer.render("templates/atlaskerb/manageGroupsInDirectories.vm", model, (Writer)resp.getWriter());
    }

    @Override
    protected void doPostKsso(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
        super.doPostKsso(req, resp);
        String errorMessage = null;
        String group = req.getParameter("removeGroup");
        String directoryId = req.getParameter("removeFromDirectory");
        try {
            String loggedInUser = this.getLoggedInUsername(req);
            boolean isMember = this.hostApp.getCrowdService().isUserMemberOfGroup(loggedInUser, group);
            if (isMember) {
                errorMessage = "You cannot remove the group '" + group + "' that your user is a member of.";
                this.modelAndRender(req, resp, errorMessage, group);
                return;
            }
            if (StringUtils.isNotBlank((CharSequence)directoryId)) {
                Directory directory = this.directoryManager.findDirectoryById(Long.parseLong(directoryId));
                this.directoryManager.removeGroup(directory.getId().longValue(), group);
            } else {
                directoryId = "all directories";
                this.hostApp.getCrowdService().removeGroup(this.hostApp.getCrowdService().getGroup(group));
            }
        }
        catch (Exception e) {
            errorMessage = "Failed to remove group: " + group + " from directory with id " + directoryId;
            log.warn(errorMessage, (Throwable)e);
        }
        this.modelAndRender(req, resp, errorMessage, group);
    }

    private String getLoggedInUsername(HttpServletRequestFacade req) {
        String loggedInUsername = (String)Option.of((Object)this.userManager.getRemoteUser((HttpServletRequest)req)).map(UserProfile::getUsername).getOrNull();
        return loggedInUsername;
    }

    public static class GroupInDirectory {
        private final String groupName;
        private boolean inOneOrMoreActiveDirs;
        private final DirectoryDetails masterDirectory;
        private ArrayList<DirectoryDetails> directories;

        public GroupInDirectory(String groupName, Directory masterDirectory, boolean isWritable, io.vavr.collection.Map<String, String> attributeMap) {
            this.groupName = groupName;
            this.masterDirectory = new DirectoryDetails(DirectoryDto.from(masterDirectory), isWritable, attributeMap);
            this.setInOneOrMoreActiveDirs(masterDirectory.isActive());
            this.directories = new ArrayList();
        }

        public String getGroupName() {
            return this.groupName;
        }

        public DirectoryDetails getMasterDirectory() {
            return this.masterDirectory;
        }

        public void addDirectory(DirectoryDto directory, boolean isWritable, io.vavr.collection.Map<String, String> attributeMap) {
            this.directories.add(new DirectoryDetails(directory, isWritable, attributeMap));
            this.setInOneOrMoreActiveDirs(directory.isActive());
        }

        public ArrayList<DirectoryDetails> getDirectories() {
            return this.directories;
        }

        public boolean isInOneOrMoreActiveDirs() {
            return this.inOneOrMoreActiveDirs;
        }

        private void setInOneOrMoreActiveDirs(boolean isActive) {
            if (isActive) {
                this.inOneOrMoreActiveDirs = true;
            }
        }
    }

    public static class DirectoryDetails {
        private final DirectoryDto directory;
        private final boolean isWritable;
        private final io.vavr.collection.Map<String, String> attributeMap;

        public DirectoryDetails(DirectoryDto directory, boolean isWritable, io.vavr.collection.Map<String, String> attributeMap) {
            this.directory = directory;
            this.isWritable = isWritable;
            this.attributeMap = attributeMap;
        }

        public DirectoryDto getDirectory() {
            return this.directory;
        }

        public boolean isWritable() {
            return this.isWritable;
        }

        public Map<String, String> getAttributeMap() {
            if (this.attributeMap == null) {
                return new HashMap<String, String>();
            }
            return this.attributeMap.toJavaMap();
        }
    }
}

