/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.connector.azure;

import com.atlassian.json.jsonorg.JSONArray;
import com.atlassian.json.jsonorg.JSONObject;
import io.vavr.control.Option;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.io.FileUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.kantega.atlaskerb.connector.ConnectorHttpClient;
import org.kantega.atlaskerb.connector.ConnectorURIBuilder;
import org.kantega.atlaskerb.connector.api.ConnectorAPI;
import org.kantega.atlaskerb.connector.api.ConnectorApiException;
import org.kantega.atlaskerb.connector.api.GroupHandler;
import org.kantega.atlaskerb.connector.api.MembershipHandler;
import org.kantega.atlaskerb.connector.api.UserHandler;
import org.kantega.atlaskerb.connector.azure.AzureAdBatchHandler;
import org.kantega.atlaskerb.connector.azure.AzureGraphHttpClient;
import org.kantega.atlaskerb.connector.model.SecurityGroupFilter;
import org.kantega.atlaskerb.connector.model.UsernameSelectionAttribute;
import org.kantega.atlaskerb.connector.model.crowdapi.GroupItem;
import org.kantega.atlaskerb.connector.model.crowdapi.MembershipItem;
import org.kantega.atlaskerb.connector.model.crowdapi.UserItem;
import org.kantega.atlaskerb.connector.model.crowdapi.UserMember;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AzureGraphApi
implements ConnectorAPI {
    private final AzureGraphHttpClient client;
    private final Logger log = LoggerFactory.getLogger(AzureGraphApi.class);
    private final String adminBaseUrl;
    private final int top;
    private boolean isUseSAMAccountName;
    private UsernameSelectionAttribute usernameSelectionAttribute;
    private final String tenantId;
    private final String clientSecret;
    private SecurityGroupFilter securityGroupsOnly = SecurityGroupFilter.SECURITY_GROUPS_ONLY;

    public AzureGraphApi(String tenantId, String applicationId, String clientSecret, boolean isUseSAMAccountName, UsernameSelectionAttribute usernameSelectionAttribute) {
        String loginBaseUrl = System.getProperty("connector.azure.login.url", "https://login.microsoftonline.com");
        this.adminBaseUrl = System.getProperty("connector.azure.graph.url", "https://graph.microsoft.com");
        this.top = Integer.parseInt(System.getProperty("connector.azure.top", "-1"));
        this.client = AzureGraphHttpClient.createAzureGraphHttpClient(loginBaseUrl, tenantId, applicationId, clientSecret);
        this.isUseSAMAccountName = isUseSAMAccountName;
        this.usernameSelectionAttribute = usernameSelectionAttribute;
        this.tenantId = tenantId;
        this.clientSecret = clientSecret;
    }

    public AzureGraphApi(String tenantId, String applicationId, String clientSecret, boolean isUseSAMAccountName, SecurityGroupFilter securityGroupsOnly, UsernameSelectionAttribute usernameSelectionAttribute) {
        this(tenantId, applicationId, clientSecret, isUseSAMAccountName, usernameSelectionAttribute);
        this.securityGroupsOnly = securityGroupsOnly;
    }

    private String getUserSelectionAttributes() {
        String attrs = "id,userPrincipalName,mail,givenName,surname,displayName,accountEnabled,userType";
        if (this.isUseSAMAccountName) {
            attrs = attrs + ",onPremisesSamAccountName";
        }
        return attrs;
    }

    private void deleteDir(Path dirPath) {
        try {
            FileUtils.deleteDirectory((File)dirPath.toFile());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setAvatars(Map<String, String> userNameToId, Path homeDir, String dirName, final HostApp hostApp) throws InterruptedException {
        final Path avatarDirPath = Paths.get(homeDir.toString(), "avatars", "aad", "directories", dirName);
        try {
            Files.createDirectories(avatarDirPath, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        AzureAdBatchHandler aadBatchHandler = new AzureAdBatchHandler(this.adminBaseUrl, this.client){

            @Override
            public void onSuccess(String requestReference, JSONArray values) {
                String fileExtension = (String)values.get(1);
                byte[] imageBytes = DatatypeConverter.parseBase64Binary((String)values.get(0).toString());
                String imageStringData = Base64.getEncoder().encodeToString(imageBytes);
                String sanitizedImage = StringEscapeUtils.escapeXml11((String)imageStringData);
                imageBytes = Base64.getDecoder().decode(sanitizedImage);
                hostApp.setUserProfilePicture(requestReference, fileExtension, imageBytes, avatarDirPath);
            }

            @Override
            public void onError(String requestReference, int status, JSONObject response) {
                if (status != 404) {
                    AzureGraphApi.this.log.warn("Failed to fetch avatar of user {}, responded with status {}", (Object)requestReference, (Object)status);
                }
            }
        };
        for (String userName : userNameToId.keySet()) {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException("setAvatars aborting");
            }
            aadBatchHandler.registerRequest(userName.trim(), this.requestUriBuilder("/users/" + userNameToId.get(userName) + "/photo/$value/").toString(true));
        }
        aadBatchHandler.run();
        this.deleteDir(Paths.get(homeDir.toString(), "avatars"));
    }

    @Override
    public void findAllUsers(UserHandler userHandler) throws InterruptedException {
        ConnectorURIBuilder uriBuilder = this.requestUriBuilder("/v1.0/users").queryParam("$select", this.getUserSelectionAttributes());
        String url = uriBuilder.toString();
        do {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException("findAllUsers aborting");
            }
            ConnectorHttpClient.Response response = this.client.httpGet(url);
            JSONObject json = response.getAsJSONObject();
            url = json.isNull("@odata.nextLink") ? null : json.getString("@odata.nextLink");
            JSONArray jsonUsers = (JSONArray)json.get("value");
            for (int i = 0; i < jsonUsers.length(); ++i) {
                JSONObject jsonUser = (JSONObject)jsonUsers.get(i);
                UserItem userItem = this.toUserItem(jsonUser);
                if (userItem == null || userHandler == null) continue;
                userHandler.handleUser(userItem);
            }
        } while (url != null);
    }

    @Override
    public void findAllGroups(GroupHandler groupHandler) throws InterruptedException {
        ConnectorURIBuilder uriBuilder = this.requestUriBuilder("/v1.0/groups");
        if (this.securityGroupsOnly == SecurityGroupFilter.SECURITY_GROUPS_ONLY) {
            uriBuilder = uriBuilder.queryParam("$filter", "securityEnabled eq true");
        }
        String url = uriBuilder.toString();
        do {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException("findAllGroups aborting");
            }
            ConnectorHttpClient.Response response = this.client.httpGet(url);
            JSONObject json = response.getAsJSONObject();
            url = json.isNull("@odata.nextLink") ? null : json.getString("@odata.nextLink");
            JSONArray jsonGroups = (JSONArray)json.get("value");
            for (int i = 0; i < jsonGroups.length(); ++i) {
                JSONObject jsonGroup = (JSONObject)jsonGroups.get(i);
                GroupItem group = new GroupItem();
                group.setName(jsonGroup.getString("displayName"));
                if (!jsonGroup.isNull("description")) {
                    group.setDescription(jsonGroup.getString("description"));
                }
                group.setId(jsonGroup.getString("id"));
                group.setActive(true);
                groupHandler.handleGroup(group);
            }
        } while (url != null);
    }

    @Override
    public void findAllMemberships(Set<UserItem> includedUsers, Set<GroupItem> includedGroups, MembershipHandler membershipHandler, final boolean useNestedGroups) throws InterruptedException {
        final HashMap userNameById = new HashMap();
        HashMap<String, String> groupNameById = new HashMap<String, String>();
        final HashMap memItemByGroupId = new HashMap();
        final HashMap subgroupIdsByGroupId = new HashMap();
        final HashMap groupIdByName = new HashMap();
        UserHandler userHandler = user -> userNameById.put(user.getKey(), user.getName());
        includedUsers.forEach(userHandler::handleUser);
        GroupHandler groupHandler = group -> {
            groupNameById.put(group.getId(), group.getName());
            if (groupIdByName.containsKey(group.getName())) {
                this.log.warn("Groups with duplicate names: " + group.getName());
            }
            groupIdByName.put(group.getName(), group.getId());
        };
        includedGroups.forEach(groupHandler::handleGroup);
        AzureAdBatchHandler aadBatchHandler = new AzureAdBatchHandler(this.adminBaseUrl, this.client){

            @Override
            public void onSuccess(String groupName, JSONArray values) {
                MembershipItem membershipItem = new MembershipItem();
                membershipItem.setName(groupName);
                for (int j = 0; j < values.length(); ++j) {
                    JSONObject jsonMember = (JSONObject)values.get(j);
                    if ("#microsoft.graph.user".equals(jsonMember.getString("@odata.type"))) {
                        String userId = jsonMember.getString("id");
                        String username = AzureGraphApi.this.getUsername(jsonMember);
                        Option.of((Object)((String)userNameById.get(userId))).map(uname -> {
                            UserMember mem = new UserMember();
                            mem.setName((String)uname);
                            return mem;
                        }).peek(userMember -> membershipItem.getUserCollection().getUsers().add((UserMember)userMember)).onEmpty(() -> AzureGraphApi.this.log.debug("User {}/{} is member of {} but not present in filtered user list; skipping.", new Object[]{userId, username, groupName}));
                        continue;
                    }
                    if (!"#microsoft.graph.group".equals(jsonMember.getString("@odata.type")) || !useNestedGroups) continue;
                    String groupId = (String)groupIdByName.get(groupName);
                    String subgroupId = jsonMember.getString("id");
                    if (subgroupIdsByGroupId.containsKey(groupId)) {
                        if (subgroupId.equals(groupId)) continue;
                        ((List)subgroupIdsByGroupId.get(groupId)).add(subgroupId);
                        continue;
                    }
                    subgroupIdsByGroupId.put(groupId, new ArrayList<String>(Collections.singletonList(subgroupId)));
                }
                memItemByGroupId.put((String)groupIdByName.get(groupName), membershipItem);
            }

            @Override
            public void onError(String requestReference, int status, JSONObject responseBody) {
                AzureGraphApi.this.throwConnectorException(status, "Batch request " + requestReference + " failed to execute", responseBody);
            }
        };
        groupNameById.forEach((groupId, groupName) -> aadBatchHandler.registerRequest((String)groupName, this.requestUriBuilder("/groups/" + groupId + "/members").toString(true)));
        aadBatchHandler.run();
        if (useNestedGroups) {
            subgroupIdsByGroupId.keySet().forEach(parentGroupId -> {
                HashMap<String, Boolean> visitedGroupIds = new HashMap<String, Boolean>();
                this.recursivelyUpdateMemberships((String)parentGroupId, subgroupIdsByGroupId, memItemByGroupId, (String)parentGroupId, (Map<String, Boolean>)visitedGroupIds);
            });
        }
        memItemByGroupId.values().forEach(membershipHandler::handleMembership);
    }

    private void recursivelyUpdateMemberships(String groupId, Map<String, List<String>> subgroupIdsByGroupId, Map<String, MembershipItem> memItemByGroupId, String parentId, Map<String, Boolean> visitedGroupIds) {
        visitedGroupIds.put(groupId, true);
        if (subgroupIdsByGroupId.get(groupId) != null) {
            subgroupIdsByGroupId.get(groupId).forEach(subgroupId -> {
                if (!visitedGroupIds.containsKey(subgroupId)) {
                    this.recursivelyUpdateMemberships((String)subgroupId, subgroupIdsByGroupId, memItemByGroupId, groupId, visitedGroupIds);
                }
            });
        }
        if (memItemByGroupId.get(groupId) != null && memItemByGroupId.get(parentId) != null) {
            this.transferMembers(memItemByGroupId.get(groupId), memItemByGroupId.get(parentId));
        } else if (memItemByGroupId.get(groupId) == null) {
            this.log.warn("Group with ID {}'s MembershipItem object is null. This is commonly caused by having nested groups where the parent group specified in user/group filtering, but the subgroups are not.", (Object)groupId);
        } else {
            this.log.warn("Parent with ID {}'s MembershipItem object is null. Please contact Kantega SSO Enterprise support for help with this error.", (Object)groupId);
        }
    }

    private void transferMembers(MembershipItem from, MembershipItem to) {
        if (from.getName().equals(to.getName())) {
            return;
        }
        HashMap toUserMap = new HashMap();
        to.getUserCollection().getUsers().forEach(user -> toUserMap.put(user, true));
        from.getUserCollection().getUsers().forEach(user -> {
            if (!toUserMap.containsKey(user)) {
                to.getUserCollection().getUsers().add((UserMember)user);
            }
        });
    }

    private UserItem toUserItem(JSONObject jsonUser) {
        String userName = this.getUsername(jsonUser);
        if (userName != null) {
            String userPrincipalName = jsonUser.isNull("userPrincipalName") ? null : jsonUser.getString("userPrincipalName");
            String mail = jsonUser.isNull("mail") ? null : jsonUser.getString("mail");
            UserItem user = new UserItem();
            user.setFirstName(jsonUser.getString("givenName"));
            user.setLastName(jsonUser.getString("surname"));
            user.setDisplayName(jsonUser.getString("displayName"));
            user.setUserType(UserItem.UserType.fromAzure(jsonUser.getString("userType")));
            user.setEmail(mail != null ? mail : userPrincipalName);
            user.setActive(jsonUser.getBoolean("accountEnabled"));
            user.setKey(jsonUser.getString("id"));
            user.setName(userName);
            user.setFallbackName("userPrincipalName");
            this.log.debug("Sync user from AzureAD key: '" + user.getKey() + "', username: '" + user.getName() + "' email: '" + user.getEmail() + "', displayName: '" + user.getDisplayName() + "', firstName: '" + user.getFirstName() + "', lastName: '" + user.getLastName() + "', isActive: '" + user.isActive() + "', userType: " + (Object)((Object)user.getUserType()) + "'");
            return user;
        }
        return null;
    }

    String getUsername(JSONObject jsonUser) {
        if (!jsonUser.isNull("onPremisesSamAccountName") && (this.isUseSAMAccountName || this.usernameSelectionAttribute.equals((Object)UsernameSelectionAttribute.SAM_ACCOUNT_NAME))) {
            return jsonUser.getString("onPremisesSamAccountName");
        }
        if (!jsonUser.isNull("mail") && this.usernameSelectionAttribute.equals((Object)UsernameSelectionAttribute.MAIL)) {
            return jsonUser.getString("mail");
        }
        if (!jsonUser.isNull("userType") && UserItem.UserType.fromAzure(jsonUser.getString("userType")) == UserItem.UserType.GUEST && !jsonUser.isNull("mail")) {
            return jsonUser.getString("mail");
        }
        if (!jsonUser.isNull("userPrincipalName")) {
            return jsonUser.getString("userPrincipalName");
        }
        if (!jsonUser.isNull("mail")) {
            return jsonUser.getString("mail");
        }
        return null;
    }

    private ConnectorURIBuilder requestUriBuilder(String path) {
        ConnectorURIBuilder builder = ConnectorURIBuilder.builder(this.adminBaseUrl + path);
        if (this.top > 0 && !path.endsWith("$batch")) {
            builder.queryParam("$top", String.valueOf(this.top));
        }
        return builder;
    }

    private void throwConnectorException(int status, String message, JSONObject responseItem) {
        throw new ConnectorApiException(status, message, responseItem);
    }

    public String getTenantId() {
        return this.tenantId;
    }
}

