/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.diagnostics;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.LoginAttempt;
import org.kantega.atlaskerb.diagnostics.DiagnosticsLog;
import org.simplericity.serberuhs.DecodedKerberosToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class FailureListener {
    private final Logger log = LoggerFactory.getLogger(FailureListener.class);
    private static final int numFailures = 200;
    private final ArrayDeque<LoginAttempt> failures = new ArrayDeque(200);
    private final KerbConfManager kerbConfManager;
    private final DiagnosticsLog diagnosticsLog;

    @Inject
    public FailureListener(KerbConfManager kerbConfManager, DiagnosticsLog diagnosticsLog) {
        this.kerbConfManager = kerbConfManager;
        this.diagnosticsLog = diagnosticsLog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LoginAttempt> failures() {
        ArrayDeque<LoginAttempt> arrayDeque = this.failures;
        synchronized (arrayDeque) {
            return new ArrayList<LoginAttempt>(this.failures);
        }
    }

    public void failed(LoginAttempt.Builder loginAttempt, String requestUri) {
        this.failed(loginAttempt.build(), requestUri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void failed(LoginAttempt loginAttempt, String requestUri) {
        this.log.debug("Registering failed LoginAttempt, reason='{}'", (Object)loginAttempt.getReason());
        if (this.kerbConfManager.isClientFailureCollectionEnabled()) {
            String exceptionMessage = null;
            DecodedKerberosToken decodedKerberosToken = null;
            try {
                decodedKerberosToken = this.kerbConfManager.decodeKerberosToken(loginAttempt.getToken());
            }
            catch (Exception e) {
                exceptionMessage = e.getMessage();
                this.log.debug("Unable to decode Kerberos token during failure analysis", (Throwable)e);
            }
            String reason = String.format("Unable to parse KerberosTicket: %s", exceptionMessage);
            if (decodedKerberosToken != null) {
                reason = String.format("KerberosTicket: %s/%s@%s, EncType: %s", decodedKerberosToken.getService(), decodedKerberosToken.getHost(), decodedKerberosToken.getRealm(), decodedKerberosToken.getEncType());
            }
            reason = reason + String.format(", RequestUri: %s, RemoteIP: %s, Reason: %s, Exception: %s", requestUri, loginAttempt.getRemoteIp(), loginAttempt.getReason(), loginAttempt.getException());
            this.diagnosticsLog.loginFailed("Kerberos", reason, loginAttempt.getTimestamp());
            ArrayDeque<LoginAttempt> arrayDeque = this.failures;
            synchronized (arrayDeque) {
                this.failures.addFirst(loginAttempt);
                while (this.failures.size() > 200) {
                    this.failures.removeLast();
                }
            }
        }
    }
}

