/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.connector.model.crowdapi;

import com.atlassian.crowd.model.user.User;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class UserItem {
    private String name;
    private String firstName;
    private UserType userType;
    private String key;
    private String lastName;
    private String displayName;
    private String email;
    private boolean active;
    private String fallbackName;

    public static UserItem clone(UserItem in) {
        UserItem out = new UserItem();
        out.name = in.name;
        out.firstName = in.firstName;
        out.userType = in.userType;
        out.key = in.key;
        out.lastName = in.lastName;
        out.displayName = in.displayName;
        out.email = in.email;
        out.active = in.active;
        out.fallbackName = in.fallbackName;
        return out;
    }

    public static UserItem cloneFromCrowdUser(User in) {
        UserItem out = new UserItem();
        out.name = in.getName();
        out.firstName = in.getFirstName();
        out.key = in.getExternalId();
        out.lastName = in.getLastName();
        out.displayName = in.getDisplayName();
        out.email = in.getEmailAddress();
        out.active = in.isActive();
        return out;
    }

    public String getName() {
        return this.name;
    }

    public String getFallbackName() {
        return this.fallbackName;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setFallbackName(String fallBackName) {
        this.fallbackName = fallBackName;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getEmail() {
        return this.email;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public UserType getUserType() {
        return this.userType;
    }

    public void setUserType(UserType userType) {
        this.userType = userType;
    }

    public String toString() {
        return "UserItem{name='" + this.name + '\'' + ", firstName='" + this.firstName + '\'' + ", userType=" + (Object)((Object)this.userType) + ", key='" + this.key + '\'' + ", lastName='" + this.lastName + '\'' + ", displayName='" + this.displayName + '\'' + ", email='" + this.email + '\'' + ", active=" + this.active + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserItem userItem = (UserItem)o;
        return this.name.equals(userItem.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public static enum UserType {
        MEMBER,
        GUEST,
        OTHER;


        public static UserType fromAzure(String userType) {
            if (StringUtils.equalsIgnoreCase((CharSequence)"member", (CharSequence)userType)) {
                return MEMBER;
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)"guest", (CharSequence)userType)) {
                return GUEST;
            }
            return OTHER;
        }
    }
}

