/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb;

import com.atlassian.templaterenderer.TemplateRenderer;
import com.kantegasso.servlet.http.HttpServletRequestFacade;
import com.kantegasso.servlet.http.HttpServletResponseFacade;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;

public class UsageCountersAction
extends RequireAdminServlet {
    private final TemplateRenderer renderer;
    private final KerbConfManager kerbConfManager;

    @Inject
    public UsageCountersAction(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
        this.renderer = bucket.getTemplateRenderer();
        this.kerbConfManager = bucket.getKerbConfManager();
    }

    protected void doGetKsso(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
        Map<String, Object> model = this.newModel(req);
        model.put("menuItem", "counters");
        model.put("topMenu", "dashboard");
        model.put("stats", this.kerbConfManager.getStats());
        model.put("applicationProperties", this.kerbConfManager.getApplicationProperties());
        model.put("manualLoginLogEnabled", this.kerbConfManager.isManualLoginLogEnabled());
        model.put("isKeytabConfigured", this.kerbConfManager.isKeytabConfigured());
        resp.setContentType("text/html");
        this.renderer.render("templates/atlaskerb/stats.vm", model, (Writer)resp.getWriter());
    }

    @Override
    protected void doPostKsso(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
        boolean manualLoginLog = StringUtils.equalsIgnoreCase((CharSequence)"on", (CharSequence)req.getParameter("manualLoginLog"));
        this.kerbConfManager.setManualLoginLogEnabled(manualLoginLog);
        resp.sendRedirect("counters");
    }
}

