/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.kantegasso.servlet.http.HttpServletRequestFacade;
import com.kantegasso.servlet.http.HttpServletResponseFacade;
import io.vavr.control.Option;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.Keytab;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.UserMappingUtils;
import org.kantega.atlaskerb.cache.KerberosUserLookupFromFileCache;
import org.kantega.atlaskerb.userlookup.CheckTransformationHelper;
import org.kantega.atlaskerb.userlookup.UserLookupService;
import org.kantega.atlaskerb.userlookup.UserLookupTransform;
import org.kantega.atlaskerb.userlookup.UsernameTransformAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigureUserMappingAction
extends RequireAdminServlet {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final KerbConfManager kerbConfManager;
    private final TemplateRenderer renderer;
    private final UserManager userManager;
    private final ApplicationProperties applicationProperties;
    private final UserLookupService userLookupService;
    private String testUsername;
    private KerberosUserLookupFromFileCache kerberosUserLookupFromFileCache;

    @Inject
    public ConfigureUserMappingAction(RequireAdminServletDependencyBucket bucket, KerberosUserLookupFromFileCache kerberosUserLookupFromFileCache) {
        super(bucket);
        this.kerbConfManager = bucket.getKerbConfManager();
        this.renderer = bucket.getTemplateRenderer();
        this.userManager = bucket.getUserManager();
        this.applicationProperties = bucket.getApplicationProperties();
        this.userLookupService = bucket.getUserLookupService();
        this.kerberosUserLookupFromFileCache = kerberosUserLookupFromFileCache;
    }

    private void generateLookupDirectories(Map<String, Object> model, String kerberosPrincipal) {
        LinkedHashMap<String, Set> lookupMap = new LinkedHashMap<String, Set>();
        model.put("lookupMap", lookupMap);
        List<Directory> activeUserDirectories = this.userLookupService.getActiveUserDirectories();
        boolean onlyRegexTransformationLookup = model.get("onlyRegexTransformationLookup") != null && (Boolean)model.get("onlyRegexTransformationLookup") != false;
        for (Directory directory : activeUserDirectories) {
            Map<UsernameTransformAction, String> lookupNames = this.userLookupService.findLookupNamesInDir(kerberosPrincipal, directory, this.kerbConfManager.getKerberosMultiRegex(), this.kerbConfManager.getAdditionalUserSuffix());
            Collection<UsernameTransformAction> sortedLookupNames = this.userLookupService.sortAndFilterUTAs(lookupNames, onlyRegexTransformationLookup);
            lookupMap.put(directory.getName(), sortedLookupNames.stream().map(lookupNames::get).collect(Collectors.toCollection(LinkedHashSet::new)));
        }
    }

    private void renderView(HttpServletResponseFacade resp, String loggedInKerberosPrincipal, Map<String, Object> model) throws IOException {
        UserLookupTransform userLookupTransform;
        model.put("displayName", this.applicationProperties.getDisplayName());
        model.put("userNameAttributeLookupEnabled", this.kerbConfManager.isUserNameAttributeLookupEnabled());
        model.put("kerberosPrincipal", this.testUsername);
        model.put("usernameIsLoggedInUser", StringUtils.equals((CharSequence)this.testUsername, (CharSequence)loggedInKerberosPrincipal));
        if (this.testUsername == null || !this.testUsername.contains("@")) {
            model.put("invalidSpn", true);
        } else {
            this.generateLookupDirectories(model, this.testUsername);
        }
        UserLookupTransform userLookupTransform2 = userLookupTransform = model.get("userLookupTransform") != null ? UserLookupTransform.valueOf((String)model.get("userLookupTransform")) : null;
        if (userLookupTransform == null) {
            userLookupTransform = this.kerbConfManager.isRegexLookupEnabled() ? UserLookupTransform.REGEX : (StringUtils.isNotBlank((CharSequence)this.kerbConfManager.getAdditionalUserSuffix()) ? UserLookupTransform.SUFFIX : (this.kerbConfManager.isLookupUsernameFromMappingFile() ? UserLookupTransform.LOOKUP_MAPPING : UserLookupTransform.NONE));
            model.put("userLookupTransform", (Object)userLookupTransform);
        }
        model.put("filenameKerberosUserLookup", this.hostApp.getHomeDirectory() + File.separator + "kerberosUsernameLookupFromFile.json");
        resp.setContentType("text/html");
        this.renderer.render("templates/atlaskerb/usermapping.vm", model, (Writer)resp.getWriter());
    }

    private void addRegexToModel(Map<String, Object> model, String multiRegexJson, boolean onlyRegexTransformationLookup) {
        model.put("onlyRegexTransformationLookup", onlyRegexTransformationLookup);
        model.put("additionalUserSuffix", null);
        try {
            if (StringUtils.isNotBlank((CharSequence)multiRegexJson)) {
                model.put("regexTransformationsWithHtml", UserMappingUtils.getRegexTransformations(CheckTransformationHelper.getRegexTuplesFromJsonArray(new JSONArray(multiRegexJson))));
            } else {
                model.put("regexTransformationsWithHtml", "[]");
            }
        }
        catch (Exception e) {
            this.log.error("Error parsing regular expression", (Throwable)e);
            model.put("regexTransformationsWithHtml", "[]");
        }
    }

    private void updateKerbconfManager(String multiRegexJson, UserLookupTransform userLookupTransform, String additionalUserSuffix, String usernameAttributeLookup, boolean onlyRegexTransformationLookup) {
        if (userLookupTransform.equals((Object)UserLookupTransform.REGEX) && multiRegexJson != null) {
            multiRegexJson = StringUtils.trimToNull((String)multiRegexJson);
            this.kerbConfManager.setKerberosMultiRegex(multiRegexJson);
            this.kerbConfManager.setAdditionalUserSuffix(null);
            this.kerbConfManager.setOnlyRegexTransformationLookup(onlyRegexTransformationLookup);
            this.kerbConfManager.setLookupUsernameFromMappingFile(false);
        } else if (userLookupTransform.equals((Object)UserLookupTransform.NONE)) {
            this.kerbConfManager.setAdditionalUserSuffix(null);
            this.kerbConfManager.setOnlyRegexTransformationLookup(false);
            this.kerbConfManager.setLookupUsernameFromMappingFile(false);
        } else if (userLookupTransform.equals((Object)UserLookupTransform.LOOKUP_MAPPING)) {
            this.kerbConfManager.setLookupUsernameFromMappingFile(true);
            this.kerberosUserLookupFromFileCache.tryReadCacheFile(this.hostApp.getHomeDirectory());
        } else if (additionalUserSuffix != null) {
            additionalUserSuffix = StringUtils.trimToNull((String)additionalUserSuffix);
            this.kerbConfManager.setAdditionalUserSuffix(additionalUserSuffix);
            this.kerbConfManager.setOnlyRegexTransformationLookup(false);
            this.kerbConfManager.setLookupUsernameFromMappingFile(false);
        }
        if (usernameAttributeLookup != null) {
            this.kerbConfManager.setUserNameAttributeLookupEnabled(!this.kerbConfManager.isUserNameAttributeLookupEnabled());
        }
        this.kerbConfManager.setRegexLookupEnabled(userLookupTransform.equals((Object)UserLookupTransform.REGEX));
    }

    private String generateKerberosPrincipal(String remoteUsername) {
        return (String)Option.of((Object)remoteUsername).map(username -> {
            Keytab keytab = new Keytab(this.kerbConfManager.getKeytabInfos());
            String principalSuffix = "@" + keytab.realms().iterator().next();
            if (username.contains("@")) {
                return username.substring(0, username.indexOf("@")) + principalSuffix;
            }
            return username + principalSuffix;
        }).getOrNull();
    }

    protected void doGetKsso(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
        String loggedInUsername = (String)Option.of((Object)this.userManager.getRemoteUser((HttpServletRequest)req)).map(UserProfile::getUsername).getOrNull();
        String loggedInKerberosPrincipal = this.generateKerberosPrincipal(loggedInUsername);
        if (this.testUsername == null) {
            this.testUsername = loggedInKerberosPrincipal;
        }
        Map<String, Object> model = this.newModel(req);
        this.addRegexToModel(model, this.kerbConfManager.getKerberosMultiRegex(), this.kerbConfManager.isOnlyRegexTransformationLookup());
        model.put("additionalUserSuffix", this.kerbConfManager.getAdditionalUserSuffix());
        this.renderView(resp, loggedInKerberosPrincipal, model);
    }

    private void addAdditionalUserSuffixToModel(Map<String, Object> model, String additionalUserSuffix) {
        model.put("additionalUserSuffix", additionalUserSuffix);
        model.put("kerberosMultiRegex", null);
    }

    @Override
    protected void doPostKsso(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
        if (req.getParameter("checkTransformation") != null) {
            CheckTransformationHelper.checkTransformation(req, resp);
            return;
        }
        String multiRegexJson = CheckTransformationHelper.getRegexTuplesAsJsonArray(CheckTransformationHelper.processRegexTuples(req)).toString();
        String loggedInUsername = (String)Option.of((Object)this.userManager.getRemoteUser((HttpServletRequest)req)).map(UserProfile::getUsername).getOrNull();
        String loggedInKerberosPrincipal = this.generateKerberosPrincipal(loggedInUsername);
        Map<String, Object> model = this.newModel(req);
        String additionalUserSuffix = req.getParameter("additionalUserSuffix");
        UserLookupTransform userLookupTransform = UserLookupTransform.valueOf(req.getParameter("userLookupTransform"));
        model.put("userLookupTransform", userLookupTransform.name());
        String userNameAttributeLookup = req.getParameter("userNameAttributeLookup");
        boolean onlyRegexTransformationLookup = "on".equals(req.getParameter("onlyRegexTransformationLookup"));
        if (req.getParameter("testUserNameAttributeLookup") != null || req.getParameter("runTestLoggedInUser") != null) {
            model.put("testing", true);
            String kerberosPrincipal = req.getParameter("kerberosPrincipal").trim();
            if (req.getParameter("runTestLoggedInUser") != null) {
                kerberosPrincipal = loggedInKerberosPrincipal;
            }
            this.testUsername = kerberosPrincipal;
            model.put("regexTransformationsWithHtml", "[]");
            if (userLookupTransform.equals((Object)UserLookupTransform.REGEX) && multiRegexJson != null) {
                multiRegexJson = StringUtils.trimToNull((String)multiRegexJson);
                this.addRegexToModel(model, multiRegexJson, onlyRegexTransformationLookup);
            } else if (StringUtils.isNotBlank((CharSequence)additionalUserSuffix)) {
                additionalUserSuffix = StringUtils.trimToNull((String)additionalUserSuffix);
                this.addAdditionalUserSuffixToModel(model, additionalUserSuffix);
            }
            this.renderView(resp, loggedInKerberosPrincipal, model);
            return;
        }
        try {
            this.updateKerbconfManager(multiRegexJson, userLookupTransform, additionalUserSuffix, userNameAttributeLookup, onlyRegexTransformationLookup);
        }
        catch (Exception e) {
            this.log.error("Error updating configuration", (Throwable)e);
            model.put("errorMessage", "Error updating configuration: " + e.getMessage() + ". Check logs for details.");
        }
        this.addRegexToModel(model, this.kerbConfManager.getKerberosMultiRegex(), this.kerbConfManager.isOnlyRegexTransformationLookup());
        model.put("additionalUserSuffix", this.kerbConfManager.getAdditionalUserSuffix());
        model.put("regexEnabled", this.kerbConfManager.isRegexLookupEnabled());
        this.renderView(resp, loggedInKerberosPrincipal, model);
    }
}

