/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.connector.admin;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.kantegasso.servlet.http.HttpServletRequestFacade;
import com.kantegasso.servlet.http.HttpServletResponseFacade;
import jakarta.inject.Inject;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.json.JSONArray;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.UserMappingUtils;
import org.kantega.atlaskerb.connector.ConnectorConfManager;
import org.kantega.atlaskerb.connector.azure.AzureDirectory;
import org.kantega.atlaskerb.connector.model.Directory;
import org.kantega.atlaskerb.connector.model.ObjectTypeFilter;
import org.kantega.atlaskerb.connector.model.SecurityGroupFilter;
import org.kantega.atlaskerb.connector.model.UsernameSelectionAttribute;
import org.kantega.atlaskerb.connector.model.filters.ConnectorFilter;
import org.kantega.atlaskerb.connector.model.filters.GroupFilter;
import org.kantega.atlaskerb.connector.model.filters.UserMembershipFilter;
import org.kantega.atlaskerb.connector.model.filters.UserTypeSelectionFilter;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.userlookup.CheckTransformationHelper;
import org.kantega.atlaskerb.userlookup.UserLookupTransform;
import org.kantega.atlaskerb.userlookup.regextransformation.RegexTransformationResult;

public class UserFilteringAction
extends RequireAdminServlet {
    private final ApplicationProperties applicationProperties;
    private final ConnectorConfManager connectorConfManager;
    private final TemplateRenderer renderer;
    private final HostApp hostApp;

    @Inject
    public UserFilteringAction(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
        this.applicationProperties = bucket.getApplicationProperties();
        this.connectorConfManager = bucket.getConnectorConfManager();
        this.renderer = bucket.getTemplateRenderer();
        this.hostApp = bucket.getHostApp();
    }

    protected void doGetKsso(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
        Map<String, Object> model = this.newModel(req);
        String id = req.getParameter("id");
        Directory dir = this.connectorConfManager.getDirectory(id);
        if (dir == null) {
            resp.sendError(404);
            return;
        }
        model.put("platformSupportsAvatars", this.hostApp.supportsAvatars(this.applicationProperties));
        model.put("currentConnector", dir);
        model.put("topMenu", "connectors");
        model.put("menuItem", "user-filtering");
        model.put("connectorType", this.connectorConfManager.getConnectorTypes().get(dir.getKind()));
        model.put("kind", dir.getKind());
        model.put("connectorId", id);
        model.put("groupSelectionMode", (Object)dir.getUserMembershipFilter().getMode());
        if (dir.getUserMembershipFilter().getMode() == ConnectorFilter.SelectionMode.INCLUDE_SUBSET) {
            model.put("groupSelectionIncludeKeep", StringUtils.join(dir.getUserMembershipFilter().getIncludedGroups(), (String)","));
        } else if (dir.getUserMembershipFilter().getMode() == ConnectorFilter.SelectionMode.EXCLUDE_SUBSET) {
            model.put("groupSelectionExclude", StringUtils.join(dir.getUserMembershipFilter().getExcludedGroups(), (String)","));
        }
        if (dir.getGroupFilter() != null) {
            model.put("membershipSelectionMode", (Object)dir.getGroupFilter().getMode());
            if (dir.getGroupFilter().getMode() == ConnectorFilter.SelectionMode.INCLUDE_SUBSET) {
                model.put("membershipSelectionInclude", StringUtils.join(dir.getGroupFilter().getIncludedGroups(), (String)","));
            } else if (dir.getGroupFilter().getMode() == ConnectorFilter.SelectionMode.EXCLUDE_SUBSET) {
                model.put("membershipSelectionExclude", StringUtils.join(dir.getGroupFilter().getExcludedGroups(), (String)","));
            }
        } else {
            model.put("membershipSelectionMode", "ALL");
            model.put("membershipSelectionInclude", "");
            model.put("membershipSelectionExclude", "");
        }
        model.put("userTypeSelectionMode", dir.getUserTypeSelectionFilter().getMode().name());
        model.put("usernameTransformation", dir.getUsernameTransformation().name());
        if (dir instanceof AzureDirectory) {
            AzureDirectory aDir = (AzureDirectory)dir;
            model.put("useSAMAccountName", aDir.isUseSAMAccountName());
            if (aDir.isUseSAMAccountName()) {
                model.put("usernameSelectionAttribute", (Object)UsernameSelectionAttribute.SAM_ACCOUNT_NAME);
            } else {
                model.put("usernameSelectionAttribute", dir.getUsernameSelectionAttribute().name());
            }
        } else {
            model.put("usernameSelectionAttribute", dir.getUsernameSelectionAttribute().name());
        }
        model.put("securityGroupFilter", dir.getSecurityGroupFilter() == null ? SecurityGroupFilter.SECURITY_GROUPS_ONLY : dir.getSecurityGroupFilter().name());
        model.put("objectTypeFilter", dir.getObjectTypeFilter().name());
        model.put("displayName", this.applicationProperties.getDisplayName());
        JSONArray regexTransformations = new JSONArray();
        List<Pair<String, String>> regexTuples = dir.getUserTransformationRegexes();
        List<RegexTransformationResult> validations = UserMappingUtils.regexTransformations("john.doe@example.com", regexTuples);
        validations.forEach(result -> regexTransformations.put((Object)result.toJson()));
        model.put("regexTransformationsWithHtml", regexTransformations.toString());
        model.put("userLookupTransform", dir.getUsernameTransformation().name());
        resp.setContentType("text/html");
        this.renderer.render("templates/atlaskerb/connector/user-filtering.vm", model, (Writer)resp.getWriter());
    }

    @Override
    protected boolean expectsMultipart() {
        return true;
    }

    @Override
    protected void doPostKsso(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
        if (req.getParameter("checkTransformation") != null) {
            CheckTransformationHelper.checkTransformation(req, resp);
            return;
        }
        String connectorId = req.getParameter("connectorId");
        String objectTypeFilterStr = req.getParameter("objectTypeFilter");
        String groupSelectionModeStr = req.getParameter("groups");
        String groupSelectionIncludeStr = req.getParameter("includedGroupsKeep");
        String groupSelectionExcludeStr = req.getParameter("excludedGroups");
        if (groupSelectionModeStr == null) {
            groupSelectionModeStr = ConnectorFilter.SelectionMode.ALL.name();
        }
        if (groupSelectionIncludeStr == null) {
            groupSelectionIncludeStr = "";
        }
        if (groupSelectionExcludeStr == null) {
            groupSelectionExcludeStr = "";
        }
        String userTypeFilterStr = req.getParameter("usertype");
        UserLookupTransform userLookupTransform = UserLookupTransform.valueOf(req.getParameter("userLookupTransform"));
        ArrayList<Pair<String, String>> regexTuples = new ArrayList();
        regexTuples = CheckTransformationHelper.processRegexTuples(req).filter(tuple -> StringUtils.isNotBlank((CharSequence)((CharSequence)tuple._1)) && StringUtils.isNotBlank((CharSequence)((CharSequence)tuple._2))).map(tuple -> Pair.of((Object)((String)tuple._1), (Object)((String)tuple._2))).asJava();
        SecurityGroupFilter securityGroupFilter = null;
        if (req.getParameter("isAzure") != null) {
            securityGroupFilter = req.getParameter("securityGroupFilter") != null ? SecurityGroupFilter.SECURITY_GROUPS_ONLY : SecurityGroupFilter.ALL_GROUPS;
        }
        String groupMembershipSelectionModeStr = req.getParameter("memberships");
        String groupMembershipSelectionIncludeStr = req.getParameter("includedMembershipInclude");
        String groupMembershipSelectionExcludeStr = req.getParameter("excludedMemberships");
        if (groupMembershipSelectionModeStr == null) {
            groupMembershipSelectionModeStr = ConnectorFilter.SelectionMode.ALL.name();
        }
        if (groupMembershipSelectionIncludeStr == null) {
            groupMembershipSelectionIncludeStr = "";
        }
        if (groupMembershipSelectionExcludeStr == null) {
            groupMembershipSelectionExcludeStr = "";
        }
        if (objectTypeFilterStr != null && groupSelectionModeStr != null) {
            ObjectTypeFilter objectTypeFilter = ObjectTypeFilter.valueOf(objectTypeFilterStr);
            ConnectorFilter.SelectionMode groupSelectionMode = ConnectorFilter.SelectionMode.valueOf(groupSelectionModeStr);
            Set includedGroups = Arrays.stream(StringUtils.split((String)groupSelectionIncludeStr, (String)",")).map(StringUtils::trim).collect(Collectors.toCollection(LinkedHashSet::new));
            Set excludedGroups = Arrays.stream(StringUtils.split((String)groupSelectionExcludeStr, (String)",")).map(StringUtils::trim).collect(Collectors.toCollection(LinkedHashSet::new));
            ConnectorFilter.SelectionMode groupMembershipSelectionMode = ConnectorFilter.SelectionMode.valueOf(groupMembershipSelectionModeStr);
            Set includedMembershipGroups = Arrays.stream(StringUtils.split((String)groupMembershipSelectionIncludeStr, (String)",")).map(StringUtils::trim).collect(Collectors.toCollection(LinkedHashSet::new));
            Set excludedMembershipGroups = Arrays.stream(StringUtils.split((String)groupMembershipSelectionExcludeStr, (String)",")).map(StringUtils::trim).collect(Collectors.toCollection(LinkedHashSet::new));
            if (StringUtils.isNotBlank((CharSequence)connectorId)) {
                Directory dir = this.connectorConfManager.getDirectory(connectorId);
                dir.setObjectTypeFilter(objectTypeFilter);
                dir.setUsernameTransformation(userLookupTransform);
                dir.setSecurityGroupFilter(securityGroupFilter);
                dir.setUserMembershipFilter(new UserMembershipFilter(groupSelectionMode, includedGroups, excludedGroups));
                dir.setGroupFilter(new GroupFilter(groupMembershipSelectionMode, includedMembershipGroups, excludedMembershipGroups));
                dir.setUserTypeFilter(new UserTypeSelectionFilter(UserTypeSelectionFilter.SelectionMode.valueOf(userTypeFilterStr)));
                dir.setUserTransformationRegexes(regexTuples);
                if (dir instanceof AzureDirectory) {
                    AzureDirectory aDir = (AzureDirectory)dir;
                    aDir.setUseSAMAccountName("on".equals(req.getParameter("useSAMAccountName")));
                    try {
                        aDir.setUsernameSelectionAttribute(UsernameSelectionAttribute.valueOf(req.getParameter("usernameSelectionAttribute")));
                    }
                    catch (IllegalArgumentException ia) {
                        try {
                            if (Boolean.parseBoolean(req.getParameter("useSAMAccountName"))) {
                                aDir.setUsernameSelectionAttribute(UsernameSelectionAttribute.SAM_ACCOUNT_NAME);
                            } else {
                                aDir.setUsernameSelectionAttribute(UsernameSelectionAttribute.USER_PRINCIPAL_NAME);
                            }
                        }
                        catch (Exception e) {
                            aDir.setUsernameSelectionAttribute(UsernameSelectionAttribute.USER_PRINCIPAL_NAME);
                            aDir.setUseSAMAccountName(false);
                        }
                    }
                    this.connectorConfManager.saveOrEdit(aDir);
                } else {
                    try {
                        dir.setUsernameSelectionAttribute(UsernameSelectionAttribute.valueOf(req.getParameter("usernameSelectionAttribute")));
                    }
                    catch (IllegalArgumentException e) {
                        dir.setUsernameSelectionAttribute(UsernameSelectionAttribute.USER_PRINCIPAL_NAME);
                    }
                    this.connectorConfManager.saveOrEdit(dir);
                }
                resp.sendRedirect("user-filtering?id=" + dir.getId());
            }
        }
    }
}

