/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.utils;

import com.kantegasso.servlet.http.HttpServletRequestFacade;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.intercept.model.AuthMethod;
import org.kantega.atlaskerb.userlookup.UserLookupService;

public class TraditionalLoginUtils {
    public static boolean shouldTraditionalLoginBePreventedForThisPage(KerbConfManager kerbConfManager, UserLookupService userLookupService, HostApp hostApp, HttpServletRequestFacade req) {
        if (req != null && hostApp.isJsmLoginPage(req)) {
            return TraditionalLoginUtils.isTraditionalLoginPreventedForAllUsers(kerbConfManager, userLookupService);
        }
        return TraditionalLoginUtils.isTraditionalLoginPreventedForAllLicensedUsers(kerbConfManager, userLookupService);
    }

    public static boolean isTraditionalLoginPreventedForAllUsers(KerbConfManager kerbConfManager, UserLookupService userLookupService) {
        if (kerbConfManager.isJsmInstalled()) {
            return TraditionalLoginUtils.isTraditionalLoginPreventedForAllUnlicensedUsers(kerbConfManager, userLookupService) && TraditionalLoginUtils.isTraditionalLoginPreventedForAllLicensedUsers(kerbConfManager, userLookupService);
        }
        return TraditionalLoginUtils.isTraditionalLoginPreventedForAllLicensedUsers(kerbConfManager, userLookupService);
    }

    public static boolean isTraditionalLoginPreventedForAllLicensedUsers(KerbConfManager kerbConfManager, UserLookupService userLookupService) {
        return kerbConfManager.isTraditionalLoginPrevented() && userLookupService.getCachedDirectoriesAllowingTraditionalLogin().isEmpty() && kerbConfManager.getAllowTraditionalLoginGroups().isEmpty() && kerbConfManager.getDisallowTraditionalLoginGroups().isEmpty();
    }

    public static boolean isTraditionalLoginPreventedForAllUnlicensedUsers(KerbConfManager kerbConfManager, UserLookupService userLookupService) {
        return kerbConfManager.isTraditionalLoginJsmPrevented() && userLookupService.getCachedDirectoriesAllowingTraditionalLogin().isEmpty() && kerbConfManager.getAllowTraditionalLoginGroups().isEmpty() && kerbConfManager.getDisallowTraditionalLoginGroups().isEmpty();
    }

    public static boolean isTraditionalLoginAllowedForAllUsers(KerbConfManager kerbConfManager) {
        if (kerbConfManager.isJsmInstalled()) {
            return !kerbConfManager.isTraditionalLoginJsmPrevented() && !kerbConfManager.isTraditionalLoginPrevented();
        }
        return !kerbConfManager.isTraditionalLoginPrevented();
    }

    public static boolean isUserAllowedToUseTraditionalLogin(KerbConfManager kerbConfManager, UserLookupService userLookupService, String username, HostApp hostApp) {
        boolean isLicensedUser = hostApp.doesUserHaveApplicationLicense(username);
        if (isLicensedUser) {
            if (kerbConfManager.isTraditionalLoginPrevented()) {
                if (TraditionalLoginUtils.isTraditionalLoginPreventedForAllLicensedUsers(kerbConfManager, userLookupService)) {
                    return false;
                }
                return userLookupService.isUserInAllowedDirectoryOrGroup(userLookupService.getCachedDirectoriesAllowingTraditionalLogin(), hostApp, kerbConfManager.getAllowTraditionalLoginGroups(), kerbConfManager.getDisallowTraditionalLoginGroups(), username, AuthMethod.LOCAL_LOGIN);
            }
        } else if (kerbConfManager.isTraditionalLoginJsmPrevented()) {
            if (TraditionalLoginUtils.isTraditionalLoginPreventedForAllUnlicensedUsers(kerbConfManager, userLookupService)) {
                return false;
            }
            return userLookupService.isUserInAllowedDirectoryOrGroup(userLookupService.getCachedDirectoriesAllowingTraditionalLogin(), hostApp, kerbConfManager.getAllowTraditionalLoginGroups(), kerbConfManager.getDisallowTraditionalLoginGroups(), username, AuthMethod.LOCAL_LOGIN);
        }
        return true;
    }

    public static TraditionalLoginStatus evaluateIfUserShouldBeAllowedToLogin(KerbConfManager kerbConfManager, UserLookupService userLookupService, HostApp hostApp, String username) {
        if (TraditionalLoginUtils.isTraditionalLoginAllowedForAllUsers(kerbConfManager)) {
            return TraditionalLoginStatus.ALLOWED_FOR_EVERYONE;
        }
        if (TraditionalLoginUtils.isTraditionalLoginPreventedForAllUsers(kerbConfManager, userLookupService)) {
            return TraditionalLoginStatus.PREVENTED_FOR_EVERYONE;
        }
        if (TraditionalLoginUtils.isUserAllowedToUseTraditionalLogin(kerbConfManager, userLookupService, username, hostApp)) {
            return TraditionalLoginStatus.ALLOWED_FOR_USER;
        }
        return TraditionalLoginStatus.PREVENTED_FOR_USER;
    }

    public static enum TraditionalLoginStatus {
        ALLOWED_FOR_EVERYONE,
        ALLOWED_FOR_USER,
        PREVENTED_FOR_EVERYONE,
        PREVENTED_FOR_USER;

    }
}

