/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.utils;

import io.vavr.CheckedFunction0;
import io.vavr.CheckedFunction1;
import io.vavr.collection.CharSeq;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.io.Serializable;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPublicKeySpec;
import org.apache.commons.codec.binary.Base64;

public class CertUtil {
    public static Try<PrivateKey> parsePkcs8eFromPem(String pem) {
        String linebreak = "[\\n\\r]+";
        return Option.of((Object)pem).map(CharSeq::of).map(cs -> (CharSeq)cs.split("[\\n\\r]+").dropUntil(line -> line.matches("-----BEGIN( RSA)? PRIVATE KEY-----")).drop(1).dropRightUntil(line -> line.matches("-----END( RSA)? PRIVATE KEY-----")).dropRight(1).fold((Object)CharSeq.empty(), CharSeq::appendAll)).map(cs -> cs).map(CharSeq::mkString).toTry().mapTry(Base64::decodeBase64).mapTry((CheckedFunction1 & Serializable)encoded -> KeyFactory.getInstance("RSA").generatePrivate(new PKCS8EncodedKeySpec((byte[])encoded)));
    }

    public static Try<KeyPair> parseRsaKeyPairFromPem(String pem) {
        Try<PrivateKey> maybePrivateKey = CertUtil.parsePkcs8eFromPem(pem);
        Try maybePublicKey = maybePrivateKey.mapTry((CheckedFunction1 & Serializable)pk -> (RSAPrivateCrtKey)pk).mapTry((CheckedFunction1 & Serializable)rsaPk -> new RSAPublicKeySpec(rsaPk.getModulus(), rsaPk.getPublicExponent())).mapTry((CheckedFunction1 & Serializable)rsaPublicSpec -> KeyFactory.getInstance("RSA").generatePublic((KeySpec)rsaPublicSpec));
        return Try.of((CheckedFunction0 & Serializable)() -> new KeyPair((PublicKey)maybePublicKey.get(), (PrivateKey)maybePrivateKey.get()));
    }
}

