/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.rest.resource.api.snapshot;

import com.atlassian.plugin.PluginException;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.kantegasso.servlet.http.HttpServletRequestFacade;
import io.vavr.CheckedFunction1;
import io.vavr.control.Either;
import io.vavr.control.Option;
import jakarta.ws.rs.core.Response;
import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kantega.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.kantega.atlaskerb.backup.BackupInfo;
import org.kantega.atlaskerb.backup.BackupService;
import org.kantega.atlaskerb.config.ConfigNameSpaces;
import org.kantega.atlaskerb.rest.resource.api.snapshot.SnapshotRestoredResponseModel;
import org.kantega.atlaskerb.rest.util.ResponseUtils;
import org.kantega.atlaskerb.security.SanitizedLogStatement;
import org.kantega.atlaskerb.utils.ErrorUtils;
import org.kantega.atlaskerb.utils.JsonWrapper;
import org.kantega.atlaskerb.utils.ListParseUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestoreSnapshot {
    static Logger log = LoggerFactory.getLogger(RestoreSnapshot.class);

    static Response run(UserManager userManager, BackupService snapshotService, HttpServletRequestFacade request, String snapshotInput, boolean makeSnapshot, JsonWrapper jsonWrapper) {
        return RestoreSnapshot.run(userManager, snapshotService, request, snapshotInput, makeSnapshot, null, jsonWrapper);
    }

    static Response run(UserManager userManager, BackupService snapshotService, HttpServletRequestFacade request, String snapshotInput, boolean makeSnapshot, String body, JsonWrapper jsonWrapper) {
        return ResponseUtils.sysadminOnly(request, userManager).wrap((CheckedFunction1<UserProfile, Response>)(CheckedFunction1 & Serializable)_u -> {
            String snapshotFullName = snapshotInput + ".zip";
            JSONObject jsonObject = new JSONObject();
            BackupInfo snapshot = snapshotService.findBackup(snapshotFullName);
            jsonObject.put("snapshot", (Object)snapshot);
            log.info(String.format("Kantega SSO API restoring snapshot %s", jsonObject.toString(4)));
            Option<File> maybeSnapshotFile = snapshotService.getBackupFile(snapshotFullName);
            if (maybeSnapshotFile.isEmpty()) {
                log.error(String.format("Kantega SSO API restoring snapshot failed, file not found %s", snapshotFullName));
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            File snapshotFile = (File)maybeSnapshotFile.get();
            if (!snapshotFile.canRead()) {
                log.error(String.format("Kantega SSO API restoring snapshot failed, file not readable %s", snapshotFullName));
                throw new PluginException(String.format("Can't read snapshot file %s", snapshotFullName));
            }
            if (snapshot != null) {
                HashSet<ConfigNameSpaces.ConfigSubset> allConfigSubsets = new HashSet<ConfigNameSpaces.ConfigSubset>(Arrays.asList(ConfigNameSpaces.ConfigSubset.values()));
                if (body != null && !body.isEmpty()) {
                    try {
                        io.vavr.collection.HashSet configSubsets = io.vavr.collection.HashSet.ofAll(RestoreSnapshot.parseConfigSubsets(body));
                        if (configSubsets.isEmpty()) {
                            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Bad request. No config subsets found in json").build();
                        }
                        if (!configSubsets.forAll(Either::isRight)) {
                            String badSubsets = ListParseUtils.iterableToCommaSeparatedString((Iterable)configSubsets.filter(Either::isLeft).map(Either::getLeft));
                            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Bad request. Could not parse config subsets from json. Illegal values: " + badSubsets)).build();
                        }
                        snapshotService.restoreFromFile(snapshotFile, makeSnapshot, configSubsets.map(Either::get).toJavaSet());
                    }
                    catch (ErrorUtils.KssoException e) {
                        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
                    }
                    catch (Exception e) {
                        SanitizedLogStatement.of(body).andThenLog(b -> log.error("Unable to parse json: " + b));
                        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Bad request. Could not parse json: " + body)).build();
                    }
                }
                snapshotService.restoreFromFile(snapshotFile, makeSnapshot, allConfigSubsets);
            }
            log.info(String.format("Kantega SSO API successfully restored snapshot %s", snapshotFullName));
            try {
                return Response.ok((Object)jsonWrapper.buildJsonString(new SnapshotRestoredResponseModel(snapshotFile.getName()))).build();
            }
            catch (JsonProcessingException e) {
                log.error("KSSO: something went wrong processing json object ", (Throwable)e);
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
        });
    }

    static Set<Either<String, ConfigNameSpaces.ConfigSubset>> parseConfigSubsets(String body) {
        try {
            JSONObject json = new JSONObject(body);
            JSONArray jsonArray = (JSONArray)json.get("configSubsets");
            List<String> subsetStringList = jsonArray.toList().stream().map(String.class::cast).collect(Collectors.toList());
            return ConfigNameSpaces.ConfigSubset.fromStringList(subsetStringList);
        }
        catch (JSONException e) {
            SanitizedLogStatement.of(body).andThenLog(b -> log.error(ErrorUtils.createErrorMessage((String)"KSSO-8K40KGYWM2", (String)("Unable to parse json: " + b)), (Throwable)e));
            throw new ErrorUtils.KssoException("KSSO-8K40KGYWM2", "Unable to parse json: " + body, (Throwable)e);
        }
        catch (Exception e) {
            SanitizedLogStatement.of(body).andThenLog(b -> log.error("Something went wrong parsing config subsets to restore snapshot: " + b, (Throwable)e));
            throw new RuntimeException("Something went wrong parsing config subsets to restore snapshot: " + body, e);
        }
    }
}

