/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.kerberos.servlet;

import com.atlassian.plugin.util.ContextClassLoaderSwitchingUtil;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.kantegasso.servlet.http.HttpServletRequestFacade;
import com.kantegasso.servlet.http.HttpServletResponseFacade;
import io.vavr.control.Option;
import jakarta.inject.Inject;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.naming.AuthenticationException;
import javax.naming.CommunicationException;
import javax.naming.Context;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.DomainDirectory;
import org.kantega.atlaskerb.ExceptionTool;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.Keytab;
import org.kantega.atlaskerb.LdapPrincipalSearcher;
import org.kantega.atlaskerb.LdapTestResult;
import org.kantega.atlaskerb.LdapTestTool;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.kerberos.AtlDirectoryManager;
import org.kantega.atlaskerb.kerberos.servlet.SetupAction;
import org.kantega.atlaskerb.utils.HttpUrlUtils;
import org.simplericity.serberuhs.keytab.KeytabInfo;
import org.simplericity.serberuhs.keytab.KeytabParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestLdapAction
extends RequireAdminServlet {
    private static final Logger log = LoggerFactory.getLogger(TestLdapAction.class);
    private final LdapPrincipalSearcher ldapPrincipalSearcher;
    private final KerbConfManager kerbConfManager;
    private final TemplateRenderer renderer;
    private final ApplicationProperties applicationProperties;
    private final AtlDirectoryManager directoryManager;

    @Inject
    public TestLdapAction(RequireAdminServletDependencyBucket bucket, LdapPrincipalSearcher ldapPrincipalSearcher, AtlDirectoryManager directoryManager) {
        super(bucket);
        this.kerbConfManager = bucket.getKerbConfManager();
        this.renderer = bucket.getTemplateRenderer();
        this.applicationProperties = bucket.getApplicationProperties();
        this.ldapPrincipalSearcher = ldapPrincipalSearcher;
        this.directoryManager = directoryManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkLdapSrv(Map<String, Object> model, String domain) {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
        DirContext context = null;
        try {
            context = (DirContext)ContextClassLoaderSwitchingUtil.runInContext((ClassLoader)ComponentLocator.class.getClassLoader(), () -> {
                try {
                    return new InitialDirContext(env);
                }
                catch (NamingException e) {
                    log.debug("DNS discovery failed", (Throwable)e);
                    throw new RuntimeException(e);
                }
            });
            log.debug("Using DNS provider: {}", context.getEnvironment().get("java.naming.provider.url"));
            model.put("dnsProvider", context.getEnvironment().get("java.naming.provider.url"));
            Attributes enumeration = context.getAttributes("_kerberos._tcp." + domain, new String[]{"SRV"});
            if (enumeration.size() == 0) {
                model.put("ldapServerNotFound", true);
                log.debug("No LDAP SRV records found for domain {}", (Object)domain);
            } else {
                String srv = enumeration.get("SRV").get().toString();
                String[] comps = srv.split(" ");
                String ldapServerName = comps[3];
                while (ldapServerName.endsWith(".")) {
                    ldapServerName = ldapServerName.substring(0, ldapServerName.length() - 1);
                }
                log.debug("Found LDAP server {} for domain {}", (Object)ldapServerName, (Object)domain);
            }
        }
        catch (NameNotFoundException e) {
            model.put("ldapServerNotFound", true);
            model.put("ldapServerNotFoundMessage", e.getMessage());
            log.warn("No LDAP SRV records found for domain {}", (Object)domain, (Object)e);
        }
        catch (Exception e) {
            log.warn("Kerberos DNS discovery failed", (Throwable)e);
            model.put("ldapServerNotFound", true);
            model.put("problemFindingLdapServerMessage", String.format("%s: %s", e.getClass().getSimpleName(), e.getMessage()));
        }
        finally {
            if (context != null) {
                try {
                    context.close();
                }
                catch (NamingException e) {}
            }
        }
    }

    protected void doGetKsso(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
        Map<String, Object> model = this.newModel(req);
        TestLdapAction.checkLdapSrv(model, this.getDomainFromKeytab());
        resp.setContentType("text/html");
        model.put("keytab", new Keytab(this.kerbConfManager.getKeytabInfos()));
        model.put("realms", this.getRealms());
        model.put("userDirectories", this.directoryManager.getActiveMsAdDirectories());
        model.put("followReferrals", false);
        this.renderer.render("templates/atlaskerb/ldaptestresult.vm", model, (Writer)resp.getWriter());
    }

    private String getDomainFromKeytab() {
        KeytabInfo keytabInfo = this.kerbConfManager.getKeytabInfos().get(0);
        String domain = keytabInfo.getRealm();
        log.debug("Using realm {} from keytab", (Object)domain);
        while (domain.indexOf(".") != -1 && domain.indexOf(".", domain.indexOf(".") + 1) != -1) {
            domain = domain.substring(domain.indexOf(".") + 1);
        }
        return domain;
    }

    @Override
    protected void doPostKsso(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
        super.doPostKsso(req, resp);
        Map<String, Object> model = this.newModel(req);
        model.put("userDirectories", this.directoryManager.getActiveMsAdDirectories());
        model.put("exceptionTool", new ExceptionTool());
        model.put("ldapResults", Boolean.TRUE);
        model.put("keytab", new Keytab(this.kerbConfManager.getKeytabInfos()));
        model.put("realms", this.getRealms());
        try {
            if (!HttpUrlUtils.isValidURI((String)req.getRequestURL().toString())) {
                throw new RuntimeException("Invalid URI");
            }
        }
        catch (URISyntaxException e) {
            log.warn("Invalid URL syntax", (Throwable)e);
            throw new RuntimeException(e);
        }
        model.put("displayName", this.applicationProperties.getDisplayName());
        this.ldapTest(model, req);
        resp.setContentType("text/html");
        this.renderer.render("templates/atlaskerb/ldaptestresult.vm", model, (Writer)resp.getWriter());
    }

    private Set<String> getRealms() {
        LinkedHashSet<String> realms = new LinkedHashSet<String>();
        for (KeytabInfo keytabInfo : this.kerbConfManager.getKeytabInfos()) {
            realms.add(keytabInfo.getRealm());
        }
        return realms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ldapTest(Map<String, Object> model, HttpServletRequestFacade req) {
        String ldapServerUrl = req.getParameter("ldapServerUrl");
        String ldapUsername = req.getParameter("ldapUsername");
        String ldapPassword = req.getParameter("ldapPassword");
        boolean followReferrals = req.getParameter("followReferrals") != null;
        String directory = req.getParameter("directory");
        model.put("tool", new LdapTestTool());
        model.put("directory", req.getParameter("directory"));
        model.put("ldapServerUrl", ldapServerUrl);
        model.put("ldapUsername", ldapUsername);
        model.put("followReferrals", followReferrals);
        log.debug("Testing LDAP connection to {} as {}", (Object)ldapServerUrl, (Object)ldapUsername);
        if ("custom".equals(directory)) {
            if (ldapPassword == null || ldapPassword.isEmpty()) {
                model.put("passwordMissing", Boolean.TRUE);
                return;
            }
            if (ldapUsername == null || ldapUsername.isEmpty()) {
                model.put("usernameMissing", Boolean.TRUE);
                log.debug("Username is missing");
                return;
            }
        }
        Keytab keytab = new Keytab(Collections.emptyList());
        Set<Integer> encTypesInKeytab = this.findKeytabEncTypes();
        model.put("keytabSupportedEncTypes", encTypesInKeytab);
        log.debug("Keytab contains encryption types: {}", encTypesInKeytab);
        TreeMap<String, List<LdapTestResult>> results = new TreeMap<String, List<LdapTestResult>>();
        Hashtable<Object, Object> env = null;
        if (!"custom".equals(directory)) {
            for (DomainDirectory domainDirectory : this.directoryManager.getActiveMsAdDirectories()) {
                log.debug("Checking directory {}", (Object)domainDirectory.getDirectory().getName());
                if (!domainDirectory.getDirectory().getId().toString().equals(directory)) continue;
                env = this.directoryManager.getEnvForDirectory(domainDirectory.getDirectory());
                log.debug("Using LDAP server {} from directory {}", env.get("java.naming.provider.url"), (Object)domainDirectory.getDirectory().getName());
                Option.of(env).peek(env1 -> {
                    model.put("ldapUsername", env1.get("java.naming.security.principal"));
                    model.put("ldapServerUrl", env1.get("java.naming.provider.url"));
                }).onEmpty(() -> {
                    model.put("ldapUsername", "<not found>");
                    model.put("ldapServerUrl", "<not found>");
                });
                break;
            }
        } else {
            env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            env.put("java.naming.provider.url", SetupAction.addLdapProtocol(ldapServerUrl));
            env.put("java.naming.security.principal", ldapUsername);
            env.put("java.naming.security.credentials", ldapPassword);
            log.debug("Using custom LDAP server {}", (Object)ldapServerUrl);
        }
        String ldapRealm = StringUtils.upperCase((String)StringUtils.substringAfter((String)((String)Option.of(env).map(env1 -> (String)env1.get("java.naming.security.principal")).getOrElse((Object)"")), (String)"@"));
        log.debug("Using realm {} from username", (Object)ldapRealm);
        TreeSet<String> servicePrincipalNames = new TreeSet<String>();
        for (KeytabInfo keytabInfo : this.kerbConfManager.getKeytabInfos()) {
            if (!"HTTP".equalsIgnoreCase(keytabInfo.getServicePart()) || keytabInfo.getHostPart() == null || !keytabInfo.getRealm().equals(ldapRealm)) continue;
            servicePrincipalNames.add(keytab.nameWithoutRealm(keytabInfo));
        }
        if (followReferrals) {
            env.put("java.naming.referral", "follow");
            log.debug("Following referrals enabled");
        }
        Context context = null;
        try {
            log.debug("Connecting to LDAP server {} as {}", env.get("java.naming.provider.url"), env.get("java.naming.security.principal"));
            context = new InitialDirContext(env);
            log.debug("Connected to LDAP server");
            String defaultNamingContext = this.getDefaultNamingContext((DirContext)context);
            List<LdapTestResult> readOnlyDomainControllers = this.ldapPrincipalSearcher.findReadOnlyDomainControllers((DirContext)context, defaultNamingContext);
            this.findDomainFunctionality(model, (DirContext)context);
            this.findServiceUsers(model, servicePrincipalNames, results, (DirContext)context, defaultNamingContext, readOnlyDomainControllers);
            model.put("results", results);
        }
        catch (AuthenticationException e) {
            model.put("ldapAuthenticationFailed", true);
            log.warn("LDAP authentication failed", (Throwable)e);
        }
        catch (CommunicationException e) {
            model.put("ldapCommunicationExceptionName", e.getClass().getName());
            model.put("ldapCommunicationExceptionMessage", e.getMessage());
            ExceptionTool et = new ExceptionTool();
            model.put("ldapCommunicationRootExceptionName", et.getRootException(e).getClass().getName());
            model.put("ldapCommunicationRootExceptionMessage", et.getRootException(e).getMessage());
            log.warn("LDAP communication exception", (Throwable)e);
        }
        catch (NamingException e) {
            model.put("namingExceptionName", e.getClass().getName());
            model.put("namingExceptionMessage", e.getMessage());
            ExceptionTool et = new ExceptionTool();
            model.put("namingRootExceptionName", et.getRootException(e).getClass().getName());
            model.put("namingRootExceptionMessage", et.getRootException(e).getMessage());
            model.put("namingRootExceptionStackTrace", et.toString(e));
            log.warn("LDAP naming exception", (Throwable)e);
        }
        catch (Exception e) {
            model.put("genericExceptionName", e.getClass().getName());
            model.put("genericExceptionMessage", e.getMessage());
            ExceptionTool et = new ExceptionTool();
            model.put("genericRootExceptionName", et.getRootException(e).getClass().getName());
            model.put("genericRootExceptionMessage", et.getRootException(e).getMessage());
            model.put("genericExceptionStackTrace", et.toString(e));
            log.warn("LDAP generic exception", (Throwable)e);
        }
        finally {
            if (context != null) {
                try {
                    context.close();
                }
                catch (NamingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private void findDomainFunctionality(Map<String, Object> model, DirContext context) throws NamingException {
        SearchControls sc = new SearchControls();
        sc.setSearchScope(0);
        NamingEnumeration<SearchResult> search = context.search("", "(objectClass=*)", sc);
        log.debug("Searching for rootDSE");
        if (search.hasMoreElements()) {
            log.debug("Found rootDSE");
            SearchResult rootDse = search.next();
            Attributes attributes = rootDse.getAttributes();
            this.addAttr(model, attributes, "domainFunctionality");
            this.addAttr(model, attributes, "domainControllerFunctionality");
            this.addAttr(model, attributes, "forestFunctionality");
        }
    }

    private void addAttr(Map<String, Object> model, Attributes attributes, String attrName) throws NamingException {
        Attribute attr = attributes.get(attrName);
        if (attr != null) {
            String value = (String)attr.get();
            model.put(attrName, value);
        }
    }

    private void findServiceUsers(Map<String, Object> model, Set<String> servicePrincipalNames, Map<String, List<LdapTestResult>> results, DirContext context, String defaultNamingContext, List<LdapTestResult> readOnlyDomainControllers) throws NamingException {
        model.put("defaultNamingContext", defaultNamingContext);
        log.debug("Default naming context: {}", (Object)defaultNamingContext);
        for (String servicePrincipalName : servicePrincipalNames) {
            List<LdapTestResult> result = this.ldapPrincipalSearcher.findAccountsForSpn(context, defaultNamingContext, servicePrincipalName, true);
            this.checkRevealedToReadOnlyDomainController(readOnlyDomainControllers, result, context, defaultNamingContext);
            results.put(servicePrincipalName, result);
            log.debug("Found {} accounts for service principal name {}", (Object)result.size(), (Object)servicePrincipalName);
        }
    }

    private void checkRevealedToReadOnlyDomainController(List<LdapTestResult> readOnlyDomainControllers, List<LdapTestResult> result, DirContext context, String defaultNamingContext) throws NamingException {
        if (!readOnlyDomainControllers.isEmpty() && result.size() == 1) {
            LdapTestResult account = result.get(0);
            log.debug("Checking readOnlyDomainControllers for account {}", (Object)account.getServicePrincipalUsername());
            for (LdapTestResult controller : readOnlyDomainControllers) {
                Set<String> allowGroups = this.getPrpGroups(controller, "msDS-RevealOnDemandGroup");
                Set<String> denyGroups = this.getPrpGroups(controller, "msDS-NeverRevealGroup");
                log.debug("ReadOnlyDomainController {} has {} allow groups and {} deny groups", new Object[]{controller.getDn(), allowGroups.size(), denyGroups.size()});
                boolean isDenied = this.ldapPrincipalSearcher.checkMembership(context, defaultNamingContext, account.getServicePrincipalUsername(), denyGroups, true);
                if (isDenied) {
                    account.passwordReplicatonDenied(controller, true);
                    log.debug("Account {} is a member of a deny group for controller {}", (Object)account.getServicePrincipalUsername(), (Object)controller.getDn());
                    continue;
                }
                boolean isAllowed = this.ldapPrincipalSearcher.checkMembership(context, defaultNamingContext, account.getServicePrincipalUsername(), allowGroups, true);
                log.debug("Account {} is {} a member of an allow group for controller {}", new Object[]{account.getServicePrincipalUsername(), isAllowed ? "" : "not", controller.getDn()});
                if (isAllowed) continue;
                account.passwordReplicatonDenied(controller, false);
            }
        }
    }

    private Set<String> getPrpGroups(LdapTestResult readOnlyDomainController, String attributeName) throws NamingException {
        HashSet<String> groups = new HashSet<String>();
        Attribute attribute = readOnlyDomainController.getAdditionalAttributes().get(attributeName);
        if (attribute != null) {
            for (int i = 0; i < attribute.size(); ++i) {
                groups.add(attribute.get(i).toString());
                log.debug("Found {} group {}", (Object)attributeName, (Object)attribute.get(i).toString());
            }
        }
        return groups;
    }

    private String getDefaultNamingContext(DirContext context) throws NamingException {
        SearchResult next;
        Attributes attrs;
        NamingEnumeration<SearchResult> search;
        SearchControls sc = new SearchControls();
        sc.setSearchScope(0);
        if (context != null && (search = context.search("", "(objectClass=*)", sc)) != null && search.hasMore() && (attrs = (next = search.next()).getAttributes()).size() > 0) {
            Attribute namingContext = attrs.get("defaultNamingContext");
            log.debug("Found defaultNamingContext attribute: " + String.valueOf(namingContext));
            if (namingContext != null) {
                return (String)namingContext.get();
            }
        }
        return null;
    }

    private Set<Integer> findKeytabEncTypes() {
        TreeSet<Integer> treeSet;
        FileInputStream stream = new FileInputStream(this.kerbConfManager.getKeytabFile());
        try {
            TreeSet<Integer> enctypes = new TreeSet<Integer>();
            List list = new KeytabParser().parse((InputStream)stream);
            for (KeytabInfo keytabInfo : list) {
                enctypes.add(keytabInfo.getEncType());
            }
            treeSet = enctypes;
        }
        catch (Throwable throwable) {
            try {
                try {
                    stream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FileNotFoundException e) {
                log.warn("Keytab file not found", (Throwable)e);
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                log.warn("Unable to read keytab file", (Throwable)e);
                throw new RuntimeException();
            }
        }
        stream.close();
        return treeSet;
    }
}

