/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.security;

import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public enum SameSiteCookiePolicy {
    STRICT("Strict", Collections.emptyList()),
    LAX("Lax", Collections.emptyList()),
    NONE("None", Collections.singletonList("Secure")),
    DEFAULT("default", Collections.emptyList());

    public final String value;
    private final List<String> additionalAttributes;

    private SameSiteCookiePolicy(String value, List<String> additionalAttributes) {
        this.value = value;
        this.additionalAttributes = additionalAttributes;
    }

    public String value() {
        return this.value;
    }

    public String additionalAttributes() {
        if (this.additionalAttributes.isEmpty()) {
            return "";
        }
        return "; " + (String)io.vavr.collection.List.ofAll(this.additionalAttributes).intersperse((Object)"; ").foldLeft((Object)"", String::concat);
    }

    public static SameSiteCookiePolicy parse(String valueToParse) {
        for (SameSiteCookiePolicy policy : SameSiteCookiePolicy.values()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)policy.value, (CharSequence)valueToParse)) continue;
            return policy;
        }
        return DEFAULT;
    }

    public static SameSiteCookiePolicy parse(Object valueToParse) {
        for (SameSiteCookiePolicy policy : SameSiteCookiePolicy.values()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)policy.value, (CharSequence)((String)valueToParse))) continue;
            return policy;
        }
        return DEFAULT;
    }
}

