/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.security;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.kantegasso.servlet.FilterChainFacade;
import com.kantegasso.servlet.FilterConfigFacade;
import com.kantegasso.servlet.FilterFacade;
import com.kantegasso.servlet.http.HttpServletRequestFacade;
import com.kantegasso.servlet.http.HttpServletResponseFacade;
import jakarta.inject.Inject;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.security.SameSiteCookiePolicy;
import org.kantega.atlaskerb.security.SetSameSiteCookieInResponseWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UnrestrictedAccess
public final class SamesiteContentSecurityPolicyHeadersFilter
extends FilterFacade {
    private static final Logger log = LoggerFactory.getLogger(SamesiteContentSecurityPolicyHeadersFilter.class);
    private final KerbConfManager kerbConfManager;
    private static final String ALREADY_MATCHED_ATTR = SamesiteContentSecurityPolicyHeadersFilter.class.getName() + "_alreadyMatched";

    @Inject
    public SamesiteContentSecurityPolicyHeadersFilter(KerbConfManager kerbConfManager) {
        this.kerbConfManager = kerbConfManager;
    }

    public void initKssoFilter(FilterConfigFacade filterConfig) {
    }

    public void doFilterKsso(HttpServletRequestFacade request, HttpServletResponseFacade response, FilterChainFacade chain) throws IOException {
        if (this.kerbConfManager.getSameSiteCookiePolicy() != SameSiteCookiePolicy.DEFAULT) {
            if (response != null) {
                for (String hostName : this.kerbConfManager.getContentSecurityPolicyHostNames()) {
                    if (StringUtils.endsWith((CharSequence)hostName, (CharSequence)"/")) {
                        hostName = StringUtils.substringBeforeLast((String)hostName, (String)"/");
                    }
                    response.setHeader("Content-Security-Policy", response.getHeader("Content-Security-Policy") + " " + hostName);
                }
            }
            if (request.getAttribute(ALREADY_MATCHED_ATTR) != null) {
                chain.doFilterKsso(request, response);
            } else {
                request.setAttribute(ALREADY_MATCHED_ATTR, (Object)true);
                chain.doFilterKsso(request, (HttpServletResponseFacade)new SetSameSiteCookieInResponseWrapper(request, response, this.kerbConfManager.getSameSiteCookiePolicy()));
            }
        } else {
            chain.doFilterKsso(request, response);
        }
    }

    public void destroy() {
    }
}

