/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.dircopy;

import com.atlassian.crowd.directory.InternalDirectory;
import com.atlassian.crowd.embedded.api.ApplicationFactory;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.embedded.impl.ImmutableDirectory;
import com.atlassian.crowd.manager.application.ApplicationManager;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.google.common.collect.ImmutableMap;
import com.kantegasso.servlet.http.HttpServletRequestFacade;
import com.kantegasso.servlet.http.HttpServletResponseFacade;
import com.ksso.scim.atlassian.hostapp.DefaultScimHostApp;
import io.vavr.collection.Map;
import io.vavr.control.Option;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManageInternalDirectoriesServlet
extends RequireAdminServlet {
    private static final Logger log = LoggerFactory.getLogger(ManageInternalDirectoriesServlet.class);
    private final TemplateRenderer renderer;
    private final ApplicationProperties applicationProperties;
    private final HostApp hostApp;
    private final DirectoryManager directoryManager;
    private final TransactionTemplate transactionTemplate;

    @Inject
    public ManageInternalDirectoriesServlet(RequireAdminServletDependencyBucket bucket, @ComponentImport TransactionTemplate transactionTemplate) {
        super(bucket);
        this.renderer = bucket.getTemplateRenderer();
        this.applicationProperties = bucket.getApplicationProperties();
        this.hostApp = bucket.getHostApp();
        this.directoryManager = this.hostApp.getDirectoryManager();
        this.transactionTemplate = transactionTemplate;
    }

    protected void doGetKsso(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
        this.modelAndRender(req, resp, null);
    }

    private void modelAndRender(HttpServletRequestFacade req, HttpServletResponseFacade resp, String errorMessage) throws IOException {
        java.util.Map<String, Object> model = this.newModel(req);
        model.put("topMenu", "dark-features");
        model.put("menuItem", "manageInternalDirectories");
        model.put("contextPath", req.getContextPath());
        model.put("displayName", this.applicationProperties.getDisplayName());
        model.put("errorMessage", errorMessage);
        String username = this.getLoggedInUsername(req);
        Directory adminUserDir = this.hostApp.getDirectoryForUser(username);
        model.put("adminUserDir", adminUserDir);
        List internalDirectories = this.hostApp.getCrowdDirectoryService().findAllDirectories().stream().filter(directory -> DirectoryType.INTERNAL.equals((Object)directory.getType())).collect(Collectors.toList());
        model.put("internalDirectories", internalDirectories);
        resp.setContentType("text/html");
        this.renderer.render("templates/atlaskerb/manageInternalDirectories.vm", model, (Writer)resp.getWriter());
    }

    @Override
    protected void doPostKsso(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
        String removeDirectoryId;
        super.doPostKsso(req, resp);
        String errorMessage = null;
        String directoryName = req.getParameter("directoryName");
        if (StringUtils.isNotBlank((CharSequence)directoryName)) {
            errorMessage = this.createDirectory(directoryName);
        }
        if (StringUtils.isNotBlank((CharSequence)(removeDirectoryId = req.getParameter("removeDirectoryId")))) {
            String username = this.getLoggedInUsername(req);
            Directory adminUserDir = this.hostApp.getDirectoryForUser(username);
            errorMessage = !removeDirectoryId.equals(adminUserDir.getId().toString()) ? this.removeDirectory(removeDirectoryId) : "You cannot remove the directory you are currently using.";
        }
        String editDirectoryId = req.getParameter("editDirectoryId");
        String editDirectoryName = req.getParameter("editDirectoryName");
        if (StringUtils.isNotBlank((CharSequence)editDirectoryId) && StringUtils.isNotBlank((CharSequence)editDirectoryName)) {
            errorMessage = this.renameDirectory(editDirectoryId, editDirectoryName);
        }
        this.modelAndRender(req, resp, errorMessage);
    }

    private String renameDirectory(String editDirectoryId, String editDirectoryName) {
        Directory directory = this.hostApp.getCrowdDirectoryService().findDirectoryById(Long.parseLong(editDirectoryId));
        ImmutableDirectory.Builder builder = ImmutableDirectory.newBuilder((Directory)directory);
        builder.setName(editDirectoryName);
        this.transactionTemplate.execute(() -> {
            try {
                this.hostApp.getDirectoryManager().updateDirectory(builder.toDirectory());
            }
            catch (Exception e) {
                return e.getMessage();
            }
            return null;
        });
        return null;
    }

    private String removeDirectory(String removeDirectoryId) {
        this.transactionTemplate.execute(() -> {
            try {
                Directory directory = this.hostApp.getCrowdDirectoryService().findDirectoryById(Long.parseLong(removeDirectoryId));
                ApplicationManager applicationManager = (ApplicationManager)ComponentLocator.getComponent(ApplicationManager.class);
                Application application = ((ApplicationFactory)ComponentLocator.getComponent(ApplicationFactory.class)).getApplication();
                if (!"JIRA".equals(application.getName())) {
                    applicationManager.removeDirectoryFromApplication(directory, application);
                }
                this.hostApp.getDirectoryManager().removeDirectory(directory);
            }
            catch (Exception e) {
                return e.getMessage();
            }
            return null;
        });
        return null;
    }

    private String createDirectory(String directoryName) {
        ImmutableDirectory.Builder builder = ImmutableDirectory.newBuilder();
        builder.setType(DirectoryType.INTERNAL);
        builder.setName(directoryName);
        builder.setImplementationClass(InternalDirectory.class.getName());
        ImmutableMap attrs = ImmutableMap.builder().put((Object)"useNestedGroups", (Object)"true").put((Object)"user_encryption_method", (Object)"atlassian-security").build();
        builder.setAttributes((java.util.Map)attrs);
        builder.setAllowedOperations(DefaultScimHostApp.ALL_OPS);
        Directory newDir = builder.toDirectory();
        this.transactionTemplate.execute(() -> {
            try {
                Directory addedDirectory = this.hostApp.getDirectoryManager().addDirectory(newDir);
                if (!this.hostApp.isProductMatch("jira")) {
                    ApplicationManager applicationManager = (ApplicationManager)ComponentLocator.getComponent(ApplicationManager.class);
                    applicationManager.addDirectoryMapping(((ApplicationFactory)ComponentLocator.getComponent(ApplicationFactory.class)).getApplication(), addedDirectory, true, DefaultScimHostApp.ALL_OPS.toArray(new OperationType[0]));
                }
            }
            catch (Exception e) {
                return e.getMessage();
            }
            return null;
        });
        return null;
    }

    private String getLoggedInUsername(HttpServletRequestFacade req) {
        String loggedInUsername = (String)Option.of((Object)this.userManager.getRemoteUser((HttpServletRequest)req)).map(UserProfile::getUsername).getOrNull();
        return loggedInUsername;
    }

    public static class DirectoryDetails {
        private final Directory directory;
        private final boolean isWritable;
        private final Map<String, String> attributeMap;
        private final List<String> groups;

        public DirectoryDetails(Directory directory, boolean isWritable, Map<String, String> attributeMap, List<String> groups) {
            this.directory = directory;
            this.isWritable = isWritable;
            this.attributeMap = attributeMap;
            this.groups = groups;
        }

        public Directory getDirectory() {
            return this.directory;
        }

        public boolean isWritable() {
            return this.isWritable;
        }

        public java.util.Map<String, String> getAttributeMap() {
            if (this.attributeMap == null) {
                return new HashMap<String, String>();
            }
            return this.attributeMap.toJavaMap();
        }

        public List<String> getGroups() {
            return this.groups;
        }
    }
}

