/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb;

import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.kantegasso.servlet.http.HttpServletFacade;
import com.kantegasso.servlet.http.HttpServletRequestFacade;
import com.kantegasso.servlet.http.HttpServletResponseFacade;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.kantega.atlaskerb.PluginKey;

public abstract class RequireLoggedInUserServlet
extends HttpServletFacade {
    public static final String KRB_CSRF_TOKEN_ATTR = "krb_csrf_token";
    private final UserManager userManager;
    private final LoginUriProvider loginUriProvider;

    public RequireLoggedInUserServlet(UserManager userManager, LoginUriProvider loginUriProvider) {
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
    }

    protected void serviceKsso(HttpServletRequestFacade request, HttpServletResponseFacade response) throws IOException {
        response.setHeader("Cache-Control", "private, max-age=0, no-cache");
        UserProfile remoteUser = this.userManager.getRemoteUser((HttpServletRequest)request);
        if (remoteUser == null) {
            try {
                this.redirectToLogin(request, response);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            super.serviceKsso(request, response);
        }
    }

    protected void redirectToLogin(HttpServletRequestFacade request, HttpServletResponseFacade response) throws IOException {
        try {
            Object url = request.getRequestURI().substring(request.getContextPath().length());
            if (request.getQueryString() != null) {
                url = (String)url + "?" + request.getQueryString();
            }
            URI returnUri = new URI((String)url);
            String location = this.loginUriProvider.getLoginUri(returnUri).toString();
            response.sendRedirect(location);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    protected Map<String, Object> newModel(HttpServletRequestFacade req) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("krb_token", req.getSessionKsso().getAttribute(KRB_CSRF_TOKEN_ATTR));
        String pluginKey = PluginKey.getPluginKey();
        model.put("pluginKey", pluginKey);
        model.put("pluginResource", pluginKey + ":entrypoint-atlaskerb");
        String contextPath = req.getContextPath();
        model.put("contextPath", contextPath);
        return model;
    }
}

