/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.connector.admin;

import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.UserQuery;
import com.atlassian.crowd.search.query.entity.restriction.BooleanRestriction;
import com.atlassian.crowd.search.query.entity.restriction.BooleanRestrictionImpl;
import com.atlassian.crowd.search.query.entity.restriction.MatchMode;
import com.atlassian.crowd.search.query.entity.restriction.NullRestrictionImpl;
import com.atlassian.crowd.search.query.entity.restriction.TermRestriction;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.kantegasso.servlet.http.HttpServletRequestFacade;
import com.kantegasso.servlet.http.HttpServletResponseFacade;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.lang3.NotImplementedException;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.connector.ConnectorConfManager;
import org.kantega.atlaskerb.connector.admin.CrowdDirectoryFinder;
import org.kantega.atlaskerb.connector.model.Directory;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.wrapper.crowd.CrowdUserWrapper;

public class DirectoryUsersAction
extends RequireAdminServlet {
    private final ApplicationProperties applicationProperties;
    private final ConnectorConfManager connectorConfManager;
    private final TemplateRenderer renderer;
    private final HostApp hostApp;

    @Inject
    public DirectoryUsersAction(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
        this.applicationProperties = bucket.getApplicationProperties();
        this.connectorConfManager = bucket.getConnectorConfManager();
        this.renderer = bucket.getTemplateRenderer();
        this.hostApp = bucket.getHostApp();
    }

    protected void doGetKsso(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
        Map<String, Object> model = this.newModel(req);
        String id = req.getParameter("id");
        String filter = req.getParameter("filter");
        Directory dir = this.connectorConfManager.getDirectory(id);
        if (dir == null) {
            resp.sendError(404);
            return;
        }
        int startIndex = 0;
        if (req.getParameter("start-index") != null) {
            startIndex = Integer.parseInt(req.getParameter("start-index"));
        }
        model.put("platformSupportsAvatars", this.hostApp.supportsAvatars(this.applicationProperties));
        model.put("kind", dir.getKind());
        model.put("groupSelectionMode", (Object)dir.getUserMembershipFilter().getMode());
        model.put("userTypeSelectionMode", dir.getUserTypeSelectionFilter().getMode().name());
        model.put("currentConnector", dir);
        model.put("topMenu", "connectors");
        model.put("menuItem", "directoryUsers");
        model.put("displayName", this.applicationProperties.getDisplayName());
        model.put("connectorType", this.connectorConfManager.getConnectorTypes().get(dir.getKind()));
        model.put("userFilter", filter);
        Object filterRestriction = filter == null || filter.trim().isEmpty() ? NullRestrictionImpl.INSTANCE : new BooleanRestrictionImpl(BooleanRestriction.BooleanLogic.OR, new SearchRestriction[]{new TermRestriction(UserTermKeys.DISPLAY_NAME, MatchMode.CONTAINS, (Object)filter), new TermRestriction(UserTermKeys.EMAIL, MatchMode.CONTAINS, (Object)filter)});
        this.render(dir, resp, model, (SearchRestriction)filterRestriction, startIndex);
    }

    private void render(Directory dir, HttpServletResponseFacade resp, Map<String, Object> model, SearchRestriction restriction, int startIndex) throws IOException {
        try {
            boolean isFirst;
            com.atlassian.crowd.embedded.api.Directory cd = new CrowdDirectoryFinder(this.hostApp).findDirectory(dir.getId());
            DirectoryManager directoryManager = this.hostApp.getDirectoryManager();
            int maxResults = 50;
            List<CrowdUserWrapper> users = directoryManager.searchUsers(cd.getId().longValue(), (EntityQuery)new UserQuery(User.class, restriction, startIndex, maxResults)).stream().map(CrowdUserWrapper::new).collect(Collectors.toList());
            model.put("directoryUsers", users);
            try {
                model.put("usernameAvatarUriMap", this.hostApp.getUsersProfilePictureForVelocity(users));
            }
            catch (NotImplementedException notImplementedException) {
                // empty catch block
            }
            model.put("firstIndex", startIndex + 1);
            model.put("lastIndex", startIndex + users.size());
            boolean isMore = maxResults == users.size();
            boolean bl = isFirst = startIndex == 0;
            if (isMore) {
                model.put("nextIndex", startIndex + users.size());
            }
            if (!isFirst) {
                model.put("prevIndex", startIndex - maxResults);
            }
            resp.setContentType("text/html");
            resp.setCharacterEncoding(StandardCharsets.UTF_8.name());
            this.renderer.render("templates/atlaskerb/connector/users.vm", model, (Writer)resp.getWriter());
        }
        catch (DirectoryNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (OperationFailedException e) {
            throw new RuntimeException(e);
        }
    }
}

