/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.kantegasso.servlet.FilterChainFacade;
import com.kantegasso.servlet.FilterFacade;
import com.kantegasso.servlet.ServletOutputStreamFacade;
import com.kantegasso.servlet.http.HttpServletRequestFacade;
import com.kantegasso.servlet.http.HttpServletResponseFacade;
import jakarta.inject.Inject;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.utils.InternetAddressUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UnrestrictedAccess
public class ServiceDeskSignupFilter
extends FilterFacade {
    private final TemplateRenderer templateRenderer;
    private final KerbConfManager kerbConfManager;
    private final Logger log = LoggerFactory.getLogger(ServiceDeskSignupFilter.class);

    @Inject
    public ServiceDeskSignupFilter(@ComponentImport TemplateRenderer templateRenderer, KerbConfManager kerbConfManager) {
        this.templateRenderer = templateRenderer;
        this.kerbConfManager = kerbConfManager;
    }

    public static String getEmailFromHeader(HttpServletRequestFacade req, KerbConfManager kerbConfManager) {
        String remoteAddr = req.getRemoteAddr();
        String emailFromHeader = null;
        boolean headerUsernameIpUnblocked = InternetAddressUtils.isAddressPermissionMatch((String)remoteAddr, (String[])kerbConfManager.getHeaderUsernameIpUnblockedList());
        if (headerUsernameIpUnblocked && kerbConfManager.getHeaderEmailAttribute() != null) {
            emailFromHeader = req.getHeader(kerbConfManager.getHeaderEmailAttribute());
        }
        return ServiceDeskSignupFilter.isValidEmailAddress(emailFromHeader) ? emailFromHeader : null;
    }

    private static boolean isValidEmailAddress(String email) {
        boolean result = true;
        if (email == null) {
            return false;
        }
        try {
            InternetAddress emailAddr = new InternetAddress(email);
            emailAddr.validate();
        }
        catch (AddressException ex) {
            result = false;
        }
        return result;
    }

    public void doFilterKsso(HttpServletRequestFacade request, HttpServletResponseFacade response, FilterChainFacade chain) throws IOException {
        HttpServletRequestFacade req = HttpServletRequestFacade.of((HttpServletRequest)request);
        HttpServletResponseFacade resp = HttpServletResponseFacade.of((HttpServletResponse)response);
        final String emailFromHeader = ServiceDeskSignupFilter.getEmailFromHeader(req, this.kerbConfManager);
        final String jsmSignupEmailUnblockedList = this.kerbConfManager.getJsmSignupEmailUnblockedList();
        final String jsmUrlFormUrlparts = this.kerbConfManager.getJsmSignupFormUrlparts();
        if (StringUtils.isNotBlank((CharSequence)emailFromHeader) || StringUtils.isNotBlank((CharSequence)jsmSignupEmailUnblockedList)) {
            chain.doFilterKsso(req, new HttpServletResponseFacade((HttpServletResponse)resp){
                ServletOutputStreamFacade out;

                public ServletOutputStreamFacade getOutputStreamFacade() throws IOException {
                    if (this.out == null) {
                        ServiceDeskSignupFilter.this.log.debug("Setting up ServiceDeskSignupFilter. ServletOutputStream out == null");
                        this.out = new InjectingOutputStream(emailFromHeader, jsmSignupEmailUnblockedList, jsmUrlFormUrlparts, super.getOutputStreamFacade());
                    }
                    return this.out;
                }
            });
        } else {
            chain.doFilterKsso(req, resp);
        }
    }

    public void destroy() {
    }

    private class InjectingOutputStream
    extends ServletOutputStreamFacade {
        private final byte[] headStart;
        private final String emailFromHeader;
        private final String jsmSignupEmailUnblockedList;
        private final String jsmUrlFormUrlparts;

        public InjectingOutputStream(String emailFromHeader, String jsmSignupEmailUnblockedList, String jsmUrlFormUrlparts, ServletOutputStreamFacade outputStream) {
            super((ServletOutputStream)outputStream);
            this.emailFromHeader = emailFromHeader;
            this.jsmSignupEmailUnblockedList = jsmSignupEmailUnblockedList;
            this.jsmUrlFormUrlparts = jsmUrlFormUrlparts;
            this.headStart = "<head>".getBytes(StandardCharsets.UTF_8);
        }

        public void write(int b) throws IOException {
            super.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            int head = this.findHeadStart(b, off, len);
            if (head != -1) {
                super.write(b, off, head - off + this.headStart.length);
                StringWriter inject = new StringWriter();
                ServiceDeskSignupFilter.this.log.debug("Writing js changes. emailFromHeader: " + this.emailFromHeader);
                HashMap<String, String> model = new HashMap<String, String>();
                inject.append("<script type=\"text/javascript\">emailFromHeader = '").append(this.emailFromHeader).append("'</script>");
                inject.append("<script type=\"text/javascript\">jsmSignupEmailUnblockedList = '").append(this.jsmSignupEmailUnblockedList).append("'</script>");
                model.put("jsmSignupEmailUnblockedList", this.jsmSignupEmailUnblockedList);
                model.put("jsmUrlFormUrlparts", this.jsmUrlFormUrlparts);
                model.put("emailFromHeader", this.emailFromHeader);
                try {
                    ServiceDeskSignupFilter.this.templateRenderer.render("templates/atlaskerb/jsm-signup-email.vm", model, (Writer)inject);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                super.write(inject.toString().getBytes(StandardCharsets.UTF_8));
                super.write(b, head + this.headStart.length, len - head - this.headStart.length);
            } else {
                super.write(b, off, len);
            }
        }

        private int findHeadStart(byte[] b, int off, int len) {
            for (int i = off; i < off + len - this.headStart.length; ++i) {
                if (!this.findHeadStart(b, i)) continue;
                return i;
            }
            return -1;
        }

        private boolean findHeadStart(byte[] b, int i) {
            for (int h = 0; h < this.headStart.length; ++h) {
                if (b[i + h] == this.headStart[h]) continue;
                return false;
            }
            return true;
        }
    }
}

