/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.intercept.strategy;

import com.atlassian.crowd.embedded.api.Directory;
import com.kantegasso.servlet.http.HttpServletRequestFacade;
import com.kantegasso.servlet.http.HttpServletResponseFacade;
import io.vavr.CheckedFunction2;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Base64;
import java.util.concurrent.TimeUnit;
import javax.security.auth.Subject;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.IpRestrictionConfig;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.LoginAttempt;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.diagnostics.AuditLogFacade;
import org.kantega.atlaskerb.diagnostics.FailureListener;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.intercept.filter.RequestInterceptor;
import org.kantega.atlaskerb.intercept.model.AuthMethod;
import org.kantega.atlaskerb.intercept.model.InterceptExitCondition;
import org.kantega.atlaskerb.intercept.model.InterceptResult;
import org.kantega.atlaskerb.intercept.strategy.InterceptAuthStrategy;
import org.kantega.atlaskerb.kerberos.PrincipalEntry;
import org.kantega.atlaskerb.userlookup.UserLookupService;
import org.kantega.atlaskerb.utils.HttpUrlUtils;
import org.simplericity.serberuhs.DecodedKerberosToken;
import org.simplericity.serberuhs.SpNego;
import org.simplericity.serberuhs.SpNegoResult;
import org.simplericity.serberuhs.exceptions.NoKerberosMechException;
import org.simplericity.serberuhs.exceptions.NtlmTokenException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerberosFilterCoreStrategy
implements InterceptAuthStrategy {
    private static final Logger log = LoggerFactory.getLogger(RequestInterceptor.class);
    private final KerbConfManager kerbConfManager;
    private final FailureListener failureListener;
    private final AuditLogFacade auditLogFacade;
    private final HostApp hostApp;
    private final UserLookupService userLookupService;

    public KerberosFilterCoreStrategy(FailureListener failureListener, AuditLogFacade auditLogFacade, RequireAdminServletDependencyBucket bucket) {
        this.kerbConfManager = bucket.getKerbConfManager();
        this.failureListener = failureListener;
        this.auditLogFacade = auditLogFacade;
        this.userLookupService = bucket.getUserLookupService();
        this.hostApp = bucket.getHostApp();
    }

    @Override
    public InterceptResult apply(HttpServletRequestFacade request, HttpServletResponseFacade response) {
        if (this.shouldDoKerberos(request, response)) {
            return this.performKerberosAuthentication(request, response);
        }
        return InterceptResult.continueNext();
    }

    public InterceptResult performKerberosAuthentication(HttpServletRequestFacade req, HttpServletResponseFacade res) {
        byte[] serverToken;
        DecodedKerberosToken decodedKerberosToken;
        String atz = req.getHeader("Authorization");
        if (atz == null || !atz.startsWith("Negotiate ")) {
            this.kerbConfManager.getStats().attempt();
            return InterceptResult.of("Sending WWW-authenticate for Kerberos").setType(InterceptExitCondition.DISPATCH_TO_LOGIN).setWriteResponseCallback((CheckedFunction2<HttpServletRequestFacade, HttpServletResponseFacade, Void>)(CheckedFunction2 & Serializable)(request, response) -> {
                log.debug("Sending WWW-Authenticate header to IP: " + req.getRemoteAddr() + ", X-forwarded-for: " + req.getHeader("x-forwarded-for") + ", UserAgent: " + req.getHeader("User-Agent"));
                response.setStatus(401);
                response.setHeader("WWW-Authenticate", "Negotiate");
                return null;
            }).build();
        }
        SpNego spNego = new SpNego();
        log.info("Performing login with modern Kerberos implementation.");
        try {
            decodedKerberosToken = this.kerbConfManager.decodeKerberosToken(req);
        }
        catch (Exception e) {
            if (e instanceof NtlmTokenException) {
                this.kerbConfManager.getStats().wrongTokenNtlm();
                log.info("Negotiate token is an NTLM token from client " + this.kerbConfManager.getRemoteIpAddress(req));
                this.failureListener.failed(LoginAttempt.attempt("Client sent SPNego token with wrapped NTLM token.", this.kerbConfManager.getRemoteIpAddress(req)).token(atz).exception(e), req.getRequestURI());
            } else if (e instanceof SpNego.DirectNtlmTokenException) {
                this.kerbConfManager.getStats().wrongTokenNtlm();
                log.info("Client sent an NTLM token from client " + this.kerbConfManager.getRemoteIpAddress(req));
                this.failureListener.failed(LoginAttempt.attempt("Client sent an NTLM token instead of Kerberos/SPNEGO", this.kerbConfManager.getRemoteIpAddress(req)).token(atz).exception(e), req.getRequestURI());
            } else if (e instanceof NoKerberosMechException) {
                this.kerbConfManager.getStats().wrongTokenNotKerberos();
                log.info("Negotiate token does not have any Kerberos tokens from client " + this.kerbConfManager.getRemoteIpAddress(req));
                this.failureListener.failed(LoginAttempt.attempt("Client sent an SPNEGO token wrapping a non-Kerberos token", this.kerbConfManager.getRemoteIpAddress(req)).token(atz).exception(e), req.getRequestURI());
            } else {
                this.failureListener.failed(LoginAttempt.attempt("Failed to parse the client token", this.kerbConfManager.getRemoteIpAddress(req)).token(atz).exception(e), req.getRequestURI());
                this.kerbConfManager.getStats().failedDecodingToken();
                log.error("Exception decoding SPNEGO token from client " + this.kerbConfManager.getRemoteIpAddress(req), (Throwable)e);
            }
            log.debug("shouldDoKerberos() -> dispatchToLogin");
            return InterceptResult.of("Failed kerberos. Dispatch to login for fallback").setType(InterceptExitCondition.DISPATCH_TO_LOGIN).setWriteResponseCallback((CheckedFunction2<HttpServletRequestFacade, HttpServletResponseFacade, Void>)(CheckedFunction2 & Serializable)(request, response) -> {
                response.setStatus(401);
                return null;
            }).build();
        }
        try {
            Subject subject = this.kerbConfManager.getSubject(decodedKerberosToken);
            serverToken = spNego.negotiate(subject, (HttpServletRequest)req, (HttpServletResponse)res);
        }
        catch (Throwable e) {
            log.error("Unexpected error negotiating SPNEGO token ", e);
            this.auditLogFacade.loginFailed(null, "Kerberos", "Unexpected error negotiating SPNEGO token.");
            return InterceptResult.of("Unexpected error negotiating SPNEGO token").setType(InterceptExitCondition.PASS_DOWN_FILTER_CHAIN).build();
        }
        if (spNego.getResult() == SpNegoResult.AUTHORIZED) {
            PrincipalEntry principalEntry = this.userLookupService.lookupUserForKerberos(spNego.getAuthorizedPrincipal(), true);
            if (!principalEntry.getPrincipal().isPresent()) {
                this.failureListener.failed(LoginAttempt.attempt("User account not found", this.kerbConfManager.getRemoteIpAddress(req)).token(atz).user(spNego.getAuthorizedPrincipal()), req.getRequestURI());
                this.kerbConfManager.getStats().missingUser();
                log.debug("Kerberos ticket OK -> User account not found");
                this.auditLogFacade.loginFailed(spNego.getAuthorizedPrincipal(), "Kerberos", "User account not found.");
                req.setAttribute("usernameAnonymousUser", (Object)spNego.getAuthorizedPrincipal());
                return InterceptResult.of("Kerberos ticket OK -> User account not found").setType(InterceptExitCondition.DISPATCH_TO_LOGIN).build();
            }
            Principal principal = principalEntry.getPrincipal().get();
            this.hostApp.publishUserAuthenticatedEvent(principal, req, res);
            if (principalEntry.getUserState() == PrincipalEntry.UserState.INACTIVE) {
                this.failureListener.failed(LoginAttempt.attempt("User account is not active", this.kerbConfManager.getRemoteIpAddress(req)).token(atz).user(principal.getName()), req.getRequestURI());
                this.kerbConfManager.getStats().lacksPermission();
                log.debug("Kerberos ticket OK -> User account not active");
                this.auditLogFacade.loginFailed(principal.getName(), "Kerberos", "User account not active.");
                return InterceptResult.of("Kerberos ticket OK -> User account not active").setType(InterceptExitCondition.DISPATCH_TO_LOGIN).build();
            }
            if (!this.hostApp.isUserInRequiredGroups(principal.getName())) {
                this.failureListener.failed(LoginAttempt.attempt("User account lacks required group(s) " + StringUtils.join(this.kerbConfManager.getRequiredGroups(), (String)","), this.kerbConfManager.getRemoteIpAddress(req)).token(atz).user(principal.getName()), req.getRequestURI());
                this.kerbConfManager.getStats().lacksRequiredGroup();
                if (!this.kerbConfManager.isUserdetailsInCommentsEnabled()) {
                    this.refreshKerberosLockout(req);
                }
                log.debug("Kerberos ticket OK -> User account lacks required group(s)");
                this.auditLogFacade.loginFailed(principal.getName(), "Kerberos", "User account lacks required group(s).");
                return InterceptResult.of("Kerberos ticket OK -> User account lacks required group(s)").setType(InterceptExitCondition.DISPATCH_TO_LOGIN).setWriteResponseCallback((CheckedFunction2<HttpServletRequestFacade, HttpServletResponseFacade, Void>)(CheckedFunction2 & Serializable)(request, response) -> {
                    request.setAttribute("usernameAnonymousUser", (Object)principal.getName());
                    return null;
                }).build();
            }
            if (this.hostApp.shouldRequireCanLogin(req) && !this.hostApp.canLogin(principal, req)) {
                this.failureListener.failed(LoginAttempt.attempt("User account lacks login permission", this.kerbConfManager.getRemoteIpAddress(req)).token(atz).user(principal.getName()), req.getRequestURI());
                this.kerbConfManager.getStats().lacksPermission();
                log.debug("Kerberos ticket OK -> User account lacks canUse/canLogin");
                this.auditLogFacade.loginFailed(principal.getName(), "Kerberos", "User account lacks canUse/canLogin.");
                req.setAttribute("usernameAnonymousUser", (Object)principal.getName());
                return InterceptResult.of("Kerberos ticket OK -> User account lacks canUse/canLogin").setType(InterceptExitCondition.DISPATCH_TO_LOGIN).build();
            }
            if (this.kerbConfManager.getKerberosUserPermission() == KerbConfManager.KerberosUserPermissionType.ENABLE_ALL_USERS) {
                if (serverToken != null && serverToken.length > 0) {
                    res.setHeader("WWW-Authenticate", String.format("Negotiate %s", Base64.getEncoder().encodeToString(serverToken)));
                }
                return InterceptResult.of("Kerberos succeeded.").setType(InterceptExitCondition.LOGIN_SUCCESS).setPrincipal(principal).setAuthMethod(AuthMethod.KERBEROS).build();
            }
            if (this.kerbConfManager.getKerberosUserPermission() == KerbConfManager.KerberosUserPermissionType.ENABLE_SOME_USERS) {
                ArrayList<Directory> dirsAllowing = new ArrayList();
                try {
                    dirsAllowing = this.userLookupService.getDirectoriesAllowingKerberosLogin();
                }
                catch (RuntimeException e) {
                    log.warn("Not able to search for directories: " + e.getMessage());
                }
                if (this.userLookupService.isUserInAllowedDirectoryOrGroup(dirsAllowing, this.hostApp, this.kerbConfManager.getAllowKerberosLoginGroups(), this.kerbConfManager.getDisallowKerberosLoginGroups(), principal.getName(), AuthMethod.KERBEROS)) {
                    return InterceptResult.of("Successful Kerberos auth").setType(InterceptExitCondition.LOGIN_SUCCESS).setPrincipal(principal).setAuthMethod(AuthMethod.KERBEROS).build();
                }
                return this.getInterceptExitConditionForFailedKerberosAuthentication(req);
            }
            return this.getInterceptExitConditionForFailedKerberosAuthentication(req);
        }
        if (spNego.getResult() == SpNegoResult.AUTHORIZATION_FAILED) {
            this.failureListener.failed(LoginAttempt.attempt("Failed to validate client token", this.kerbConfManager.getRemoteIpAddress(req)).token(atz).exception(spNego.getException()), req.getRequestURI());
            this.auditLogFacade.loginFailed(null, "Kerberos", "Failed to validate client token.");
            this.kerbConfManager.getStats().authFailed();
        } else if (spNego.getResult() == SpNegoResult.WRONG_TOKEN_BASIC) {
            this.failureListener.failed(LoginAttempt.attempt("Client sent a Basic token", this.kerbConfManager.getRemoteIpAddress(req)).token(atz), req.getRequestURI());
            this.auditLogFacade.loginFailed(null, "Kerberos", "Client sent a Basic token.");
            this.kerbConfManager.getStats().wrongTokenBasic();
        } else if (spNego.getResult() == SpNegoResult.WRONG_TOKEN_NTLM) {
            this.failureListener.failed(LoginAttempt.attempt("Client sent an NTLM token", this.kerbConfManager.getRemoteIpAddress(req)).token(atz), req.getRequestURI());
            this.auditLogFacade.loginFailed(null, "Kerberos", "Client sent an NTLM token.");
            this.kerbConfManager.getStats().wrongTokenNtlm();
        } else if (spNego.getResult() == SpNegoResult.WRONG_TOKEN_NOT_NEGOTIATE) {
            this.failureListener.failed(LoginAttempt.attempt("Client sent a non-Negotiate token", this.kerbConfManager.getRemoteIpAddress(req)).token(atz), req.getRequestURI());
            this.auditLogFacade.loginFailed(null, "Kerberos", "Client sent a non-Negotiate token.");
            this.kerbConfManager.getStats().wrongTokenNotNegotiate();
        } else if (spNego.getResult() == SpNegoResult.FAILED_PARSING_TOKEN) {
            this.failureListener.failed(LoginAttempt.attempt("Failed parsing token", this.kerbConfManager.getRemoteIpAddress(req)).token(atz), req.getRequestURI());
            this.auditLogFacade.loginFailed(null, "Kerberos", "Failed parsing token.");
            this.kerbConfManager.getStats().failedParsingToken();
        }
        res.setStatus(401);
        log.debug("Kerberos ticket INVALID -> dispatchToLogin fallback");
        return InterceptResult.of("Kerberos ticket INVALID -> distpatch to login fallback").setType(InterceptExitCondition.DISPATCH_TO_LOGIN).build();
    }

    private InterceptResult getInterceptExitConditionForFailedKerberosAuthentication(HttpServletRequestFacade req) {
        if (this.hostApp.isRestApi(HttpUrlUtils.getInternalPath((HttpServletRequestFacade)req))) {
            return InterceptResult.of("Passing down filter chain").setType(InterceptExitCondition.PASS_DOWN_FILTER_CHAIN).build();
        }
        return InterceptResult.of("Dispatch to login fallback").setType(InterceptExitCondition.DISPATCH_TO_LOGIN).build();
    }

    public boolean shouldDoKerberos(HttpServletRequestFacade req, HttpServletResponseFacade res) {
        if (req.getSessionKsso().getAttribute("nokerberosSession") != null || HttpUrlUtils.querystringHas((String)"nokerberos", (HttpServletRequestFacade)req)) {
            log.debug("nokerberosSession url parameter is set. Skipping Kerberos");
            return false;
        }
        if (this.hostApp.shouldAvoidKerberosDueToLogout(req)) {
            log.debug("User is trying to log out. Skipping Kerberos...");
            return false;
        }
        if (!this.kerbConfManager.isKerberosEnabled() && this.userLookupService.getDirectoriesAllowingKerberosLogin().isEmpty() && this.kerbConfManager.getAllowKerberosLoginGroups().isEmpty() && this.kerbConfManager.getDisallowKerberosLoginGroups().isEmpty()) {
            log.debug("Kerberos disabled. Skipping Kerberos...");
            return false;
        }
        if (!this.kerbConfManager.isKeytabConfigured()) {
            log.debug("Keytab is not configured. Skipping Kerberos");
            return false;
        }
        if (!this.kerbConfManager.isUserAgentEnabled(req.getHeader("User-agent"))) {
            log.debug("User agent not enabled to perform Kerberos. Skipping Kerberos...");
            return false;
        }
        String internalPathOfReq = HttpUrlUtils.getInternalPath((HttpServletRequestFacade)req);
        String remoteIpAddress = this.kerbConfManager.getRemoteIpAddress(req);
        boolean isRestApi = this.hostApp.isRestApi(internalPathOfReq);
        IpRestrictionConfig ipRestrictionConfig = this.kerbConfManager.getIpRestrictionConfig();
        if (!isRestApi && !ipRestrictionConfig.getGlobalIpFilter().isRemoteAddressEnabled(remoteIpAddress)) {
            log.debug("Non-rest request where the remote address is not enabled for Kerberos. Skipping Kerberos");
            return false;
        }
        if (isRestApi && !ipRestrictionConfig.getRestIpFilter().isRemoteAddressEnabled(remoteIpAddress)) {
            log.debug("Rest request where the remote address is not enabled for Kerberos. Skipping Kerberos");
            return false;
        }
        if (this.hostApp.shouldLoginManually(req, res)) {
            log.debug("User is trying to log off. Skipping kerberos...");
            return false;
        }
        if (!this.hostApp.shouldDoKerberosForURL(req)) {
            log.debug("User should not authenticate with Kerberos for this URL {}. Skipping kerberos...", (Object)req.getRequestURI());
            return false;
        }
        HttpSession session = req.getSession(false);
        if (session != null) {
            long secondsSinceLockout;
            Long lockoutTime = (Long)session.getAttribute("lockout_timestamp");
            long l = secondsSinceLockout = lockoutTime == null ? Long.MAX_VALUE : TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - lockoutTime);
            if (secondsSinceLockout < 1800L) {
                if (log.isDebugEnabled()) {
                    log.debug("Not initiating SPNEGO/WWW-Authenticate for request to '{}': Previous lockout {} seconds ago.", (Object)req.getRequestURI(), (Object)secondsSinceLockout);
                }
                this.failureListener.failed(LoginAttempt.attempt("Client session in temporary Kerberos lockout (user missing required group(s))", this.kerbConfManager.getRemoteIpAddress(req)), req.getRequestURI());
                this.kerbConfManager.getStats().kerberosLockout();
                return false;
            }
        }
        log.debug("shouldDoKerberos -> true");
        return true;
    }

    private void refreshKerberosLockout(HttpServletRequestFacade req) {
        req.getSession(true).setAttribute("lockout_timestamp", (Object)System.nanoTime());
    }
}

