/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.upgrade;

import io.vavr.collection.List;
import io.vavr.control.Option;
import javax.inject.Inject;
import org.jetbrains.annotations.Nullable;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.apitokens.ApiTokenService;
import org.kantega.atlaskerb.backup.BackupService;
import org.kantega.atlaskerb.hostapp.HostAppFactory;
import org.kantega.atlaskerb.restapi.access.TokenEndpointService;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.upgrade.configuration.ActiveObjectsUpgrade;
import org.kantega.atlaskerb.upgrade.configuration.ApiTokenConfigurationUpgrade;
import org.kantega.atlaskerb.upgrade.configuration.GlobalConfigUpgrade;
import org.kantega.atlaskerb.upgrade.configuration.IdpConfigurationUpgrade;
import org.kantega.atlaskerb.upgrade.configuration.KerberosSettingsUpgrade;
import org.kantega.atlaskerb.upgrade.data.UpgradeMessage;
import org.kantega.atlaskerb.upgrade.data.UpgradePluginSettingsEntryResult;
import org.kantega.atlaskerb.userlookup.UserLookupService;
import org.kantega.atlaskerb.utils.InternetAddressUtils;
import org.kantega.atlaskerb.utils.ListParseUtils;
import org.kantega.atlaskerb.utils.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class KssoUpgradeManager {
    private static final Logger log = LoggerFactory.getLogger(KssoUpgradeManager.class);
    private final KerbConfManager kerbConfManager;
    private final ApiTokenService apiTokenService;
    private final TokenEndpointService tokenEndpointService;
    private final IdpConfManager idpConfManager;
    private final BackupService backupService;
    private final GlobalConfigUpgrade globalConfigUpgrade;
    private final IdpConfigurationUpgrade idpConfigurationUpgrade;
    private final ActiveObjectsUpgrade activeObjectsSettingsUpgrade;
    private final ApiTokenConfigurationUpgrade apiTokenConfigurationUpdate;
    private final KerberosSettingsUpgrade kerberosSettingsUpgrade;

    @Inject
    public KssoUpgradeManager(KerbConfManager kerbConfManager, ApiTokenService apiTokenService, TokenEndpointService tokenEndpointService, HostAppFactory hostAppFactory, IdpConfManager idpConfManager, BackupService backupService, UserLookupService userLookupService) {
        this.kerbConfManager = kerbConfManager;
        this.apiTokenService = apiTokenService;
        this.tokenEndpointService = tokenEndpointService;
        this.globalConfigUpgrade = new GlobalConfigUpgrade(kerbConfManager, userLookupService, hostAppFactory.getInstance());
        this.idpConfManager = idpConfManager;
        this.idpConfigurationUpgrade = new IdpConfigurationUpgrade(idpConfManager, kerbConfManager);
        this.activeObjectsSettingsUpgrade = new ActiveObjectsUpgrade(apiTokenService, tokenEndpointService, kerbConfManager);
        this.backupService = backupService;
        this.apiTokenConfigurationUpdate = new ApiTokenConfigurationUpgrade(kerbConfManager);
        this.kerberosSettingsUpgrade = new KerberosSettingsUpgrade(kerbConfManager, userLookupService);
    }

    public List<UpgradeMessage> doUpgrade() {
        log.info("Running upgrade routine of Kantega SSO Enterprise.");
        try {
            if (!this.isKssoConfigUpgradeNeeded()) {
                log.info("Config already up to date. Skipping upgrade.");
                return List.of((Object)new UpgradeMessage(ResultCode.SUCCESS, "Configuration is already up to date."));
            }
            log.info("Version change indicates upgrade of Kantega SSO Enterprise needed.");
            boolean isBackupSuccess = this.saveBackupOfConfig();
            if (!isBackupSuccess) {
                return List.of((Object)new UpgradeMessage(ResultCode.FAILURE, "Failed to take a backup of config. Upgrade was aborted."));
            }
            List upgradeMessages = this.globalConfigUpgrade.run().appendAll(this.activeObjectsSettingsUpgrade.run()).appendAll(this.idpConfigurationUpgrade.run()).appendAll(this.apiTokenConfigurationUpdate.run()).appendAll(this.kerberosSettingsUpgrade.run());
            if (upgradeMessages.forAll(UpgradeMessage::isSuccess)) {
                log.info("Successful upgrade of Kantega SSO Enterprise. Updating version in config.");
                try {
                    this.kerbConfManager.upgradeKssoVersionInConfig();
                    return upgradeMessages.append((Object)new UpgradeMessage(ResultCode.SUCCESS, "Updated version in config"));
                }
                catch (Exception e) {
                    log.error("Encountered an error while updating the version of config.");
                    return upgradeMessages.append((Object)new UpgradeMessage(ResultCode.VERSION_CHANGE_FAILURE, "Could not update the configuration version. Please re-try to confirm the update."));
                }
            }
            log.warn("Failed to update some settings during configuration upgrade of Kantega SSO Enterprise:");
            log.info("Successful updates: " + (String)upgradeMessages.filter(UpgradeMessage::isSuccess).map(UpgradeMessage::toString).intersperse((Object)", ").foldLeft((Object)"", String::concat));
            log.warn("Failed updates: " + (String)upgradeMessages.filter(UpgradeMessage::isFailure).map(UpgradeMessage::toString).intersperse((Object)", ").foldLeft((Object)"", String::concat));
            return upgradeMessages;
        }
        catch (Exception e) {
            String msg = "Encountered an error during configuration upgrade of Kantega SSO Enterprise. Please try again or refer to the logs for more information about what went wrong.";
            log.error("Encountered an error during configuration upgrade of Kantega SSO Enterprise. Please try again or refer to the logs for more information about what went wrong.", (Throwable)e);
            return List.of((Object)new UpgradeMessage(ResultCode.FAILURE, "Encountered an error during configuration upgrade of Kantega SSO Enterprise. Please try again or refer to the logs for more information about what went wrong."));
        }
    }

    public boolean isAnyDataConfigured() {
        return this.kerbConfManager.isAnySettingsConfigured() || this.idpConfManager.isAnySettingsConfigured() || this.idpConfManager.isAnyProvidersSaved() || this.apiTokenService.isAnyApiTokensConfigured() || this.tokenEndpointService.isAnyTokenEndpointsConfigured();
    }

    public static String dataWithErrorMessages(List<UpgradePluginSettingsEntryResult> upgradeFailures, KerbConfManager.KEYS configurationKey) {
        return (String)upgradeFailures.find(upgradeConfigEntryResult -> upgradeConfigEntryResult.getOldConfigurationKey() == configurationKey).map(UpgradePluginSettingsEntryResult::getDataWithErrorMessages).getOrNull();
    }

    public boolean isUpgradeFromMajorVersion4OrUnknown() {
        return (Boolean)this.kerbConfManager.getSavedKssoConfigVersion().map(Version::getMajor).map(major -> major < 5).getOrElse((Object)true);
    }

    public boolean isBreakingChangesInNewVersion() {
        Version runningVersion = KerbConfManager.getRunningKssoVersion();
        Option<Version> maybeSavedKssoVersion = this.kerbConfManager.getSavedKssoConfigVersion();
        boolean runningVersionIsSavedConfigVersion = maybeSavedKssoVersion.exists(v -> v.equals((Object)runningVersion)) || runningVersion.isEmpty() && maybeSavedKssoVersion.isEmpty();
        return !runningVersionIsSavedConfigVersion && (this.isUpgradeFromMajorVersion4OrUnknown() || this.activeObjectsSettingsUpgrade.isBreakingChanges() || this.globalConfigUpgrade.isBreakingChanges() || this.idpConfigurationUpgrade.isBreakingChanges() || this.apiTokenConfigurationUpdate.isBreakingChanges() || this.kerberosSettingsUpgrade.isBreakingChanges());
    }

    public static boolean isUpdateApiTokenFromBeforeVersion43(Version savedVersion, Version runningVersion) {
        Version lastVersionBeforeBreakingApiToken = new Version("4.3.0");
        return savedVersion.compareTo(lastVersionBeforeBreakingApiToken) <= 0 && runningVersion.compareTo(lastVersionBeforeBreakingApiToken) > 0;
    }

    public static boolean isUpdateApiTokenFromBeforeVersion57(Version savedVersion, Version runningVersion) {
        Version versionWithNewApiTokens = new Version("5.7.0");
        return !KssoUpgradeManager.isUpdateApiTokenFromBeforeVersion43(savedVersion, runningVersion) && savedVersion.compareTo(versionWithNewApiTokens) < 0;
    }

    public boolean isKssoConfigUpgradeNeeded() {
        return this.isBreakingChangesInNewVersion() && (this.isAnyDataConfigured() || this.kerbConfManager.hasKerberosFolder());
    }

    public List<UpgradePluginSettingsEntryResult> getUpgradeFailures() {
        return this.globalConfigUpgrade.getUpdateFailures();
    }

    public boolean hasBadVersionUpgrade() {
        Version runningKssoVersion = KerbConfManager.getRunningKssoVersion();
        return (Boolean)this.kerbConfManager.getSavedKssoConfigVersion().filter(v -> v.isHigherThanOrEqualTo(Version.of((String)"6.27.0")) && v.isLowerThan(Version.of((String)"7.27.0"))).filter(_v -> runningKssoVersion.isHigherThanOrEqualTo(Version.of((String)"7.27.0")) && runningKssoVersion.getMajor() == 7).map(configVersion -> configVersion.isMinorVersionNumberHigherThan(runningKssoVersion)).getOrElse((Object)false);
    }

    public boolean isBreakingVersionDowngrade() {
        Version runningKssoVersion = KerbConfManager.getRunningKssoVersion();
        return (Boolean)this.kerbConfManager.getSavedKssoConfigVersion().map(configVersion -> configVersion.isHigherThan(runningKssoVersion)).getOrElse((Object)false);
    }

    public Version recommendedVersionOnBadUpgrade() {
        Version runningKssoVersion = KerbConfManager.getRunningKssoVersion();
        int runningKssoMajorVersion = runningKssoVersion.getMajor();
        int runningKssoPatchVersion = runningKssoVersion.getPatch();
        return (Version)this.kerbConfManager.getSavedKssoConfigVersion().map(Version::getMinor).map(fromVersionNumber -> Version.of((int)runningKssoMajorVersion, (int)fromVersionNumber, (int)runningKssoPatchVersion)).getOrElse((Object)Version.empty());
    }

    public boolean hasUpgradeFailures() {
        return this.globalConfigUpgrade.hasUpgradeFailures();
    }

    public void removeUpgradeFailureAfterFix(KerbConfManager.KEYS oldConfigurationKey) {
        this.globalConfigUpgrade.removeUpdateFailureAfterFix(oldConfigurationKey);
    }

    @Nullable
    public static String onlyIpRestrictErrorMessagesCommaSeparated(List<UpgradePluginSettingsEntryResult> upgradeFailures, KerbConfManager.KEYS key) {
        return (String)upgradeFailures.find(upgradeConfigEntryResult -> upgradeConfigEntryResult.getOldConfigurationKey() == key).map(UpgradePluginSettingsEntryResult::getDataWithErrorMessages).map(ListParseUtils::parseListFromNewlines).map(KssoUpgradeManager::onlyIpRestrictErrorMessagesCommaSeparated).getOrNull();
    }

    @Nullable
    public static String onlyIpRestrictErrorMessagesCommaSeparated(List<String> ipRestrictionPermissions) {
        return (String)Option.of(ipRestrictionPermissions).map(p -> p.filter(InternetAddressUtils::isNotValidExistingPermission)).map(ListParseUtils::iterableToCommaSeparatedAndSpacedString).getOrNull();
    }

    private boolean saveBackupOfConfig() {
        Version runningKssoVersion = KerbConfManager.getRunningKssoVersion();
        Option savedKssoVersion = this.kerbConfManager.getSavedKssoConfigVersion().peek(version -> log.info("Migrating the Kantega SSO Enterprise configuration from version " + version.stringValue + " to version " + runningKssoVersion.stringValue)).onEmpty(() -> log.info("Migrating the Kantega SSO Enterprise configuration from <unknown version>  to version " + runningKssoVersion.stringValue));
        log.info("Preparing for configuration upgrade: Create a backup of Kantega SSO Enterprise configuration...");
        try {
            this.backupService.createBackup("Backup before upgrade of config from version " + (String)savedKssoVersion.map(Version::stringValue).getOrElse((Object)"<unknown version>") + " to " + runningKssoVersion.stringValue);
            return true;
        }
        catch (Exception e) {
            log.error("We encountered an error while saving backup of Kantega SSO Enterprise configuration: ", (Throwable)e);
            return false;
        }
    }

    public static enum ResultCode {
        SUCCESS("SUCCESS"),
        FAILURE("FAILURE"),
        VERSION_CHANGE_FAILURE("VERSION_CHANGE_FAILURE"),
        NONE("NONE");

        private final String value;

        private ResultCode(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

