/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.connector.admin;

import com.atlassian.crowd.embedded.api.DirectorySynchronisationInformation;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.exception.DirectoryInstantiationException;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.kantegasso.servlet.http.HttpServletRequestFacade;
import com.kantegasso.servlet.http.HttpServletResponseFacade;
import com.ksso.scim.ScimProviderKind;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.kantega.atlaskerb.DateTool;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.apiserver.ApiServerConfManager;
import org.kantega.atlaskerb.connector.ConnectorConfManager;
import org.kantega.atlaskerb.connector.ConnectorType;
import org.kantega.atlaskerb.connector.admin.CrowdDirectoryFinder;
import org.kantega.atlaskerb.connector.model.Directory;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.scim.ScimConfManager;
import org.kantega.atlaskerb.wrapper.crowd.CrowdDirectoryWrapper;
import org.kantega.atlaskerb.wrapper.crowd.DirSyncInformationWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProvisioningOverviewAction
extends RequireAdminServlet {
    private final TemplateRenderer renderer;
    private final ApplicationProperties applicationProperties;
    private final ConnectorConfManager connectorConfManager;
    private final HostApp hostApp;
    private final ApiServerConfManager apiServerConfManager;
    private final ScimConfManager scimConfManager;
    private final DirectoryManager directoryManager;
    private final Logger log = LoggerFactory.getLogger(ProvisioningOverviewAction.class);

    @Inject
    public ProvisioningOverviewAction(RequireAdminServletDependencyBucket bucket, ApiServerConfManager apiServerConfManager, ScimConfManager scimConfManager) {
        super(bucket);
        this.renderer = bucket.getTemplateRenderer();
        this.applicationProperties = bucket.getApplicationProperties();
        this.connectorConfManager = bucket.getConnectorConfManager();
        this.hostApp = bucket.getHostApp();
        this.apiServerConfManager = apiServerConfManager;
        this.scimConfManager = scimConfManager;
        this.directoryManager = this.hostApp.getDirectoryManager();
    }

    protected void doGetKsso(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
        this.connectorConfManager.readState();
        this.scimConfManager.readState();
        Map<String, Object> model = this.newModel(req);
        model.put("displayName", this.applicationProperties.getDisplayName());
        model.put("topMenu", "connectors");
        model.put("menuItem", "provisioningOverview");
        model.put("scimEnabled", this.scimConfManager.isScimEnabled());
        List<Directory> directories = this.connectorConfManager.getDirectories();
        model.put("directories", directories);
        model.put("connectorTypes", new HashMap<String, ConnectorType>(this.connectorConfManager.getConnectorTypes()));
        model.put("scimTenantConfigKinds", Arrays.asList(ScimProviderKind.values()));
        model.put("directoryFinder", new CrowdDirectoryFinder(this.hostApp));
        HashMap<String, DirSyncInformationWrapper> dirsyncPerDirectory = new HashMap<String, DirSyncInformationWrapper>();
        CrowdDirectoryFinder crowdDirectoryFinder = new CrowdDirectoryFinder(this.hostApp);
        for (Directory d : directories) {
            com.atlassian.crowd.embedded.api.Directory cd = crowdDirectoryFinder.findDirectory(d.getId());
            if (cd == null) continue;
            try {
                DirectorySynchronisationInformation directorySynchronisationInformation = this.directoryManager.getDirectorySynchronisationInformation(cd.getId().longValue());
                dirsyncPerDirectory.put(d.getId(), new DirSyncInformationWrapper(directorySynchronisationInformation));
            }
            catch (DirectoryInstantiationException | DirectoryNotFoundException e) {
                this.log.error("Failed to get directory synchronisation information for directory {}", (Object)d.getId(), (Object)e);
            }
        }
        model.put("dirSyncsPerDirectory", dirsyncPerDirectory);
        model.put("staleCrowdDirectories", this.findStaleCrowdDirectoriesForVelocity(directories));
        model.put("dateTool", new DateTool());
        model.put("scimDirectories", new ArrayList(this.scimConfManager.getScimDirectories().asJava()));
        model.put("staleInternalDirectories", new ArrayList(this.scimConfManager.findStaleInternalDirectoriesForVelocity().asJava()));
        model.put("staleTenantConfigs", new ArrayList(this.scimConfManager.findStaleTenantConfigs().asJava()));
        try {
            this.scimConfManager.findStaleTenantConfigs().forEach(this.scimConfManager::saveOrUpdate);
        }
        catch (Exception e) {
            this.log.error("Error while recreating stale tenant configs", (Throwable)e);
        }
        resp.setContentType("text/html");
        this.renderer.render("templates/atlaskerb/connector/provisioning-overview.vm", model, (Writer)resp.getWriter());
    }

    private List<com.atlassian.crowd.embedded.api.Directory> findStaleCrowdDirectories(List<Directory> connectors) {
        HashSet<String> connectorIds = new HashSet<String>();
        for (Directory connector : connectors) {
            connectorIds.add(connector.getId());
        }
        String serverURL = this.apiServerConfManager.getCrowdServerUrl();
        ArrayList<com.atlassian.crowd.embedded.api.Directory> stales = new ArrayList<com.atlassian.crowd.embedded.api.Directory>();
        for (com.atlassian.crowd.embedded.api.Directory d : this.hostApp.getCrowdDirectoryService().findAllDirectories()) {
            if (d.getType() != DirectoryType.CROWD || !serverURL.equals(d.getAttributes().get("crowd.server.url")) || connectorIds.contains(d.getAttributes().get("application.name"))) continue;
            stales.add(d);
        }
        return stales;
    }

    private List<CrowdDirectoryWrapper> findStaleCrowdDirectoriesForVelocity(List<Directory> connectors) {
        HashSet<String> connectorIds = new HashSet<String>();
        for (Directory connector : connectors) {
            connectorIds.add(connector.getId());
        }
        String serverURL = this.apiServerConfManager.getCrowdServerUrl();
        ArrayList<CrowdDirectoryWrapper> stales = new ArrayList<CrowdDirectoryWrapper>();
        for (com.atlassian.crowd.embedded.api.Directory d : this.hostApp.getCrowdDirectoryService().findAllDirectories()) {
            if (d.getType() != DirectoryType.CROWD || !serverURL.equals(d.getAttributes().get("crowd.server.url")) || connectorIds.contains(d.getAttributes().get("application.name"))) continue;
            stales.add(new CrowdDirectoryWrapper(d));
        }
        return stales;
    }

    @Override
    protected void doPostKsso(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
        String operation;
        switch (operation = req.getParameter("operation")) {
            case "deleteConnector": {
                String deleteConnector = req.getParameter("deleteConnector");
                this.connectorConfManager.deleteConnector(deleteConnector);
                break;
            }
            case "removeStaleInternalDirectory": {
                long id = Long.parseLong(req.getParameter("directoryId"));
                this.scimConfManager.deleteInternalDirectory(id);
                break;
            }
            case "removeStaleTenantConfiguration": 
            case "removeScimDirectoryConfig": {
                String tenantId = req.getParameter("tenantId");
                this.scimConfManager.deleteScimDirectoryAndTenantConfig(tenantId);
                break;
            }
        }
        resp.sendRedirect("overview");
    }

    public static class DirsyncTool {
        private final DirectoryManager directoryManager;

        public DirsyncTool(DirectoryManager directoryManager) {
            this.directoryManager = directoryManager;
        }

        public DirectorySynchronisationInformation getDirsync(com.atlassian.crowd.embedded.api.Directory directory) throws DirectoryInstantiationException, DirectoryNotFoundException {
            return this.directoryManager.getDirectorySynchronisationInformation(directory.getId().longValue());
        }
    }
}

