/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.utils;

import com.atlassian.sal.api.user.UserManager;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONObject;

public class GroupSearchUtil {
    public static void printGroupsAsJson(HttpServletResponse resp, String query, UserManager userManager) throws IOException {
        resp.setContentType("application/json");
        PrintWriter w = resp.getWriter();
        JSONObject jsonObject = new JSONObject();
        LinkedHashSet groupNames = new LinkedHashSet();
        for (String groupName : userManager.findGroupNamesByPrefix(query, 0, 100)) {
            TreeMap<String, String> group = new TreeMap<String, String>();
            group.put("id", groupName);
            group.put("name", groupName);
            groupNames.add(group);
        }
        jsonObject.put("groups", groupNames);
        w.print(jsonObject);
    }

    public static List<Map<String, String>> getGroupsAsListMap(String query, UserManager userManager) {
        ArrayList<Map<String, String>> groupNames = new ArrayList<Map<String, String>>();
        for (String groupName : userManager.findGroupNamesByPrefix(query, 0, 100)) {
            TreeMap<String, String> group = new TreeMap<String, String>();
            group.put("id", groupName);
            group.put("name", groupName);
            groupNames.add(group);
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("groups", groupNames);
        return groupNames;
    }
}

