/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.scim.admin;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.UserQuery;
import com.atlassian.crowd.search.query.entity.restriction.BooleanRestriction;
import com.atlassian.crowd.search.query.entity.restriction.BooleanRestrictionImpl;
import com.atlassian.crowd.search.query.entity.restriction.MatchMode;
import com.atlassian.crowd.search.query.entity.restriction.NullRestrictionImpl;
import com.atlassian.crowd.search.query.entity.restriction.TermRestriction;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.templaterenderer.TemplateRenderer;
import io.vavr.control.Option;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.scim.ScimConfManager;
import org.kantega.atlaskerb.scim.ScimDirectory;
import org.kantega.atlaskerb.wrapper.crowd.CrowdUserWrapper;

public class DirectoryUsersAction
extends RequireAdminServlet {
    private final ApplicationProperties applicationProperties;
    private final TemplateRenderer renderer;
    private final HostApp hostApp;
    private final ScimConfManager scimConfManager;

    @Inject
    public DirectoryUsersAction(RequireAdminServletDependencyBucket bucket, ScimConfManager scimConfManager) {
        super(bucket);
        this.applicationProperties = bucket.getApplicationProperties();
        this.renderer = bucket.getTemplateRenderer();
        this.hostApp = bucket.getHostApp();
        this.scimConfManager = scimConfManager;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Map<String, Object> model = this.newModel(req);
        String tenantId = req.getParameter("tenantId");
        String filter = req.getParameter("filter");
        Option<ScimDirectory> maybeDirectory = this.scimConfManager.getScimDirectory(tenantId);
        if (maybeDirectory.isEmpty()) {
            resp.sendError(404);
            return;
        }
        ScimDirectory scimDirectory = (ScimDirectory)maybeDirectory.get();
        int startIndex = 0;
        if (req.getParameter("start-index") != null) {
            startIndex = Integer.parseInt(req.getParameter("start-index"));
        }
        model.put("topMenu", "connectors");
        model.put("menuItem", "scimDirectoryUsers");
        model.put("displayName", this.applicationProperties.getDisplayName());
        model.put("userFilter", filter);
        Object filterRestriction = filter == null || filter.trim().isEmpty() ? NullRestrictionImpl.INSTANCE : new BooleanRestrictionImpl(BooleanRestriction.BooleanLogic.OR, new SearchRestriction[]{new TermRestriction(UserTermKeys.DISPLAY_NAME, MatchMode.CONTAINS, (Object)filter), new TermRestriction(UserTermKeys.EMAIL, MatchMode.CONTAINS, (Object)filter)});
        this.render(scimDirectory, resp, model, (SearchRestriction)filterRestriction, startIndex);
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String startIndex;
        String tenantId = req.getParameter("tenantId");
        String operation = req.getParameter("operation");
        String userName = req.getParameter("userName");
        Option<ScimDirectory> maybeDirectory = this.scimConfManager.getScimDirectory(tenantId);
        if (maybeDirectory.isEmpty()) {
            resp.sendError(404);
            return;
        }
        ScimDirectory scimDirectory = (ScimDirectory)maybeDirectory.get();
        if ("deleteUser".equals(operation)) {
            DirectoryManager directoryManager = this.hostApp.getDirectoryManager();
            try {
                directoryManager.removeUser(scimDirectory.getDirectoryId(), userName);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        String query = "?tenantId=" + tenantId;
        String filter = req.getParameter("filter");
        if (StringUtils.isNotEmpty((CharSequence)filter)) {
            query = query + "&filter=" + filter;
        }
        if (StringUtils.isNotEmpty((CharSequence)(startIndex = req.getParameter("start-index")))) {
            query = query + "&start-index=" + startIndex;
        }
        resp.sendRedirect("users" + query);
    }

    private void render(ScimDirectory scimDirectory, HttpServletResponse resp, Map<String, Object> model, SearchRestriction restriction, int startIndex) throws IOException {
        try {
            boolean isFirst;
            DirectoryManager directoryManager = this.hostApp.getDirectoryManager();
            Directory dir = scimDirectory.getDirectory();
            int maxResults = 50;
            List directoryUsers = directoryManager.searchUsers(dir.getId().longValue(), (EntityQuery)new UserQuery(User.class, restriction, startIndex, maxResults));
            ArrayList<CrowdUserWrapper> users = new ArrayList<CrowdUserWrapper>();
            for (User user : directoryUsers) {
                users.add(new CrowdUserWrapper(user));
            }
            model.put("currentScimDirectory", scimDirectory);
            model.put("directoryUsers", users);
            model.put("firstIndex", startIndex + 1);
            model.put("lastIndex", startIndex + users.size());
            boolean isMore = maxResults == users.size();
            boolean bl = isFirst = startIndex == 0;
            if (isMore) {
                model.put("nextIndex", startIndex + users.size());
            }
            if (!isFirst) {
                model.put("prevIndex", startIndex - maxResults);
            }
            resp.setContentType("text/html");
            resp.setCharacterEncoding(StandardCharsets.UTF_8.name());
            this.renderer.render("templates/atlaskerb/scim/users.vm", model, (Writer)resp.getWriter());
        }
        catch (DirectoryNotFoundException | OperationFailedException e) {
            throw new RuntimeException(e);
        }
    }
}

