/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.connector.azure;

import org.kantega.atlaskerb.connector.azure.AzureConnectorPropUtil;
import org.kantega.atlaskerb.connector.azure.AzureGraphHttpClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AzureGraphHttpClientBuilder {
    private String loginBase;
    private String tenantId;
    private String applicationId;
    private String clientSecret;
    private AzureConnectorPropUtil azureConnectorPropUtil;

    @Autowired
    public void setAzureConnectorPropUtil(AzureConnectorPropUtil azureConnectorPropUtil) {
        this.azureConnectorPropUtil = azureConnectorPropUtil;
    }

    public static AzureGraphHttpClientBuilder createAzureGraphHttpClientBuilder() {
        return new AzureGraphHttpClientBuilder();
    }

    public AzureGraphHttpClientBuilder setLoginBase(String loginBase) {
        this.loginBase = loginBase;
        return this;
    }

    public AzureGraphHttpClientBuilder setTenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public AzureGraphHttpClientBuilder setApplicationId(String applicationId) {
        this.applicationId = applicationId;
        return this;
    }

    public AzureGraphHttpClientBuilder setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    public AzureGraphHttpClient build() {
        return new AzureGraphHttpClient(this.loginBase, this.tenantId, this.applicationId, this.clientSecret);
    }
}

